/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.users;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import ru.ssa.artixadmin.editors.directory.users.MolEditPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Mol;
import ru.ssa.cashadmin.domain.MolServerV216;
import ru.ssa.cashadmin.domain.MolV171;
import ru.ssa.cashadmin.domain.Roleuser;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditDialog;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class MolEditDialog
extends DirectoryEditDialog<Mol> {
    private MolEditPanel molEditPanel;
    private int minLengthPasswd;

    public MolEditDialog(Shell parentShell, Mol model, DialogMode dialogMode) {
        super(parentShell, (Object)model, dialogMode);
        try {
            this.minLengthPasswd = Integer.getInteger("mol.min.password.length", 1);
        }
        catch (Exception exception) {
            this.minLengthPasswd = 1;
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        super.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0441\u0441\u0438\u0440\u0430", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0430\u0441\u0441\u0438\u0440\u0430");
        super.setMessage("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0441\u0441\u0438\u0440\u0430", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u0441\u0441\u0438\u0440\u0430", 1);
        return contents;
    }

    protected EditorComposite<Mol> getEditPanel(Composite parent, Mol model) {
        this.molEditPanel = new MolEditPanel(parent, 0, model);
        this.molEditPanel.setParentDialog(this);
        this.molEditPanel.initialize();
        return this.molEditPanel;
    }

    protected boolean customValidate(Mol domain, DirectoryEditModel<Mol> directoryModel) {
        if (StringUtils.length((String)domain.getPassword()) < this.minLengthPasswd) {
            this.setErrorMessage("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c " + this.minLengthPasswd + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        return super.customValidate((Object)domain, directoryModel);
    }

    public void saveAction(SelectionEvent event, boolean closeAfterSave) {
        Mol state = (Mol)LibActivator.getDefault().getActualClassResolver().getInstance(Mol.class);
        state.setLogin(((Mol)this.getActualModel()).getLogin());
        List listLogin = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Mol.class).getList((Object)state);
        state = (Mol)LibActivator.getDefault().getActualClassResolver().getInstance(Mol.class);
        state.setPassword(((Mol)this.getActualModel()).getPassword());
        List listPassword = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Mol.class).getList((Object)state);
        if (((Mol)this.getOldModel()).getLogin() != null && ((Mol)this.getOldModel()).getPassword() != null) {
            if (!((Mol)this.getOldModel()).getLogin().equals(((Mol)this.getActualModel()).getLogin()) && !listLogin.isEmpty()) {
                this.errorDuplicateLoginMessage();
            } else if (!((Mol)this.getOldModel()).getPassword().equals(((Mol)this.getActualModel()).getPassword()) && !listPassword.isEmpty()) {
                this.errorDuplicatePasswordMessage();
            } else {
                this.saveDomain(event, closeAfterSave);
            }
        } else if (!listLogin.isEmpty()) {
            this.errorDuplicateLoginMessage();
        } else if (!listPassword.isEmpty()) {
            this.errorDuplicatePasswordMessage();
        } else {
            this.saveDomain(event, closeAfterSave);
        }
    }

    private void errorDuplicateLoginMessage() {
        this.setErrorMessage("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u043b\u043e\u0433\u0438\u043d\u043e\u043c " + ((Mol)this.getActualModel()).getLogin() + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
    }

    private void errorDuplicatePasswordMessage() {
        this.setErrorMessage("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u043f\u0430\u0440\u043e\u043b\u0435\u043c " + ((Mol)this.getActualModel()).getPassword() + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
    }

    private void saveDomain(SelectionEvent event, boolean closeAfterSave) {
        MolV171 curModel;
        Mol model = (Mol)this.molEditPanel.getModel();
        if (model instanceof MolV171) {
            curModel = (MolV171)model;
            if (!model.getPassword().equals(((Mol)this.getOldModel()).getPassword()) || curModel.getPasswordupdatetime() == null) {
                curModel.setPasswordupdatetime(new Date());
            }
        } else if (model instanceof MolServerV216) {
            curModel = (MolServerV216)model;
            if (!model.getPassword().equals(((Mol)this.getOldModel()).getPassword()) || curModel.getPasswordupdatetime() == null) {
                curModel.setPasswordupdatetime(new Date());
            }
        }
        super.saveAction(event, closeAfterSave);
        for (Map.Entry<Roleuser, String> entry : this.molEditPanel.getHashRoleUsers().entrySet()) {
            entry.getKey().setUser((Mol)this.getActualModel());
        }
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Roleuser.class).updateActionsMap(this.molEditPanel.getHashRoleUsers());
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(((Mol)this.getActualModel()).getClass()).doRefresh();
    }
}

