/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import ru.ssa.artixadmin.editors.directory.goods.InventBarcodesEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.InventEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.InventInventSaleRestrictEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.InventPricesEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.TmcTpricesEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.TmccatalogEditPanel;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalog;
import ru.ssa.cashadmin.domain.InventPrice;
import ru.ssa.cashadmin.domain.InventSaleRestrict;
import ru.ssa.cashadmin.domain.Prices;
import su.artix.discountmanager.Activator;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditDialog;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class InventEditDialog
extends DirectoryEditDialog<Invent> {
    private InventEditPanel panel;
    private boolean enableGtinButton;
    private String ntin;

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        super.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430");
        super.setMessage("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u0432\u0430\u0440", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u0432\u0430\u0440", 1);
        return contents;
    }

    protected EditorComposite<Invent> getEditPanel(Composite parent, Invent model) {
        this.panel = new InventEditPanel(parent, 0, model);
        this.panel.setParentDialog(this);
        this.panel.initialize();
        return this.panel;
    }

    public InventEditDialog(Shell parentShell, Invent model, DialogMode dialogMode) {
        super(parentShell, (Object)model, dialogMode);
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.enableGtinButton = preferenceStore.getBoolean("ENABLE_GTIN_BUTTON");
    }

    protected boolean customValidate(Invent domain, DirectoryEditModel<Invent> directoryModel) {
        if (this.enableGtinButton) {
            if (StringUtils.isEmpty((String)this.ntin)) {
                this.setErrorMessage("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 GS1 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430");
                return false;
            }
            Set<String> mxikCodes = this.panel.getMxikCodes();
            if (!mxikCodes.isEmpty() && !mxikCodes.contains(this.ntin)) {
                this.setErrorMessage("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 " + this.ntin + " \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u0442 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430\u043c \u0442\u043e\u0432\u0430\u0440\u0430");
                return false;
            }
            if (!this.panel.isValidNtin()) {
                this.setErrorMessage("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 " + this.ntin + " \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                return false;
            }
        }
        return super.customValidate((Object)domain, directoryModel);
    }

    public void saveAction(SelectionEvent event, boolean closeAfterSave) {
        Map<InventSaleRestrict, String> saleRestrictMap = ((InventInventSaleRestrictEditPanel)this.panel.getSaleRestrictPanel()).getTmcSaleRestrictContentProvider().getMap();
        Long next = (Long)ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventSaleRestrict.class).getNext("salerestrictcodeInt", null);
        for (InventSaleRestrict key : saleRestrictMap.keySet()) {
            key.setTmccode(((Invent)this.panel.getModel()).getCode());
            if (key.getSalerestrictcode() != null || "REMOVE".equals(saleRestrictMap.get(key))) continue;
            key.setSalerestrictcode(String.valueOf(next));
            next = next + 1L;
        }
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventSaleRestrict.class).updateActionsMap(saleRestrictMap);
        Map<InventPrice, String> tpricesCollection = ((TmcTpricesEditPanel)this.panel.getTpricePanel()).getTpricesContentProvider().getMap();
        for (InventPrice key : tpricesCollection.keySet()) {
            if (this.panel.getModel() == null) continue;
            key.setBcode(((Invent)this.panel.getModel()).getBcode());
        }
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventPrice.class).updateActionsMap(tpricesCollection);
        Map<InventCatalog, String> tmccatalogMap = ((TmccatalogEditPanel)this.panel.getTmccatalogPanel()).getTmccatalogContentProvider().getMap();
        for (InventCatalog key : tmccatalogMap.keySet()) {
            key.setTmc((Invent)this.panel.getModel());
        }
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventCatalog.class).updateActionsMap(tmccatalogMap);
        Map<Barcodes, String> barcodesMap = ((InventBarcodesEditPanel)this.panel.getBarcodesPanel()).getBarcodesContentProvider().getMap();
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Barcodes.class).updateActionsMap(barcodesMap);
        Map<Prices, String> pricesMap = ((InventPricesEditPanel)this.panel.getPricesPanel()).getPricesContentProvider().getMap();
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Prices.class).updateActionsMap(pricesMap);
        super.saveAction(event, closeAfterSave);
    }

    public boolean close() {
        this.panel.dispose();
        return super.close();
    }

    public String getNtin() {
        return this.ntin;
    }

    public void setNtin(String ntin) {
        this.ntin = ntin;
    }
}

