/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.observable;

import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;

public final class AutoincCodes {
    public static boolean checkCodesDiscountCampaign(DiscountCampaignGroup discountCampaignGroup, Long code) {
        DiscountCampaignGroup rootGroup = AutoincCodes.getRootGroup(discountCampaignGroup);
        return AutoincCodes.checkCodesDiscountCampaignInOneGroup(rootGroup, code);
    }

    public static boolean checkCodesDiscount(DiscountCampaign discountCampaign, Long code) {
        DiscountCampaignGroup rootGroup = AutoincCodes.getRootGroup((DiscountCampaignGroup)discountCampaign.getParent());
        return AutoincCodes.checkCodesDiscountInOneGroup(rootGroup, code);
    }

    private static DiscountCampaignGroup getRootGroup(DiscountCampaignGroup currentGroup) {
        if (currentGroup.getParent() != null && currentGroup.getParent() instanceof DiscountCampaignGroup) {
            return AutoincCodes.getRootGroup((DiscountCampaignGroup)currentGroup.getParent());
        }
        return currentGroup;
    }

    private static boolean checkCodesDiscountCampaignInOneGroup(DiscountCampaignGroup currentGroup, Long code) {
        if (!currentGroup.getDiscountCampaigns().isEmpty()) {
            for (DiscountCampaign discountCampaign : currentGroup.getDiscountCampaigns()) {
                if (!discountCampaign.getId().equals(code)) continue;
                return true;
            }
        }
        if (!currentGroup.getSubGroups().isEmpty()) {
            for (DiscountCampaignGroup discountCampaignGroup : currentGroup.getSubGroups()) {
                if (!AutoincCodes.checkCodesDiscountCampaignInOneGroup(discountCampaignGroup, code)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkCodesDiscountInOneGroup(DiscountCampaignGroup currentGroup, Long code) {
        if (!currentGroup.getDiscountCampaigns().isEmpty()) {
            for (DiscountCampaign currentCampaign : currentGroup.getDiscountCampaigns()) {
                if (currentCampaign.getDiscounts().isEmpty()) continue;
                for (Discount discount : currentCampaign.getDiscounts()) {
                    if (!discount.getId().equals(code)) continue;
                    return true;
                }
            }
        }
        if (!currentGroup.getSubGroups().isEmpty()) {
            for (DiscountCampaignGroup element : currentGroup.getSubGroups()) {
                if (!AutoincCodes.checkCodesDiscountInOneGroup(element, code)) continue;
                return true;
            }
        }
        return false;
    }
}

