/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.validator;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeObservableValue
extends AbstractObservableValue {
    private static final Logger log = LoggerFactory.getLogger(DateTimeObservableValue.class);
    private final DateTime dateTime;
    private Date oldValue;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            Date newValue = DateTimeObservableValue.this.dateTimeToDate();
            if (!newValue.equals(DateTimeObservableValue.this.oldValue)) {
                DateTimeObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)DateTimeObservableValue.this.oldValue, (Object)newValue));
                DateTimeObservableValue.this.oldValue = newValue;
            }
        }
    };

    public DateTimeObservableValue(DateTime dateTime) {
        this.dateTime = dateTime;
        this.dateTime.addListener(13, this.listener);
    }

    protected Object doGetValue() {
        return this.dateTimeToDate();
    }

    protected void doSetValue(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            this.dateToDateTime(date);
        }
    }

    public Object getValueType() {
        return Date.class;
    }

    private void dateToDateTime(Date date) {
        if (!this.dateTime.isDisposed()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (this.dateTime.getData().equals("Calendar")) {
                this.dateTime.setYear(cal.get(1));
                this.dateTime.setMonth(cal.get(2));
                this.dateTime.setDay(cal.get(5));
            } else if (this.dateTime.getData().equals("Time")) {
                this.dateTime.setHours(cal.get(11));
                this.dateTime.setMinutes(cal.get(12));
                this.dateTime.setSeconds(cal.get(13));
            } else {
                this.dateTime.setYear(cal.get(1));
                this.dateTime.setMonth(cal.get(2));
                this.dateTime.setDay(cal.get(5));
                this.dateTime.setHours(cal.get(11));
                this.dateTime.setMinutes(cal.get(12));
                this.dateTime.setSeconds(cal.get(13));
            }
        }
        log.trace("{}", (Object)this.dateTime);
    }

    private Date dateTimeToDate() {
        Date result = null;
        if (!this.dateTime.isDisposed()) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.dateTime.getYear());
            cal.set(2, this.dateTime.getMonth());
            cal.set(5, this.dateTime.getDay());
            cal.set(11, this.dateTime.getHours());
            cal.set(12, this.dateTime.getMinutes());
            cal.set(13, this.dateTime.getSeconds());
            result = cal.getTime();
        }
        log.trace("{}", result);
        return result;
    }

    public synchronized void dispose() {
        this.dateTime.removeListener(13, this.listener);
        super.dispose();
    }
}

