/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.lazyload.LoadUtils;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.editors.ParentDialog;
import su.artix.yuki.model.ChangeIdValueException;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public abstract class DirectoryEditDialog<T>
extends ParentDialog {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEditDialog.class);
    private final int APPLY_ID = 30;
    private final Map<String, Boolean> validateMap = new HashMap<String, Boolean>();
    private DialogMode dialogMode;
    private final T model;
    private final T oldModel;
    private String[] idField;
    private Object oldId;
    private boolean enabledButtons = false;
    private EditorComposite<T> editPanel;
    private Button applayButton;
    private Button okButton;
    private Button cancelButton;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private DirectoryEditModel<T> directoryEditModel;
    private boolean applayButtonVisisble = true;
    private final PropertyChangeListener validatorListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().equals(true)) {
                DirectoryEditDialog.this.validateMap.remove(evt.getPropertyName());
            } else {
                DirectoryEditDialog.this.validateMap.put(evt.getPropertyName(), false);
            }
            DirectoryEditDialog.this.enabledButtons = DirectoryEditDialog.this.validateMap.isEmpty();
            DirectoryEditDialog.this.setEnabledButtons(DirectoryEditDialog.this.enabledButtons);
        }
    };
    private static final Map<SqlErrorMatcher, Pattern> errorPatterns = MapUtils.putAll(new HashMap(), (Object[])new Object[]{SqlErrorMatcher.DUPLICATE_ENTRY_MATCHER, Pattern.compile("Duplicate entry '(.+)' for key '(.+)'")});

    public DialogMode getDialogMode() {
        return this.dialogMode;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private Button createUserButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected abstract EditorComposite<T> getEditPanel(Composite var1, T var2);

    protected Control createDialogArea(Composite parent) {
        this.editPanel = this.getEditPanel(parent, this.model);
        this.editPanel.applyRights();
        Object initedModel = this.editPanel.getModel();
        if (this.dialogMode == DialogMode.CREATE) {
            this.editPanel.initDefault(initedModel);
        }
        this.editPanel.bindValues();
        if (this.dialogMode == DialogMode.CREATE || this.dialogMode == DialogMode.COPY) {
            if (!DomainUtils.isComposite(initedModel.getClass(), (String)DomainUtils.getIdColum(initedModel.getClass()))) {
                DomainUtils.setIdValue(initedModel, null);
            }
            this.editPanel.switchID();
        } else {
            this.setOldId(initedModel);
        }
        this.editPanel.setLayoutData(new GridData(4, 4, true, true));
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        if (this.dialogMode == DialogMode.READ_ONLY) {
            boolean hasChild = false;
            for (EditorComposite<T> panel : this.editPanel.getChildPanels()) {
                Control[] controlArray = panel.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setEnabled(false);
                    ++n2;
                }
                hasChild = true;
            }
            if (!hasChild) {
                this.editPanel.setEnabled(false);
            }
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createUserButton(parent, 0, "\u041e\u041a", false);
        this.okButton.setEnabled(this.enabledButtons);
        this.okButton.setFocus();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryEditDialog.this.saveAction(event, true);
            }
        });
        this.applayButton = this.dialogMode == DialogMode.CREATE || this.dialogMode == DialogMode.COPY ? this.createUserButton(parent, 30, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", false) : this.createUserButton(parent, 30, "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", false);
        this.applayButton.setEnabled(this.enabledButtons);
        this.applayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryEditDialog.this.saveAction(event, false);
            }
        });
        this.applayButton.setVisible(this.applayButtonVisisble);
        this.cancelButton = this.createUserButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryEditDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (this.dialogMode == DialogMode.READ_ONLY) {
            this.okButton.setVisible(false);
            this.applayButton.setVisible(false);
            this.cancelButton.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        }
    }

    protected void doAfterSave(T domain, DialogMode dialogMode) {
    }

    protected void doWithDomain(T domain, DialogMode dialogMode) {
        if (dialogMode == DialogMode.UPDATE) {
            LoadUtils loadUtils = GuiActivator.getDefault().getBeanByClass(LoadUtils.class);
            loadUtils.deepCopyCollection(this.oldModel, domain, false);
        } else if (dialogMode == DialogMode.COPY) {
            LoadUtils loadUtils = GuiActivator.getDefault().getBeanByClass(LoadUtils.class);
            loadUtils.deepCopyCollection(this.oldModel, domain, true);
        }
    }

    public DirectoryEditDialog(Shell parentShell, T model, DialogMode dialogMode) {
        this(parentShell, model, dialogMode, null);
    }

    public DirectoryEditDialog(Shell parentShell, T model, DialogMode dialogMode, String ... idField) {
        super(parentShell);
        this.dialogMode = dialogMode;
        this.model = model;
        this.idField = idField;
        this.oldModel = model;
    }

    public void saveAction(SelectionEvent event, boolean closeAfterSave) {
        log.trace("begin save action");
        Object domain = this.editPanel.getActualModel();
        this.doWithDomain(domain, this.dialogMode);
        try {
            if (this.customValidate(domain, this.getDirectoryEditModel(domain))) {
                DirectoryEditModel directoryModel = this.getDirectoryEditModel(domain);
                if (this.dialogMode == DialogMode.CREATE || this.dialogMode == DialogMode.COPY) {
                    directoryModel.doAdd(domain);
                    if (!closeAfterSave) {
                        this.editPanel.switchID();
                    }
                } else {
                    directoryModel.doSave(domain, this.oldId, this.getOldModel(), this.idField);
                    this.setOldId(domain);
                }
                this.doAfterSave(domain, this.dialogMode);
                this.setErrorMessage(null);
                this.setMessage("\u0414\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b", 1);
                if (closeAfterSave) {
                    this.buttonPressed((Integer)event.widget.getData());
                }
            }
        }
        catch (DuplicateValueException e) {
            log.trace(e.getMessage(), (Throwable)e);
            this.setErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e.");
        }
        catch (ChangeIdValueException e) {
            log.trace(e.getMessage(), (Throwable)e);
            this.setErrorMessage(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0441 %s \u043d\u0430 %s, \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438", e.getOldId(), e.getNewId()));
        }
        catch (ExecuteQueryException e) {
            log.trace(e.getMessage(), (Throwable)e);
            StringBuilder builder = new StringBuilder().append("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c. \u041e\u0448\u0438\u0431\u043a\u0430: ");
            this.getL10nErrorMessage(e, builder);
            this.setErrorMessage(builder.toString());
        }
        log.trace("end save action");
    }

    private StringBuilder getL10nErrorMessage(Throwable throwable, StringBuilder builder) {
        if (throwable.getMessage() != null) {
            for (SqlErrorMatcher sqlErrorMatcher : errorPatterns.keySet()) {
                Matcher matcher = errorPatterns.get((Object)sqlErrorMatcher).matcher(throwable.getMessage());
                if (!matcher.matches()) continue;
                switch (sqlErrorMatcher) {
                    case DUPLICATE_ENTRY_MATCHER: {
                        builder.append(" \u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u043f\u043e\u043b\u0435 \u0441\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c '").append(matcher.group(1)).append("' \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u0442!");
                        break;
                    }
                }
                return builder;
            }
        }
        if (throwable.getCause() != null) {
            return this.getL10nErrorMessage(throwable.getCause(), builder);
        }
        return builder.append(" \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 \u043b\u043e\u0433\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
    }

    protected DirectoryEditModel<T> getDirectoryEditModel(T domain) {
        if (this.directoryEditModel == null) {
            this.directoryEditModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getBaseClass(domain.getClass()));
        }
        return this.directoryEditModel;
    }

    private Class<T> getBaseClass(Class<?> clazz) {
        return LibActivator.getDefault().getActualClassResolver().getBase(clazz);
    }

    protected boolean customValidate(T domain, DirectoryEditModel<T> directoryModel) {
        return true;
    }

    protected void setOldId(T model) {
        try {
            Class<?> clazz = model.getClass();
            this.oldId = DomainUtils.isComposite(clazz, (String)DomainUtils.getIdColum(clazz)) ? BeanUtils.cloneBean((Object)DomainUtils.getIdValue(model)) : DomainUtils.getIdValue(model);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setEnabledButtons(boolean enabled) {
        if (this.applayButton != null && this.okButton != null) {
            this.applayButton.setEnabled(enabled);
            this.okButton.setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabledButtons = enabled;
    }

    public PropertyChangeListener getValidatorListener() {
        return this.validatorListener;
    }

    public void setTitle(String editTitle, String addTitle) {
        switch (this.dialogMode) {
            case CREATE: {
                this.getShell().setText(addTitle);
                break;
            }
            case UPDATE: {
                this.getShell().setText(editTitle);
                break;
            }
            case READ_ONLY: {
                this.getShell().setText("\u0420\u0415\u0416\u0418\u041c \u0422\u041e\u041b\u042c\u041a\u041e \u0414\u041b\u042f \u041f\u0420\u041e\u0421\u041c\u041e\u0422\u0420\u0410");
            }
        }
    }

    public boolean isCreate() {
        return this.dialogMode == DialogMode.CREATE;
    }

    public void setMessage(String editMessage, String addMessage, int type) {
        if (this.dialogMode == DialogMode.CREATE) {
            super.setMessage(addMessage, type);
        } else {
            String text = editMessage;
            if (ArtixAdminContextHolder.isCashserver() && this.dialogMode != DialogMode.READ_ONLY && this.isGlobal()) {
                type = 2;
                text = "\u0417\u0430\u043f\u0438\u0441\u044c \u0438\u0437 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0439 \u0411\u0414. \u0415\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u043e\u043a\u0430\u0436\u0435\u0442 \u044d\u0444\u0444\u0435\u043a\u0442\u0430.";
            }
            super.setMessage(text, type);
        }
    }

    protected boolean isGlobal() {
        log.info("check global");
        T element = this.model;
        try {
            Object obj = PropertyUtils.getProperty(element, (String)"ownerStoreId");
            return StringUtils.equals((String)"$$all$$", (String)String.valueOf(obj));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public T getActualModel() {
        return this.editPanel.getActualModel();
    }

    public Object getOldId() {
        return this.oldId;
    }

    public T getOldModel() {
        return this.oldModel;
    }

    public void setDirectoryEditModel(DirectoryEditModel<T> directoryEditModel) {
        this.directoryEditModel = directoryEditModel;
    }

    public boolean isApplayButtonVisisble() {
        return this.applayButtonVisisble;
    }

    public void setApplayButtonVisisble(boolean applayButtonVisisble) {
        this.applayButtonVisisble = applayButtonVisisble;
    }

    private static enum SqlErrorMatcher {
        DUPLICATE_ENTRY_MATCHER;

    }
}

