/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.HotKey;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import ru.ssa.cashadmin.domain.Kbkey;
import ru.ssa.cashadmin.domain.KbkeyPK;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.yuki.converter.KeyboardKeyCodeConverter;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.MyKeyValue;
import su.artix.yuki.editors.DirectoryChoiceSelectionAdapter;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.keyboard.domain.KeyboardButtonData;
import su.artix.yuki.keyboard.domain.KeyboardContainer;
import su.artix.yuki.keyboard.gui.KeyboardButton;
import su.artix.yuki.keyboard.gui.KeyboardButtonAction;
import su.artix.yuki.keyboard.gui.KeyboardPanel;
import su.artix.yuki.model.ModelActivator;

public class KeyboardDialog
extends Dialog {
    private static Map<String, Map<Integer, Cmaction>> base;
    private KeyboardPanel panel;
    private KeyboardContainer keyboard;
    private List<Kbkey> list;
    private boolean showHotKey;

    public KeyboardDialog(Shell parentShell, KeyboardContainer keyboard, List<Kbkey> keyList) {
        super(parentShell);
        this.keyboard = keyboard.copy();
        this.list = keyList;
        base = new HashMap<String, Map<Integer, Cmaction>>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.keyboard.getName() != null) {
            newShell.setText(this.keyboard.getName());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(main);
        Composite contextPanel = new Composite(main, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(contextPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)contextPanel);
        Label contextLabel = new Label(contextPanel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)contextLabel);
        contextLabel.setText("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442: ");
        final ComboViewer contextCombo = new ComboViewer(contextPanel, 8);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)contextCombo.getCombo());
        contextCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        contextCombo.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        contextCombo.setInput((Object)Directory.kbkeyContext);
        contextCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeyboardDialog.this.changeContext(KeyboardDialog.this.getContext(contextCombo));
            }
        });
        KeyboardButtonAction action = new KeyboardButtonAction(){

            @Override
            public void press(KeyboardButton button) {
                if (button.getBtnData() != null && button.getBtnData().getCode() != 0) {
                    String context = KeyboardDialog.this.getContext(contextCombo);
                    if (context != null && !context.isEmpty()) {
                        if (KeyboardDialog.this.showHotKey) {
                            if (button.isHotKey()) {
                                KeyboardDialog.this.editHotKey(button);
                            }
                        } else {
                            KeyboardDialog.this.editAction(button, context);
                        }
                    }
                    KeyboardDialog.this.panel.updateView();
                }
            }
        };
        Button showCodes = new Button(main, 32);
        GridDataFactory.fillDefaults().applyTo((Control)showCodes);
        showCodes.setText("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448");
        Button showHotKeys = new Button(main, 32);
        GridDataFactory.fillDefaults().applyTo((Control)showHotKeys);
        showHotKeys.setText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u043e\u0440\u044f\u0447\u0438\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438");
        showHotKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                if (btn.getSelection()) {
                    KeyboardDialog.this.showHotKey = true;
                    KeyboardDialog.this.panel.setShowHotKey(true);
                } else {
                    KeyboardDialog.this.showHotKey = false;
                    KeyboardDialog.this.panel.setShowHotKey(false);
                }
            }
        });
        this.panel = new KeyboardPanel(main, 2048, this.keyboard, action);
        GridDataFactory.fillDefaults().applyTo((Control)this.panel);
        showCodes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                KeyboardDialog.this.panel.setShowCode(btn.getSelection());
            }
        });
        contextCombo.getCombo().select(0);
        this.changeContext(this.getContext(contextCombo));
        return main;
    }

    private String getContext(ComboViewer viewer) {
        MyKeyValue contextObj;
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection != null && selection.getFirstElement() instanceof MyKeyValue && (contextObj = (MyKeyValue)selection.getFirstElement()) != null && contextObj.getKey() != null) {
            return contextObj.getKey().toString();
        }
        return "";
    }

    private void changeContext(String newContext) {
        if (newContext != null && !newContext.isEmpty()) {
            HashMap<Integer, Kbkey> filteredMap = new HashMap<Integer, Kbkey>();
            for (Kbkey kbkey : this.list) {
                if (!newContext.equals(kbkey.getContext())) continue;
                filteredMap.put(kbkey.getKeycode(), kbkey);
            }
            Map<Integer, Cmaction> map = base.get(newContext);
            if (map != null) {
                for (KeyboardButtonData button : this.keyboard.getButtons()) {
                    Cmaction act = map.get(button.getCode());
                    String title = "";
                    Cmaction action = null;
                    if (act != null) {
                        title = act.getCmactionname();
                        action = act;
                    } else {
                        Kbkey key = (Kbkey)filteredMap.get(button.getCode());
                        if (key != null) {
                            title = key.getCmaction().getCmactionname();
                            action = key.getCmaction();
                        }
                    }
                    button.setTitle(title);
                    button.setCmaction(action);
                }
            } else {
                for (KeyboardButtonData button : this.keyboard.getButtons()) {
                    Kbkey key = (Kbkey)filteredMap.get(button.getCode());
                    if (key != null) {
                        button.setCmaction(key.getCmaction());
                        button.setTitle(key.getCmaction().getCmactionname());
                        continue;
                    }
                    button.setCmaction(null);
                    button.setTitle("");
                }
            }
        } else {
            for (KeyboardButtonData button : this.keyboard.getButtons()) {
                button.setCmaction(null);
                button.setTitle("");
            }
        }
        this.panel.updateView();
    }

    public List<Kbkey> getKeys() {
        ArrayList<Kbkey> resultList = new ArrayList<Kbkey>(this.list);
        for (String context : base.keySet()) {
            Map<Integer, Cmaction> map = base.get(context);
            for (Integer keyCode : map.keySet()) {
                Kbkey key = this.getKey(context, keyCode);
                if (key != null) {
                    key.setCmaction(map.get(keyCode));
                    key.setCmactioncode(map.get(keyCode).getCmactioncode());
                    continue;
                }
                Kbkey key1 = (Kbkey)LibActivator.getDefault().getActualClassResolver().getInstance(Kbkey.class);
                key1.setCmaction(map.get(keyCode));
                key1.setCmactioncode(map.get(keyCode).getCmactioncode());
                key1.setContext(context);
                key1.setKeycode(keyCode);
                key1.setKeyvalue(KeyboardKeyCodeConverter.toDisplayValue((KeyEvent)KeyboardKeyCodeConverter.fromKeycode((int)keyCode)));
                KbkeyPK pk = new KbkeyPK();
                pk.setContext(context);
                pk.setKeycode(keyCode);
                key1.setPk(pk);
                resultList.add(key1);
            }
        }
        return resultList;
    }

    private Kbkey getKey(String context, Integer keyCode) {
        for (Kbkey currentKey : this.list) {
            if (!currentKey.getContext().equals(context) || !currentKey.getKeycode().equals(keyCode)) continue;
            return currentKey;
        }
        return null;
    }

    private void editHotKey(KeyboardButton button) {
        HotKeyInvent hotkeyInvent = (HotKeyInvent)LibActivator.getDefault().getActualClassResolver().getInstance(HotKeyInvent.class);
        Integer codeCmation = button.getBtnData().getCmaction().getCmactioncode();
        Actionparameter state = (Actionparameter)LibActivator.getDefault().getActualClassResolver().getInstance(Actionparameter.class);
        state.setCmactioncode(codeCmation);
        Integer code = Integer.parseInt(((Actionparameter)ModelActivator.getDefault().getModelProvider().getDirectoryModel(Actionparameter.class).getList((Object)state).get(0)).getParametervalue());
        HotKey hotkey = (HotKey)ModelActivator.getDefault().getModelProvider().getDirectoryModel(HotKey.class).getById((Object)code);
        hotkeyInvent.setHotkey(hotkey);
        DirectorySelectDialogState dialogState = new DirectorySelectDialogState();
        ArtixFilter filter = new ArtixFilter(HotKeyInvent.class);
        filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ, new Object[]{"hotkeycode", hotkey.getHotkeycode()}));
        dialogState.setAdditionalFilter(filter);
        new DirectoryChoiceSelectionAdapter(this.getShell(), (Widget)button, (Object)hotkeyInvent, null, HotKeyInvent.class, dialogState).widgetSelected(null);
    }

    private void editAction(final KeyboardButton button, final String context) {
        new DirectoryChoiceSelectionAdapter<Cmaction>(this.getShell(), (Widget)button, (Object)button.getBtnData(), "cmaction", Cmaction.class){

            protected void customAction(Cmaction retmodel) {
                if (retmodel != null) {
                    button.getBtnData().setCmaction(retmodel);
                    button.getBtnData().setTitle(retmodel.getCmactionname());
                    if (base.get(context) == null) {
                        base.put(context, new HashMap());
                    }
                    ((Map)base.get(context)).put(button.getBtnData().getCode(), retmodel);
                }
            }
        }.widgetSelected(null);
    }
}

