/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.imageSelector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.imageSelector.ISItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class ImageSelector
extends Canvas {
    private List<ISItem> items;
    private List<ISItem> originalItems;
    private Font font;
    private static final int DEFAULT_WIDTH = 148;
    private int maxItemWidth = 148;
    private int index = -1;
    private double sigma;
    private double rho;
    private double expMultiplier;
    private double expMember;
    private float spacing = 0.4f;
    private Color gradientStart;
    private Color gradientEnd;
    private double animationStep = -1.0;
    private static final int TIMER_INTERVAL = 50;
    private int pageIncrement = 5;
    private Image cachedImage;
    private GC cachedGC;

    public ImageSelector(Composite composite, int n) {
        super(composite, n | 0x40000 | 0x20000000);
        Font font;
        this.font = font = new Font((Device)this.getDisplay(), "Lucida Sans", 24, 0);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)font);
        this.setSigma(0.5);
        this.gradientStart = this.getDisplay().getSystemColor(2);
        this.gradientEnd = SWTGraphicUtil.getDefaultColor((Control)this, 110, 110, 110);
        this.addListeners();
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.cachedGC);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.cachedImage);
    }

    private void addListeners() {
        this.addKeyListener();
        this.addMouseListeners();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ImageSelector.this.paintControl(paintEvent);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (ImageSelector.this.cachedGC == null) {
                    return;
                }
                ImageSelector.this.cachedGC.dispose();
                ImageSelector.this.cachedImage.dispose();
                ImageSelector.this.cachedImage = new Image((Device)ImageSelector.this.getDisplay(), ImageSelector.this.getClientArea());
                ImageSelector.this.cachedGC = new GC((Drawable)ImageSelector.this.cachedImage);
                ImageSelector.this.cachedGC.setAntialias(1);
            }
        });
    }

    private void addKeyListener() {
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 0x1000001: 
                    case 0x1000003: {
                        ImageSelector.this.scrollAndAnimateBy(-1);
                        break;
                    }
                    case 0x1000002: 
                    case 0x1000004: {
                        ImageSelector.this.scrollAndAnimateBy(1);
                        break;
                    }
                    case 0x1000007: {
                        ImageSelector.this.scrollBy(-1 * ImageSelector.this.index);
                        break;
                    }
                    case 0x1000008: {
                        ImageSelector.this.scrollBy(ImageSelector.this.index);
                        break;
                    }
                    case 0x1000005: {
                        ImageSelector.this.scrollBy(-1 * ImageSelector.this.pageIncrement);
                        break;
                    }
                    case 0x1000006: {
                        ImageSelector.this.scrollBy(ImageSelector.this.pageIncrement);
                    }
                }
            }
        });
    }

    private void addMouseListeners() {
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                for (ISItem iSItem : ImageSelector.this.items) {
                    if (iSItem.getUpperLeftCorner() == null || iSItem.getLowerRightCorner() == null || mouseEvent.x < iSItem.getUpperLeftCorner().x || mouseEvent.x > iSItem.getLowerRightCorner().x || mouseEvent.y < iSItem.getUpperLeftCorner().y || mouseEvent.y > iSItem.getLowerRightCorner().y) continue;
                    ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(21));
                    return;
                }
                ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(0));
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                for (ISItem iSItem : ImageSelector.this.items) {
                    if (iSItem.getUpperLeftCorner() == null || iSItem.getLowerRightCorner() == null || mouseEvent.x < iSItem.getUpperLeftCorner().x || mouseEvent.x > iSItem.getLowerRightCorner().x || mouseEvent.y < iSItem.getUpperLeftCorner().y || mouseEvent.y > iSItem.getLowerRightCorner().y) continue;
                    ImageSelector.this.scrollAndAnimateBy(ImageSelector.this.originalItems.indexOf(iSItem) - ImageSelector.this.index);
                    return;
                }
            }
        });
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ImageSelector.this.scrollBy(-1 * event.count);
            }
        });
    }

    public void setSigma(double d) {
        this.sigma = d;
        this.rho = 1.0;
        this.computeEquationParts();
        this.rho = this.computeModifierUnbounded(0.0);
        this.computeEquationParts();
        this.redraw();
    }

    private double computeModifierBounded(double d) {
        double d2 = this.computeModifierUnbounded(d);
        if (d2 > 1.0) {
            d2 = 1.0;
        } else if (d2 < -1.0) {
            d2 = -1.0;
        }
        return d2;
    }

    private double computeModifierUnbounded(double d) {
        return this.expMultiplier * Math.exp(-d * d / this.expMember);
    }

    private void computeEquationParts() {
        this.expMultiplier = Math.sqrt(Math.PI * 2) / this.sigma / this.rho;
        this.expMember = 4.0 * this.sigma * this.sigma;
    }

    private void paintControl(PaintEvent paintEvent) {
        if (this.cachedImage == null) {
            this.cachedImage = new Image((Device)this.getDisplay(), this.getClientArea());
            this.cachedGC = new GC((Drawable)this.cachedImage);
            this.cachedGC.setAntialias(1);
        }
        this.drawBackground();
        this.drawItems();
        if (this.animationStep < 0.0) {
            this.drawTitle();
        }
        paintEvent.gc.drawImage(this.cachedImage, 0, 0);
    }

    private void drawBackground() {
        Rectangle rectangle = this.getClientArea();
        this.cachedGC.setForeground(this.gradientStart);
        this.cachedGC.setBackground(this.gradientEnd);
        this.cachedGC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2, true);
        this.cachedGC.setForeground(this.gradientEnd);
        this.cachedGC.setBackground(this.gradientStart);
        this.cachedGC.fillGradientRectangle(rectangle.x, rectangle.height / 2, rectangle.width, rectangle.height / 2, true);
    }

    private void drawItems() {
        if (this.animationStep < 0.0) {
            this.items.clear();
            this.items.addAll(this.originalItems);
            for (int i = 0; i < this.items.size(); ++i) {
                ISItem iSItem = this.items.get(i);
                iSItem.setzPosition((float)(i - this.index) * this.spacing);
            }
            Collections.sort(this.items);
        }
        for (ISItem iSItem : this.items) {
            this.drawItem(iSItem);
        }
    }

    private void drawItem(ISItem iSItem) {
        int n = this.computeSize(iSItem);
        int n2 = this.computeZPosition(iSItem);
        int n3 = this.getClientArea().height / 2;
        if (n <= 0 || n2 < 0 || n2 > this.getBounds().width) {
            iSItem.resetCornerToNull();
            return;
        }
        int n4 = this.computeAlpha(iSItem);
        Image image = SWTGraphicUtil.createReflectedResizedImage(iSItem.getImage(), n, n);
        this.cachedGC.setAlpha(n4);
        int n5 = n2 - image.getBounds().width / 2;
        int n6 = n3 - image.getBounds().height / 2;
        this.cachedGC.drawImage(image, n5, n6);
        iSItem.setUpperLeftCorner(n5, n6);
        iSItem.setLowerRightCorner(n5 + image.getBounds().width, (int)((double)n6 + (double)image.getBounds().height / 1.5));
        image.dispose();
    }

    private int computeZPosition(ISItem iSItem) {
        int n = this.getClientArea().width / 2;
        int n2 = this.getClientArea().width / 2;
        return (int)((double)n2 + iSItem.getzPosition() * (double)n);
    }

    private int computeSize(ISItem iSItem) {
        return (int)(this.computeModifierBounded(iSItem.getzPosition()) * (double)this.maxItemWidth);
    }

    private int computeAlpha(ISItem iSItem) {
        return (int)(255.0 - 150.0 * Math.abs(iSItem.getzPosition()));
    }

    private void drawTitle() {
        String string = this.originalItems.get(this.index).getText();
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.cachedGC.setFont(this.getFont());
        Point point = this.cachedGC.stringExtent(string);
        this.cachedGC.setFont(this.getFont());
        this.cachedGC.setForeground(this.getDisplay().getSystemColor(1));
        this.cachedGC.setAlpha(255);
        int n = this.getClientArea().width / 2;
        int n2 = (this.getClientArea().height + this.maxItemWidth) / 2;
        this.cachedGC.drawString(string, n - point.x / 2, n2 - point.y / 2, true);
    }

    private void scrollBy(int n) {
        this.index += n;
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index >= this.items.size()) {
            this.index = this.items.size() - 1;
        }
        this.redraw();
    }

    private void scrollAndAnimateBy(final int n) {
        double d;
        if (this.index == 0 && n < 0 || this.index == this.items.size() - 1 && n > 0) {
            return;
        }
        this.animationStep = d = (double)Math.abs(n) / 6.0;
        this.setCursor(this.getDisplay().getSystemCursor(1));
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                this.startAnimation(n, d);
            }

            private void startAnimation(int n2, double d2) {
                ImageSelector.this.items.clear();
                ImageSelector.this.items.addAll(ImageSelector.this.originalItems);
                for (int i = 0; i < ImageSelector.this.items.size(); ++i) {
                    ISItem iSItem = (ISItem)ImageSelector.this.items.get(i);
                    iSItem.setzPosition(((double)(i - ImageSelector.this.index) + ImageSelector.this.animationStep * (n2 > 0 ? -1.0 : 1.0)) * (double)ImageSelector.this.spacing);
                }
                Collections.sort(ImageSelector.this.items);
                if (!ImageSelector.this.isDisposed()) {
                    ImageSelector.this.redraw();
                }
                ImageSelector.this.animationStep += d2;
                if (ImageSelector.this.animationStep >= 1.0) {
                    ImageSelector.this.animationStep = -1.0;
                    ImageSelector.this.index += n2;
                    ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(0));
                } else if (!ImageSelector.this.isDisposed()) {
                    ImageSelector.this.getDisplay().timerExec(50, (Runnable)this);
                }
            }
        });
    }

    public List<ISItem> getItems() {
        return this.originalItems;
    }

    public void setItems(List<ISItem> list) {
        this.items = new ArrayList<ISItem>(list);
        this.originalItems = list;
        this.index = this.items.size() / 2;
        this.redraw();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.redraw();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
        this.redraw();
    }

    public int getMaxItemWidth() {
        return this.maxItemWidth;
    }

    public void setMaxItemWidth(int n) {
        this.maxItemWidth = n;
        this.redraw();
    }

    public double getSigma() {
        return this.sigma;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float f) {
        this.spacing = f;
        this.redraw();
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color color) {
        this.gradientStart = color;
        this.redraw();
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color color) {
        this.gradientEnd = color;
        this.redraw();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setPageIncrement(int n) {
        this.pageIncrement = n;
    }
}

