/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

abstract class HmacCore
extends MacSpi
implements Cloneable {
    private MessageDigest md;
    private byte[] k_ipad;
    private byte[] k_opad;
    private boolean first;
    private final int blockLen;

    HmacCore(String string, int n) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        if (!(messageDigest instanceof Cloneable)) {
            Provider provider = Security.getProvider("SUN");
            if (provider != null) {
                messageDigest = MessageDigest.getInstance(string, provider);
            } else {
                Provider[] providerArray;
                String string2 = messageDigest.getProvider().getName();
                for (Provider provider2 : providerArray = Security.getProviders()) {
                    try {
                        MessageDigest messageDigest2;
                        if (provider2.getName().equals(string2) || !((messageDigest2 = MessageDigest.getInstance(string, provider2)) instanceof Cloneable)) continue;
                        messageDigest = messageDigest2;
                        break;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
            }
        }
        this.md = messageDigest;
        this.blockLen = n;
        this.k_ipad = new byte[this.blockLen];
        this.k_opad = new byte[this.blockLen];
        this.first = true;
    }

    @Override
    protected int engineGetMacLength() {
        return this.md.getDigestLength();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Missing key data");
        }
        if (byArray.length > this.blockLen) {
            byte[] byArray2 = this.md.digest(byArray);
            Arrays.fill(byArray, (byte)0);
            byArray = byArray2;
        }
        for (int i = 0; i < this.blockLen; ++i) {
            byte by = i < byArray.length ? byArray[i] : (byte)0;
            this.k_ipad[i] = (byte)(by ^ 0x36);
            this.k_opad[i] = (byte)(by ^ 0x5C);
        }
        Arrays.fill(byArray, (byte)0);
        byArray = null;
        this.engineReset();
    }

    @Override
    protected void engineUpdate(byte by) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(byteBuffer);
    }

    @Override
    protected byte[] engineDoFinal() {
        if (this.first) {
            this.md.update(this.k_ipad);
        } else {
            this.first = true;
        }
        try {
            byte[] byArray = this.md.digest();
            this.md.update(this.k_opad);
            this.md.update(byArray);
            this.md.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    @Override
    protected void engineReset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HmacCore hmacCore = (HmacCore)super.clone();
        hmacCore.md = (MessageDigest)this.md.clone();
        hmacCore.k_ipad = (byte[])this.k_ipad.clone();
        hmacCore.k_opad = (byte[])this.k_opad.clone();
        return hmacCore;
    }

    public static final class HmacSHA512
    extends HmacCore {
        public HmacSHA512() throws NoSuchAlgorithmException {
            super("SHA-512", 128);
        }
    }

    public static final class HmacSHA384
    extends HmacCore {
        public HmacSHA384() throws NoSuchAlgorithmException {
            super("SHA-384", 128);
        }
    }

    public static final class HmacSHA256
    extends HmacCore {
        public HmacSHA256() throws NoSuchAlgorithmException {
            super("SHA-256", 64);
        }
    }

    public static final class HmacSHA224
    extends HmacCore {
        public HmacSHA224() throws NoSuchAlgorithmException {
            super("SHA-224", 64);
        }
    }
}

