/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.InventCatalog;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.discountsystem.DiscountObjectKitItemDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.providers.discountsystem.DiscountRateKitLabelProvider;
import su.artix.discountmanager.tables.DiscountObjectKitTableViewer;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKitItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitItem;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.MyKeyValue;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

@SecurityKey(title="\u041e\u0431\u044a\u0435\u043a\u0442 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442")
public class DiscountObjectKitPanel
extends EditorComposite<DiscountObjectKit> {
    private static final Logger log = LoggerFactory.getLogger(DiscountObjectKitPanel.class);
    private DiscountObjectKitTableViewer tableViewer;
    @SecurityKey(title="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c")
    private ChangeRowAction changeRowAction = new ChangeRowAction();
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c")
    private DeleteRowAction deleteRowAction = new DeleteRowAction();
    private List<DiscountRateKitItem> ratedItems;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="name")
    private Label nameLabel;
    @SecurityKey(id="name")
    private Text nameValField;
    @SecurityKey(title="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0432 \u043d\u0430\u0431\u043e\u0440\u0435", id="maxtimes")
    private Label maxtimesLabel;
    @SecurityKey(id="maxtimes")
    private Spinner maxtimesSpinner;
    @SecurityKey(id="maxTimesNotSpecified", title="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0432 \u043d\u0430\u0431\u043e\u0440\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e")
    private Button maxtimesCheckedButton;
    @SecurityKey(title="\u041f\u0430\u043d\u0435\u043b\u044c")
    private Composite composite;
    @SecurityKey(title="\u0422\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430", id="kittype")
    private Label kittypeLabel;
    @SecurityKey(id="kittype")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_STRING, id="kittype", subField="combo")
    private ComboViewer kittypeCombo;
    private static final boolean saveInventSupportInKids = Boolean.getBoolean("discount.save_invent_support_in_kids");

    public DiscountObjectKitPanel(Composite parent, int style, Class<DiscountObjectKit> clazz, DiscountObjectKit model) {
        super(parent, style, clazz, (Object)model);
    }

    public DiscountObjectKitPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    protected DiscountObjectKit getActualModel(DiscountObjectKit model) {
        if (!saveInventSupportInKids) {
            this.checkKitType(model);
        }
        DiscountObjectKit discountObjectKit = new DiscountObjectKit();
        FieldsUtils.copyOnlyAnnotatedProperties(model, discountObjectKit, ((Object)((Object)this)).getClass());
        discountObjectKit.setKittype(model.getKittype());
        Discount discount = new Discount("temp");
        discount.addDiscountObject((DiscountObject)discountObjectKit);
        Cloner cloner = new Cloner();
        cloner.dontCloneInstanceOf(new Class[]{PropertyChangeSupport.class});
        cloner.dontClone(new Class[]{DiscountCampaign.class});
        discountObjectKit.setListKitItems((List)cloner.deepClone((Object)model.getListKitItems()));
        DiscountRateKit discountRateKit = new DiscountRateKit();
        discount.setDiscountRate((DiscountRate)discountRateKit);
        discountRateKit.setKitItems((List)cloner.deepClone((Object)((DiscountRateKit)((Discount)model.getParent()).getDiscountRate()).getKitItems()));
        this.ratedItems = this.createRatedKitItems(discountRateKit, discountObjectKit);
        if (!saveInventSupportInKids && StringUtils.isEmpty((Object)discountObjectKit.getKittype())) {
            discountObjectKit.setKittype((String)((MyKeyValue)Directory.kitTypeModern.get(0)).getKey());
        }
        return (DiscountObjectKit)discount.getDiscountObject();
    }

    private List<DiscountRateKitItem> createRatedKitItems(DiscountRateKit discountRateKit, DiscountObjectKit discountObjectKit) {
        ArrayList<DiscountRateKitItem> result = new ArrayList<DiscountRateKitItem>();
        List rateKitItems = discountRateKit.getKitItems();
        for (DiscountObjectKitItem item : discountObjectKit.getListKitItems()) {
            DiscountRateKitItem example = this.findInDiscountRateKitItems(rateKitItems, item);
            if (example != null) {
                result.add(example);
                continue;
            }
            example = new DiscountRateKitItem();
            example.setDiscountObjectKitItem(item);
            example.setDiscountRate(null);
            result.add(example);
        }
        return result;
    }

    private DiscountRateKitItem findInDiscountRateKitItems(List<DiscountRateKitItem> rateKitItems, DiscountObjectKitItem example) {
        for (DiscountRateKitItem item : rateKitItems) {
            if (!ObjectUtils.equals((Object)item.getDiscountObjectKitItem(), (Object)example)) continue;
            return item;
        }
        return null;
    }

    public void initialize() {
        DiscountObjectKitPanel container = this;
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        this.composite.setLayout((Layout)gl_composite);
        Composite fieldsComposite = new Composite(this.composite, 0);
        fieldsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        fieldsComposite.setBounds(0, 0, 64, 64);
        fieldsComposite.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(fieldsComposite, 0);
        this.nameLabel.setSize(55, 15);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.nameValField = new Text(fieldsComposite, 2048);
        this.nameValField.setSize(486, 21);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameValField);
        this.maxtimesLabel = new Label(fieldsComposite, 0);
        this.maxtimesLabel.setSize(178, 15);
        this.maxtimesLabel.setText("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u043d\u0430\u0431\u043e\u0440\u043e\u0432:");
        Composite maxtimesComposite = new Composite(fieldsComposite, 0);
        maxtimesComposite.setSize(597, 22);
        GridLayout gl_maxtimesComposite = new GridLayout(2, false);
        gl_maxtimesComposite.marginHeight = 0;
        gl_maxtimesComposite.marginWidth = 0;
        gl_maxtimesComposite.verticalSpacing = 0;
        maxtimesComposite.setLayout((Layout)gl_maxtimesComposite);
        this.maxtimesSpinner = new Spinner(maxtimesComposite, 2048);
        this.maxtimesSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.maxtimesSpinner.setValues(0, 0, 250, 0, 1, 10);
        this.maxtimesCheckedButton = new Button(maxtimesComposite, 32);
        this.maxtimesCheckedButton.setSelection(true);
        this.maxtimesCheckedButton.setText("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e");
        this.maxtimesCheckedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscountObjectKitPanel.this.maxtimesSpinner.setEnabled(!DiscountObjectKitPanel.this.maxtimesCheckedButton.getSelection());
            }
        });
        if (saveInventSupportInKids) {
            this.kittypeLabel = new Label(fieldsComposite, 0);
            this.kittypeLabel.setText("\u0422\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430:");
            final Combo combo = new Combo(fieldsComposite, 8);
            this.kittypeCombo = new ComboViewer(combo);
            this.kittypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.kittypeCombo.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
            this.kittypeCombo.setInput((Object)Directory.kitTypeModern);
            this.kittypeCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            combo.select(0);
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Object selection = ((StructuredSelection)DiscountObjectKitPanel.this.kittypeCombo.getSelection()).getFirstElement();
                    if (selection instanceof MyKeyValue && !((MyKeyValue)selection).getKey().equals(((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getKittype()) && !((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getListKitItems().isEmpty()) {
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0431\u043e\u0440\u043e\u0432?", (String)"\u041f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0442\u0438\u043f\u0430 \u043d\u0430\u0431\u043e\u0440\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432. \u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430?")) {
                            DiscountObjectKitPanel.this.ratedItems.clear();
                            DiscountObjectKitPanel.this.tableViewer.setInputData(DiscountObjectKitPanel.this.ratedItems);
                        } else {
                            combo.setText(Directory.kitTypeModern.getDisplayValue((Object)((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getKittype()));
                        }
                    }
                }
            });
        }
        Composite listOfKitsComposite = new Composite(this.composite, 0);
        listOfKitsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        listOfKitsComposite.setBounds(0, 0, 64, 64);
        listOfKitsComposite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(listOfKitsComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        group.setText("\u041d\u0430\u0431\u043e\u0440\u044b:");
        group.setBounds(0, 0, 70, 82);
        group.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)group, 0x820000);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)new InsertRowAction());
        toolBarManager.add((IAction)this.changeRowAction);
        toolBarManager.add((IAction)this.deleteRowAction);
        toolBarManager.update(true);
        this.tableViewer = new DiscountObjectKitTableViewer((Composite)group, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DiscountRateKitLabelProvider());
        this.tableViewer.setInputData(this.ratedItems);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new ChangeRowAction().run();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = !event.getSelection().isEmpty();
                DiscountObjectKitPanel.this.changeRowAction.setEnabled(enabled);
                DiscountObjectKitPanel.this.deleteRowAction.setEnabled(enabled);
            }
        });
        MenuManager popupMenu = new MenuManager();
        Menu menu = popupMenu.createContextMenu((Control)this.tableViewer.getTable());
        popupMenu.add((IAction)new InsertRowAction());
        popupMenu.add((IAction)new ChangeRowAction());
        popupMenu.add((IAction)new DeleteRowAction());
        this.tableViewer.getTable().setMenu(menu);
        this.initDefaulBinding();
    }

    private void checkKitType(DiscountObjectKit kit) {
        if (StringUtils.isEmpty((Object)kit.getKittype()) || ((MyKeyValue)Directory.kitTypeModern.get(0)).getKey().equals(kit.getKittype())) {
            if (kit.getListKitItems().isEmpty()) {
                kit.setKittype((String)((MyKeyValue)Directory.kitTypeModern.get(1)).getKey());
            } else if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u0442\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430 \u043a \u0442\u0438\u043f\u0443 '\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438'?", (String)"\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0438\u043f\u0430 \u043d\u0430\u0431\u043e\u0440\u0430 \u0443\u043a\u0430\u0437\u0430\u043d '\u041a\u043e\u0434\u044b \u0442\u043e\u0432\u0430\u0440\u043e\u0432'. \u0414\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0447\u0438\u0442\u0430\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c \u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.\n\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430 \u043d\u0430 \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0438 (\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0441\u043e \u0432\u0441\u0435\u043c\u0438 \u0442\u043e\u0432\u0430\u0440\u0430\u043c\u0438, \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u043c\u0438 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440)?\n\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0430\u0431\u043e\u0440\u043e\u0432 \u0431\u0443\u0434\u0435\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0439!")) {
                try {
                    kit.setKittype((String)((MyKeyValue)Directory.kitTypeModern.get(1)).getKey());
                    DirectoryEditModel directoryCatalogModel = DirectoryModelFactory.getModel(Catalog.class);
                    DirectoryEditModel directoryInventCatalogModel = DirectoryModelFactory.getModel(InventCatalog.class);
                    for (DiscountObjectKitItem kitItem : kit.getListKitItems()) {
                        Catalog catalog = (Catalog)LibActivator.getDefault().getActualClassResolver().getInstance(Catalog.class);
                        catalog.setCatalogid(directoryCatalogModel.getNextId().toString());
                        catalog.setCatalogname("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u0434\u043b\u044f " + kitItem.getName());
                        catalog = (Catalog)directoryCatalogModel.save((Object)catalog);
                        for (String goodCode : kitItem.getGoodsCode()) {
                            InventCatalog inventCatalog = (InventCatalog)LibActivator.getDefault().getActualClassResolver().getInstance(InventCatalog.class);
                            inventCatalog.getTmccatalogPK().setCatalogid(catalog.getCatalogid());
                            inventCatalog.getTmccatalogPK().setTmccode(goodCode);
                            directoryInventCatalogModel.save((Object)inventCatalog);
                        }
                        kitItem.getGoodsCode().clear();
                        kitItem.getGoodsCode().add(catalog.getCatalogid());
                        kitItem.setGoodsCount(Double.valueOf(1.0));
                    }
                }
                catch (Exception e) {
                    log.error("Exception while create catalog from codes for kit: {}", (Throwable)e);
                }
            }
        }
    }

    public void applyRights(String selector) {
        super.applyRights(selector);
        this.changeRowAction.setEnabled(false);
        this.deleteRowAction.setEnabled(false);
        this.maxtimesSpinner.setEnabled(!((DiscountObjectKit)this.getModel()).isMaxTimesNotSpecified());
    }

    public List<DiscountRateKitItem> getRatedItems() {
        return this.ratedItems;
    }

    private class ChangeRowAction
    extends Action {
        public ChangeRowAction() {
            super("&\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/edit.png"));
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)DiscountObjectKitPanel.this.tableViewer.getSelection();
            DiscountObjectKitItemDialog.ObjectKitItemType kitItemType = ((MyKeyValue)Directory.kitTypeModern.get(0)).getKey().equals(((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getKittype()) ? DiscountObjectKitItemDialog.ObjectKitItemType.INVENT : DiscountObjectKitItemDialog.ObjectKitItemType.CATALOG;
            DiscountObjectKitItemDialog dialog = new DiscountObjectKitItemDialog("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043d\u0430\u0431\u043e\u0440\u0430", kitItemType, (DiscountRateKitItem)selection.getFirstElement(), saveInventSupportInKids);
            if (dialog.open() == 0) {
                DiscountObjectKitPanel.this.tableViewer.update(dialog.getRateItem(), null);
            }
        }
    }

    private class DeleteRowAction
    extends Action {
        public DeleteRowAction() {
            super("&\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png"));
        }

        public void run() {
            int index = DiscountObjectKitPanel.this.tableViewer.getTable().getSelectionIndex();
            DiscountRateKitItem element = (DiscountRateKitItem)DiscountObjectKitPanel.this.tableViewer.getElementAt(index);
            if (element != null) {
                ((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getListKitItems().remove(element.getDiscountObjectKitItem());
                DiscountObjectKitPanel.this.tableViewer.remove(element);
                log.trace("Deleted: " + element + " from Map");
            }
        }
    }

    private class InsertRowAction
    extends Action {
        public InsertRowAction() {
            super("&\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/add.png"));
        }

        public void run() {
            DiscountObjectKitItemDialog.ObjectKitItemType kitItemType = ((MyKeyValue)Directory.kitTypeModern.get(0)).getKey().equals(((DiscountObjectKit)DiscountObjectKitPanel.this.getModel()).getKittype()) ? DiscountObjectKitItemDialog.ObjectKitItemType.INVENT : DiscountObjectKitItemDialog.ObjectKitItemType.CATALOG;
            DiscountRateKitItem item = new DiscountRateKitItem();
            item.setDiscountRate(null);
            item.setDiscountObjectKitItem(new DiscountObjectKitItem());
            DiscountObjectKitItemDialog dialog = new DiscountObjectKitItemDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043d\u0430\u0431\u043e\u0440\u0430", kitItemType, item, saveInventSupportInKids);
            if (dialog.open() == 0) {
                DiscountObjectKitPanel.this.tableViewer.add(dialog.getRateItem());
                log.info("Added new element: " + dialog.getRateItem() + " to the Map");
            }
        }
    }
}

