/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.state.PersistState;

public class PersistTableSelectionState
implements PersistState<Table> {
    private static final Logger log = LoggerFactory.getLogger(PersistTableSelectionState.class);
    private IMemento memento;
    private String id;

    public PersistTableSelectionState(IMemento memento, String id) {
        this.memento = memento;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento, Table composite) {
        log.trace("save state");
        memento = memento.createChild(String.valueOf(this.id) + "_selection");
        int count = composite.getSelectionCount();
        memento.putInteger("selection_count", count);
        log.trace("selection count={}", (Object)count);
        int i = 0;
        while (i < count) {
            log.trace("selection index={}", (Object)composite.getSelectionIndices()[i]);
            memento.putInteger("selection_index_" + i, composite.getSelectionIndices()[i]);
            ++i;
        }
    }

    @Override
    public void restoreState(Table composite) {
        log.trace("restore state");
        if (this.memento != null) {
            Integer count;
            this.memento = this.memento.getChild(String.valueOf(this.id) + "_selection");
            if (this.memento != null && (count = this.memento.getInteger("selection_count")) != null && count > 0) {
                log.trace("selection count={}", (Object)count);
                int[] selectionIndices = new int[count.intValue()];
                int i = 0;
                while (i < count) {
                    Integer index = this.memento.getInteger("selection_index_" + i);
                    if (index != null) {
                        log.trace("selection index={}", (Object)index);
                        selectionIndices[i] = index;
                    }
                    ++i;
                }
                composite.setSelection(selectionIndices);
            }
        }
    }
}

