/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.utils.ArtixFilter;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.widgets.FilterElement;
import su.artix.widgets.IInputChanged;
import su.artix.widgets.SimpleFilterTextControl;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditorFactory;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.SearchResult;
import su.artix.yuki.search.ExtendedFilterElement;
import su.artix.yuki.search.ExtendedProperty;
import su.artix.yuki.search.SearchElement;
import su.artix.yuki.search.SearchPanel;

public abstract class DirectoryViewPanel<P, VIEWER extends ColumnViewer>
extends Composite
implements IInputChanged {
    private static final Logger log = LoggerFactory.getLogger(DirectoryViewPanel.class);
    private final boolean selectMode;
    private final boolean multiSelect;
    private final Class<P> clazz;
    private ArtixFilter<P> filter;
    private IDoubleClickListener customDoubleClickListener;
    private SimpleFilterTextControl filterControl;
    private ExtendedFilterElement filterElement = new ExtendedFilterElement();
    private SearchPanel<P> searchPanel;
    private VIEWER viewer;
    private boolean withFilterElement;
    private boolean withFilterMenu;
    private boolean withSearchPanel;

    protected abstract VIEWER createViewer(Composite var1);

    protected abstract void createColumns(Composite var1, VIEWER var2);

    public DirectoryViewPanel(Composite parent, int style, Class<P> clazz, boolean selectMode) {
        this(parent, style, clazz, selectMode, true, true);
    }

    public DirectoryViewPanel(Composite parent, int style, Class<P> clazz, boolean selectMode, boolean withFilterElement) {
        this(parent, style, clazz, selectMode, true, withFilterElement);
    }

    public DirectoryViewPanel(Composite parent, int style, Class<P> clazz, boolean selectMode, boolean multiSelect, boolean withFilterElement) {
        this(parent, style, clazz, selectMode, multiSelect, withFilterElement, true);
    }

    public DirectoryViewPanel(Composite parent, int style, Class<P> clazz, boolean selectMode, boolean multiSelect, boolean withFilterElement, boolean withFilterMenu) {
        this(parent, style, clazz, selectMode, multiSelect, withFilterElement, withFilterMenu, false);
    }

    public DirectoryViewPanel(Composite parent, int style, Class<P> clazz, boolean selectMode, boolean multiSelect, boolean withFilterElement, boolean withFilterMenu, boolean withSearchPanel) {
        super(parent, style);
        this.selectMode = selectMode;
        this.multiSelect = multiSelect;
        this.clazz = clazz;
        this.withFilterElement = withFilterElement;
        this.withFilterMenu = withFilterMenu;
        this.withSearchPanel = withSearchPanel;
        this.initialize();
    }

    protected void initialize() {
        this.viewer = this.createViewer(this);
        this.createFilterElements();
        if (this.withSearchPanel) {
            this.searchPanel = this.createSearchPanel(this, this.viewer);
        }
        if (this.withFilterElement) {
            this.filterControl = this.createFilter(this, this.viewer);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        if (!this.selectMode) {
            this.addEditByDoubleClick();
        }
        this.addListener(45, new Listener(){

            public void handleEvent(Event event) {
                DirectoryViewPanel.this.initPersistState(null);
            }
        });
        this.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                DirectoryViewPanel.this.savePersistState();
            }
        });
    }

    protected SearchPanel<P> createSearchPanel(Composite parent, VIEWER viewer) {
        SearchPanel searchPanel = new SearchPanel<P>(this.clazz, parent, 0, this.getSearchElement()){

            @Override
            protected void doResult(SearchResult<P> result) {
                DirectoryViewPanel.this.getViewer().setInput(result);
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).exclude(false).applyTo((Control)searchPanel);
        searchPanel.setVisible(true);
        searchPanel.moveAbove(viewer.getControl());
        return searchPanel;
    }

    protected SimpleFilterTextControl createFilter(Composite parent, VIEWER viewer) {
        SimpleFilterTextControl filterControl = new SimpleFilterTextControl((Composite)this, 0, 1000L, this.getFilterElement());
        filterControl.setViewer(viewer);
        filterControl.setInputChanged((IInputChanged)this);
        filterControl.setLayoutData((Object)new GridData(4, 4, false, false));
        filterControl.moveAbove(viewer.getControl());
        return filterControl;
    }

    public abstract void initPersistState(IWorkbenchPart var1);

    public abstract void savePersistState();

    public SimpleFilterTextControl getFilterControl() {
        return this.filterControl;
    }

    protected SearchElement getSearchElement() {
        return this.filterElement;
    }

    protected FilterElement getFilterElement() {
        return this.filterElement;
    }

    protected void createFilterElements() {
    }

    protected void addFilterElement(String label, String property, boolean defaultUse) {
        this.filterElement.getExtendedProperties().add(new ExtendedProperty(label, property, defaultUse));
    }

    protected void addFilterElement(String ... property) {
        String[] stringArray = property;
        int n = property.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            this.filterElement.getExtendedProperties().add(new ExtendedProperty(prop));
            ++n2;
        }
    }

    public void addEditByDoubleClick() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                log.trace("selection {}", (Object)selection);
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object obj = structuredSelection.getFirstElement();
                    DirectoryViewPanel.this.getEditorByDoubleClick(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), obj).open();
                } else {
                    log.error("selection is not instanceof {}", IStructuredSelection.class);
                }
            }
        });
    }

    public IDoubleClickListener getCustomDoubleClickListener() {
        return this.customDoubleClickListener;
    }

    public void setCustomDoubleClickListener(IDoubleClickListener customDoubleClickListener) {
        this.customDoubleClickListener = customDoubleClickListener;
    }

    public VIEWER getViewer() {
        return this.viewer;
    }

    public boolean isSelectMode() {
        return this.selectMode;
    }

    public Class<P> getPOJOClazz() {
        return this.clazz;
    }

    public void setFilter(ArtixFilter<P> filter) {
        this.filter = filter;
    }

    public ArtixFilter<P> getFilter() {
        return this.filter;
    }

    public void setInput(Object example) {
        this.initPersistState(null);
        if (this.getFilter() != null) {
            if (example instanceof FilterElement) {
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).addFilter(this.getFilter(), (FilterElement)example);
            } else {
                this.getFilter().setMasterRestriction(new FilterRestriction("", example, FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
            }
            this.getViewer().setInput(this.getFilter());
        } else {
            this.getViewer().setInput(example);
        }
    }

    public Dialog getEditorByDoubleClick(IWorkbenchWindow window, Object obj) {
        return DirectoryEditorFactory.getEditor(this.clazz, window, obj, DialogMode.UPDATE);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    protected int getSelectionStyle() {
        if (this.isMultiSelect()) {
            return 2;
        }
        return 4;
    }

    protected boolean isWithFilterMenu() {
        return this.withFilterMenu;
    }

    public abstract DirectorySelectDialogState getSelectDialogState();

    public abstract void setSelectDialogState(DirectorySelectDialogState var1);

    public boolean isVisibleFilterControl() {
        if (this.filterControl != null && !this.filterControl.isDisposed()) {
            return this.filterControl.isVisible();
        }
        return false;
    }

    public void showFilterControl() {
        if (this.withFilterElement && !this.isVisibleFilterControl()) {
            ((GridData)this.filterControl.getLayoutData()).exclude = false;
            this.filterControl.setVisible(true);
            this.filterControl.getParent().pack();
            this.getParent().layout();
        }
    }

    public void hideFilterControl() {
        if (this.withFilterElement && this.isVisibleFilterControl()) {
            ((GridData)this.filterControl.getLayoutData()).exclude = true;
            this.filterControl.setVisible(false);
            this.filterControl.getParent().pack();
            this.getParent().layout();
        }
    }

    public boolean isVisibleSearchPanel() {
        if (this.searchPanel != null && !this.searchPanel.isDisposed()) {
            return this.searchPanel.getVisible();
        }
        return false;
    }

    public void showSearchPanel() {
        if (!this.isVisibleSearchPanel()) {
            if (this.searchPanel == null || this.searchPanel.isDisposed()) {
                this.searchPanel = this.createSearchPanel(this, this.viewer);
            }
            ((GridData)this.searchPanel.getLayoutData()).exclude = false;
            this.searchPanel.setVisible(true);
            this.searchPanel.pack();
            this.searchPanel.getParent().pack();
            this.getParent().layout();
        }
    }

    public void hideSearchPanel() {
        if (this.isVisibleSearchPanel()) {
            ((GridData)this.searchPanel.getLayoutData()).exclude = true;
            this.searchPanel.setVisible(false);
            this.searchPanel.pack();
            this.searchPanel.getParent().pack();
            this.getParent().layout();
        }
    }

    protected final Class<P> getClazz() {
        return this.clazz;
    }
}

