/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.utils.ArtixFilter;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.provider.DirectoryCellModifier;
import su.artix.yuki.provider.IOrderedContentProvider;
import su.artix.yuki.view.Base64ImageExtractor;
import su.artix.yuki.view.CellEditorType;
import su.artix.yuki.view.CheckedImageExtractor;
import su.artix.yuki.view.DirectoryFilterDialog;
import su.artix.yuki.view.DirectoryViewPanel;
import su.artix.yuki.view.ExtendedColumn;
import su.artix.yuki.view.MementoPersistStore;
import su.artix.yuki.view.state.PersistState;
import su.artix.yuki.view.state.PersistStateViewer;
import su.artix.yuki.view.state.PersistTableOrderState;
import su.artix.yuki.view.state.PersistTableSortOrderState;
import su.artix.yuki.view.state.PersistTableWidthState;

public abstract class DirectoryTableViewPanel<P>
extends DirectoryViewPanel<P, TableViewer> {
    private static final int FILTER_MENU_INDEX = 1;
    private static final Logger log = LoggerFactory.getLogger(DirectoryTableViewPanel.class);
    protected static final int DEFAULT_COLUMN_WIDTH = 150;
    private volatile Object selectedCellObject;
    private volatile Integer selectedColumnIndex = 0;
    private DirectorySelectDialogState selectDialogState = new DirectorySelectDialogState();
    private volatile String selectedColumnName;
    private List<String> projectionList;
    private List<ExtendedColumn> columns;
    private int firstColumn = 0;
    private PersistState<Table> widthPersist;
    private PersistState<Table> orderPersist;
    private PersistStateViewer<Table, TableViewer> sortOrderPersist;

    public DirectoryTableViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode) {
        this(parent, style, cl, selectMode, true, true);
    }

    public DirectoryTableViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode, boolean multiSelect, boolean withFilterElement) {
        this(parent, style, cl, selectMode, multiSelect, withFilterElement, true);
    }

    public DirectoryTableViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode, boolean multiSelect, boolean withFilterElement, boolean withFilterMenu) {
        this(parent, style, cl, selectMode, multiSelect, withFilterElement, withFilterMenu, false);
    }

    public DirectoryTableViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode, boolean multiSelect, boolean withFilterElement, boolean withFilterMenu, boolean withSearchPanel) {
        super(parent, style, cl, selectMode, multiSelect, withFilterElement, withFilterMenu, withSearchPanel);
    }

    @Override
    protected void createColumns(Composite parent, TableViewer viewer) {
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Menu popup = new Menu((Control)table);
        MenuItem item = new MenuItem(popup, 64);
        item.setText("\u041a\u043e\u043b\u043e\u043d\u043a\u0438");
        Menu headerMenu = new Menu((Decorations)table.getShell(), 4);
        item.setMenu(headerMenu);
        if (this.columns == null || this.columns.isEmpty()) {
            this.createDefaultColumns();
        }
        int i = this.getFirstColumn();
        while (i < this.columns.size()) {
            ExtendedColumn column = this.columns.get(i);
            column.setTableViewerColumn(new TableViewerColumn(viewer, 4));
            column.getTableViewerColumn().setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                }
            });
            column.getTableViewerColumn().getColumn().setWidth(column.getWidth().intValue());
            column.getTableViewerColumn().getColumn().setMoveable(true);
            if (column.getWidth() == 0) {
                column.getTableViewerColumn().getColumn().setResizable(false);
            }
            final int index = i;
            final String sortColumn = this.columns.get(i).getSortProperty();
            if (sortColumn != null) {
                column.getTableViewerColumn().getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DirectoryTableViewPanel.this.updateTableSorting(sortColumn, index);
                    }
                });
            }
            ++i;
        }
        i = this.getFirstColumn();
        while (i < this.columns.size()) {
            this.createHideColumnMenuItem(headerMenu, this.columns.get(i), i, this.columns);
            ++i;
        }
        String[] columnProperties = new String[this.columns.size()];
        int i2 = 0;
        while (i2 < columnProperties.length) {
            columnProperties[i2] = this.columns.get(i2).getColumnProperty();
            ++i2;
        }
        viewer.setColumnProperties(columnProperties);
        DirectoryCellModifier cellModifier = new DirectoryCellModifier(LibActivator.getDefault().getActualClassResolver().getActual(this.getPOJOClazz()), (ColumnViewer)viewer, this.columns);
        viewer.setCellModifier((ICellModifier)cellModifier);
        this.createCellEditors(viewer);
        if (this.isWithFilterMenu() && LibActivator.getDefault().getActualClassResolver().isDatabaseClass(this.getPOJOClazz())) {
            this.createFilterMenu(popup, this.getPOJOClazz(), viewer);
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setMenu(popup);
    }

    private void createCellEditors(TableViewer viewer) {
        CellEditor[] editors = new CellEditor[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).isEditable()) {
                if (this.columns.get(i).getCellEditorType() == CellEditorType.BOOLEAN) {
                    editors[i] = new CheckboxCellEditor((Composite)viewer.getTable());
                }
                if (this.columns.get(i).getCellEditorType() == CellEditorType.TEXT) {
                    editors[i] = new TextCellEditor((Composite)viewer.getTable());
                }
            }
            if (this.columns.get(i).getCellEditorType() == CellEditorType.CURRENCY) {
                this.columns.get(i).getTableViewerColumn().getColumn().setAlignment(131072);
            }
            if (this.columns.get(i).getCellEditorType() == CellEditorType.QUANTITY) {
                this.columns.get(i).getTableViewerColumn().getColumn().setAlignment(131072);
            }
            ++i;
        }
        viewer.setCellEditors(editors);
    }

    protected void createDefaultColumns() {
        Field[] fields = this.getPOJOClazz().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            this.addColumn(fieldName, fieldName, 150);
            ++i;
        }
    }

    @Override
    public void initPersistState(IWorkbenchPart part) {
        IWorkbenchPage page;
        if (part == null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            part = page.getActivePart();
        }
        if (part instanceof MementoPersistStore) {
            IMemento memento = ((MementoPersistStore)part).getMemento();
            String tag_id = (String.valueOf(part.getClass().getName()) + "_" + ((Object)((Object)this)).getClass().getName()).replace("$", "");
            this.restoreWidth(memento, tag_id);
            this.restoreOrder(memento, tag_id);
            this.restoreSortOrder(memento, tag_id);
            ((TableViewer)this.getViewer()).refresh();
        }
    }

    protected void restoreSortOrder(IMemento memento, String tag_id) {
        if (this.sortOrderPersist == null) {
            this.sortOrderPersist = new PersistTableSortOrderState(memento, tag_id);
            this.sortOrderPersist.restoreState(((TableViewer)this.getViewer()).getTable(), (TableViewer)this.getViewer());
        }
    }

    protected void restoreOrder(IMemento memento, String tag_id) {
        if (this.orderPersist == null) {
            this.orderPersist = new PersistTableOrderState(memento, tag_id);
            this.orderPersist.restoreState(((TableViewer)this.getViewer()).getTable());
        }
    }

    protected void restoreWidth(IMemento memento, String tag_id) {
        if (this.widthPersist == null) {
            this.widthPersist = new PersistTableWidthState(memento, tag_id);
            this.widthPersist.restoreState(((TableViewer)this.getViewer()).getTable());
        }
    }

    @Override
    public void savePersistState() {
        IMemento memento;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof MementoPersistStore && this.getViewer() != null && (memento = ((MementoPersistStore)part).getMemento()) != null) {
            if (this.widthPersist != null) {
                this.widthPersist.saveState(memento, ((TableViewer)this.getViewer()).getTable());
            }
            if (this.orderPersist != null) {
                this.orderPersist.saveState(memento, ((TableViewer)this.getViewer()).getTable());
            }
            if (this.sortOrderPersist != null) {
                this.sortOrderPersist.saveState(memento, (TableViewer)this.getViewer());
            }
        }
    }

    @Override
    protected TableViewer createViewer(Composite parent) {
        final TableViewer viewer = new TableViewer(parent, 0x10000000 | this.getSelectionStyle() | 0x100 | 0x200 | 0x10000){

            protected void inputChanged(Object input, Object oldInput) {
                SessionManager.openSession(DirectoryTableViewPanel.this.getPOJOClazz());
                super.inputChanged(input, oldInput);
                SessionManager.closeSession(DirectoryTableViewPanel.this.getPOJOClazz());
            }

            protected void preservingSelection(Runnable updateCode) {
                updateCode.run();
            }
        };
        this.createColumns(parent, viewer);
        final Table table = viewer.getTable();
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 3) {
                    Rectangle clientArea = table.getClientArea();
                    Point pt = new Point(event.x, event.y);
                    int index = table.getTopIndex();
                    while (index < table.getItemCount()) {
                        boolean visible = false;
                        TableItem item = table.getItem(index);
                        int i = 0;
                        while (i < table.getColumnCount()) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(pt)) {
                                DirectoryTableViewPanel.this.selectedColumnName = (String)viewer.getColumnProperties()[i];
                                DirectoryTableViewPanel.this.selectedCellObject = viewer.getCellModifier().getValue(item.getData(), DirectoryTableViewPanel.this.selectedColumnName);
                                DirectoryTableViewPanel.this.selectedColumnIndex = i;
                                if (table.getMenu().getItemCount() > 1) {
                                    table.getMenu().getItem(1).setEnabled(true);
                                }
                            }
                            if (!visible && rect.intersects(clientArea)) {
                                visible = true;
                            }
                            ++i;
                        }
                        if (!visible) {
                            return;
                        }
                        ++index;
                    }
                }
            }
        });
        return viewer;
    }

    protected void updateTableSorting(String sortColumn, int index) {
        if (((TableViewer)this.getViewer()).getContentProvider() instanceof IOrderedContentProvider) {
            log.trace("");
            ((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).setAscending(!((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).isAscending());
            ((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).setSortProperty(sortColumn);
            ((TableViewer)this.getViewer()).getTable().setSortColumn(((TableViewer)this.getViewer()).getTable().getColumn(index));
            ((TableViewer)this.getViewer()).getTable().setSortDirection(((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).isAscending() ? 128 : 1024);
            this.selectDialogState.setAscendingSortedColumn(((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).isAscending());
            this.selectDialogState.setSortedColumnIndex(index);
        }
        ((TableViewer)this.getViewer()).refresh(true);
    }

    public void dispose() {
    }

    protected SelectionListener getFilterSelectionListener(final FilterRestriction.Condition op, final TableViewer viewer) {
        final Object[] properties = viewer.getColumnProperties();
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DirectoryTableViewPanel.this.selectedColumnName != null) {
                    Class clazz = String.class;
                    try {
                        clazz = (Class)PojoProperties.value(DirectoryTableViewPanel.this.getPOJOClazz(), (String)DirectoryTableViewPanel.this.selectedColumnName).getValueType();
                    }
                    catch (Exception e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    DirectoryFilterDialog dialog = new DirectoryFilterDialog(viewer.getTable().getShell(), clazz);
                    FilterRestriction fr = new FilterRestriction(properties[DirectoryTableViewPanel.this.selectedColumnIndex].toString(), DirectoryTableViewPanel.this.selectedCellObject, FilterRestriction.LinkCondition.unique, op, Boolean.valueOf(false));
                    dialog.setFilterRestriction(fr);
                    int result = dialog.open();
                    if (result == 0) {
                        DirectoryTableViewPanel.this.getFilter().add(dialog.getFilterRestriction());
                        viewer.setInput(DirectoryTableViewPanel.this.getFilter());
                    }
                }
            }
        };
        return listener;
    }

    protected void createFilterMenu(Menu parent, Class<P> clazz, final TableViewer viewer) {
        this.setFilter(new ArtixFilter(clazz));
        if (this.projectionList != null && !this.projectionList.isEmpty()) {
            this.getFilter().setProjectionProperties(this.projectionList);
        }
        MenuItem filterMenuItem = new MenuItem(parent, 64);
        filterMenuItem.setText("\u0424\u0438\u043b\u044c\u0442\u0440");
        filterMenuItem.setEnabled(false);
        Menu subMenu = new Menu((Decorations)viewer.getTable().getShell(), 4);
        filterMenuItem.setMenu(subMenu);
        MenuItem itemName = new MenuItem(subMenu, 8);
        itemName.setText("=");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.eq, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText(">");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.gt, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText(">=");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.ge, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("<");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.lt, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("<=");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.le, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("!=");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.ne, viewer));
        new MenuItem(subMenu, 2);
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f ...");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.like, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043d\u0430 ...");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.like_start, viewer));
        itemName = new MenuItem(subMenu, 8);
        itemName.setText("\u0417\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 ...");
        itemName.addSelectionListener(this.getFilterSelectionListener(FilterRestriction.Condition.like_end, viewer));
        filterMenuItem = new MenuItem(parent, 8);
        filterMenuItem.setText("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440");
        filterMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryTableViewPanel.this.getFilter().clearNotFixed();
                viewer.setInput(DirectoryTableViewPanel.this.getFilter());
            }
        });
    }

    protected void createHideColumnMenuItem(Menu parent, ExtendedColumn column3, int i, List<ExtendedColumn> columns2) {
        final MenuItem itemName = new MenuItem(parent, 32);
        final TableColumn column = column3.getTableViewerColumn().getColumn();
        itemName.setText(column.getText());
        itemName.setSelection(column.getWidth() > 0);
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(150);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }

    protected void addColumn(String title, String columnProperty, String sortProperty, Integer width, String hideMenuTitle, boolean editable, CellEditorType cellEditorType, String defaultDisplayValue, IConverter converter) {
        if (this.columns == null) {
            this.columns = new ArrayList<ExtendedColumn>();
        }
        if (columnProperty == null || LibActivator.getDefault().getActualClassResolver().isValidProperty(this.getPOJOClazz(), columnProperty)) {
            ExtendedColumn column = new ExtendedColumn();
            column.setTitle(title);
            column.setColumnProperty(columnProperty);
            column.setSortProperty(sortProperty);
            column.setWidth(width);
            column.setHideMenuTitle(hideMenuTitle);
            column.setEditable(editable);
            column.setCellEditorType(cellEditorType);
            column.setDefaultDisplayValue(defaultDisplayValue);
            if (cellEditorType == CellEditorType.BOOLEAN) {
                column.setImageExtractor(new CheckedImageExtractor());
            }
            if (cellEditorType == CellEditorType.ACTIVE) {
                column.setImageExtractor(new CheckedImageExtractor(true));
            }
            if (cellEditorType == CellEditorType.IMAGE) {
                column.setImageExtractor(new Base64ImageExtractor());
            }
            column.setConverter(converter);
            this.columns.add(column);
        } else {
            log.info("skip add column:{}", (Object)columnProperty);
        }
    }

    protected void addColumn(String title, String columnProperty, Integer width) {
        this.addColumn(title, columnProperty, columnProperty, width, title, false, null, null, null);
    }

    protected void addColumn(String title, String columnProperty, String defaultDisplayValue) {
        this.addColumn(title, columnProperty, columnProperty, 0, title, false, null, defaultDisplayValue, null);
    }

    protected void addColumn(String title, String columnProperty, Integer width, IConverter converter) {
        this.addColumn(title, columnProperty, columnProperty, width, title, false, null, null, converter);
    }

    protected void addColumn(String title, String columnProperty, Integer width, CellEditorType cellEditorType) {
        this.addColumn(title, columnProperty, columnProperty, width, title, false, cellEditorType, null, null);
    }

    protected void addColumn(String title, String columnProperty, Integer width, String hideMenuTitle, CellEditorType cellEditorType) {
        this.addColumn(title, columnProperty, columnProperty, width, hideMenuTitle, false, cellEditorType, null, null);
    }

    protected void addColumn(String title, String columnProperty, Integer width, boolean editable, CellEditorType cellEditorType) {
        this.addColumn(title, columnProperty, columnProperty, width, title, editable, cellEditorType, null, null);
    }

    protected void addColumn(String title, String columnProperty, Integer width, String hideMenuTitle) {
        this.addColumn(title, columnProperty, columnProperty, width, hideMenuTitle, false, null, null, null);
    }

    protected void addColumn(String title, String columnProperty, Integer width, String hideMenuTitle, IConverter converter) {
        this.addColumn(title, columnProperty, columnProperty, width, hideMenuTitle, false, null, null, converter);
    }

    public void setProjectionProperties(List<String> projectionProperties) {
        this.projectionList = projectionProperties;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public void setFirstColumn(int firstColumn) {
        this.firstColumn = firstColumn;
    }

    public List<ExtendedColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ExtendedColumn> columns) {
        this.columns = columns;
    }

    @Override
    public DirectorySelectDialogState getSelectDialogState() {
        return this.selectDialogState;
    }

    @Override
    public void setSelectDialogState(DirectorySelectDialogState selectDialogState) {
        this.selectDialogState = selectDialogState;
        if (selectDialogState.getSortedColumnIndex() != null) {
            String sortColumn = this.columns.get(selectDialogState.getSortedColumnIndex()).getSortProperty();
            ((IOrderedContentProvider)((TableViewer)this.getViewer()).getContentProvider()).setAscending(!selectDialogState.isAscendingSortedColumn());
            this.updateTableSorting(sortColumn, selectDialogState.getSortedColumnIndex());
        }
    }
}

