/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import su.artix.cashserver.security.SecurityAction;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditDialog;
import su.artix.yuki.editors.DirectoryEditorFactory;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.directory.DirectoryEditModelStub;

public class TableViewerEditAction<E>
extends Action
implements ISelectionChangedListener,
SecurityAction {
    private final Class<E> cl;
    private final PropertyChangeListener propertyChangeListener;
    private StructuredSelection structuredSelection;
    private boolean securityEnabled;

    public TableViewerEditAction(Class<E> cl, PropertyChangeListener propertyChangeListener) {
        super("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.cl = cl;
        this.propertyChangeListener = propertyChangeListener;
        this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        this.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
    }

    public void run() {
        Object obj = this.structuredSelection.getFirstElement();
        Dialog dialog = DirectoryEditorFactory.getEditor(this.cl, PlatformUI.getWorkbench().getActiveWorkbenchWindow(), obj, DialogMode.UPDATE);
        this.workWithDialog(dialog);
        DirectoryEditModelStub model = new DirectoryEditModelStub();
        model.addPropertyChangeListener(this.propertyChangeListener);
        ((DirectoryEditDialog)dialog).setDirectoryEditModel(model);
        dialog.open();
    }

    protected void workWithDialog(Dialog dialog) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.structuredSelection = (StructuredSelection)event.getSelection();
            this.setEnabled(this.securityEnabled && this.structuredSelection.size() == 1 && this.structuredSelection.getFirstElement().getClass() == this.cl);
        } else {
            this.setEnabled(false);
        }
    }

    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }
}

