/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.panels;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class BlurredPanel {
    private final Shell parent;
    private static final String BLURED_PANEL_KEY = "org.mihalis.opal.Panels.DarkPanel";
    private int radius;
    private Shell panel;
    private Canvas canvas;

    public BlurredPanel(Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent = shell;
        if (shell.getData(BLURED_PANEL_KEY) != null) {
            throw new IllegalArgumentException("This shell has already an infinite panel attached on it !");
        }
        shell.setData(BLURED_PANEL_KEY, (Object)this);
        this.radius = 2;
    }

    public void show() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        this.panel = new Shell(this.parent, 65544);
        this.panel.setLayout((Layout)new FillLayout());
        this.panel.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.canvas = new Canvas((Composite)this.panel, 0x20040000);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                BlurredPanel.this.paintCanvas(paintEvent);
            }
        });
        this.panel.setBounds(this.panel.getDisplay().map((Control)this.parent, null, this.parent.getClientArea()));
        this.panel.open();
    }

    private void paintCanvas(PaintEvent paintEvent) {
        paintEvent.gc.drawImage(this.createBlurredImage(), 0, 0);
    }

    private Image createBlurredImage() {
        GC gC = new GC((Drawable)this.parent);
        Image image = new Image((Device)this.parent.getDisplay(), this.parent.getSize().x, this.parent.getSize().y);
        gC.copyArea(image, 0, 0);
        gC.dispose();
        return new Image((Device)this.parent.getDisplay(), SWTGraphicUtil.blur(image.getImageData(), this.radius));
    }

    public void hide() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.panel == null || this.panel.isDisposed()) {
            return;
        }
        this.panel.dispose();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
    }
}

