/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.dict.notes;

import org.apache.commons.lang.BooleanUtils;
import ru.ssa.cashadmin.domain.dict.notes.DialogParams;
import ru.ssa.cashadmin.domain.dict.notes.JsonDialogParams;

public class DialogParamsChoice
extends DialogParams {
    private String title;
    private String message;
    private String okBtnText;
    private String cancelBtnText;
    private boolean turnRed;
    private boolean forCustomer;
    private Integer btnOkDelay = 0;
    private boolean enableHotKeys = true;

    public DialogParamsChoice() {
        super("dialogChoice");
    }

    public DialogParamsChoice(JsonDialogParams paramsJson) {
        this();
        this.title = paramsJson.getTitle();
        this.message = paramsJson.getMessage();
        this.okBtnText = paramsJson.getOkBtnText();
        this.cancelBtnText = paramsJson.getCancelBtnText();
        this.turnRed = paramsJson.isTurnRed();
        this.btnOkDelay = paramsJson.getBtnOkDelay();
        this.enableHotKeys = paramsJson.isEnableHotKeys();
        this.forCustomer = BooleanUtils.isTrue((Boolean)paramsJson.getForCustomer());
    }

    @Override
    public JsonDialogParams toJsonDialogParams() {
        JsonDialogParams paramsJson = new JsonDialogParams(this.getDialogType());
        paramsJson.setTitle(this.getTitle());
        paramsJson.setMessage(this.getMessage());
        paramsJson.setOkBtnText(this.getOkBtnText());
        paramsJson.setCancelBtnText(this.getCancelBtnText());
        paramsJson.setTurnRed(this.isTurnRed());
        paramsJson.setBtnOkDelay(this.getBtnOkDelay());
        paramsJson.setEnableHotKeys(this.isEnableHotKeys());
        paramsJson.setForCustomer(this.isForCustomer());
        return paramsJson;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getOkBtnText() {
        return this.okBtnText;
    }

    public void setOkBtnText(String okBtnText) {
        this.okBtnText = okBtnText;
    }

    public String getCancelBtnText() {
        return this.cancelBtnText;
    }

    public void setCancelBtnText(String cancelBtnText) {
        this.cancelBtnText = cancelBtnText;
    }

    public boolean isTurnRed() {
        return this.turnRed;
    }

    public void setTurnRed(boolean turnRed) {
        this.turnRed = turnRed;
    }

    public boolean isForCustomer() {
        return this.forCustomer;
    }

    public void setForCustomer(boolean forCustomer) {
        this.forCustomer = forCustomer;
    }

    public Integer getBtnOkDelay() {
        return this.btnOkDelay;
    }

    public void setBtnOkDelay(Integer btnOkDelay) {
        this.btnOkDelay = btnOkDelay;
    }

    public boolean isEnableHotKeys() {
        return this.enableHotKeys;
    }

    public void setEnableHotKeys(boolean enableHotKeys) {
        this.enableHotKeys = enableHotKeys;
    }
}

