/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.TmcKit;
import ru.ssa.cashadmin.domain.TmcKitItemPK;

@Entity
@Table(name="tmckititem")
@MappedSuperclass
public class TmcKitItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TmcKitItemPK pk = new TmcKitItemPK();
    @Column(name="tmccode", insertable=false, updatable=false)
    private String tmccode;
    @ManyToOne
    @JoinColumn(name="tmccode", referencedColumnName="barcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Barcodes.class)
    @NotNull
    private Barcodes invent;
    @ManyToOne
    @JoinColumn(name="tmckitbarcode", referencedColumnName="barcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private TmcKit tmcKit;
    @Column(name="tmckitbarcode", insertable=false, updatable=false)
    private String tmcKitBarcode;
    @NotNull
    @Column(name="quantity")
    private BigDecimal quantity;

    protected TmcKitItem() {
    }

    public TmcKitItemPK getPk() {
        return this.pk;
    }

    public void setPk(TmcKitItemPK pk) {
        this.pk = pk;
    }

    public String getTmccode() {
        return this.tmccode;
    }

    public void setTmccode(String tmccode) {
        this.tmccode = tmccode;
    }

    public Barcodes getInvent() {
        return this.invent;
    }

    public void setInvent(Barcodes invent) {
        this.invent = invent;
        if (invent != null) {
            this.tmccode = invent.getBarcode();
            this.pk.setTmccode(invent.getBarcode());
        } else {
            this.tmccode = null;
            this.pk.setTmccode(null);
        }
    }

    public String getTmcKitBarcode() {
        return this.tmcKitBarcode;
    }

    public void setTmcKitBarcode(String tmcKitBarcode) {
        this.tmcKitBarcode = tmcKitBarcode;
    }

    public TmcKit getTmcKit() {
        return this.tmcKit;
    }

    public void setTmcKit(TmcKit tmcKit) {
        this.tmcKit = tmcKit;
        if (tmcKit != null) {
            this.tmcKitBarcode = tmcKit.getBarcode();
            this.pk.setTmcKitBarcode(tmcKit.getBarcode());
        } else {
            this.tmcKitBarcode = null;
            this.pk.setTmcKitBarcode(null);
        }
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmcKitItem other = (TmcKitItem)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public String toString() {
        return "TmcKitItem [pk=" + this.pk + ", quantity=" + this.quantity + "]";
    }
}

