/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.domain.converter;

import java.util.ArrayList;
import java.util.List;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;
import su.artix.cashserver.core.cashregistry.domain.Category;
import su.artix.cashserver.core.cashregistry.domain.Group;
import su.artix.cashserver.core.cashregistry.domain.IParentObject;
import su.artix.cashserver.core.cashregistry.domain.MiddleServer;
import su.artix.cashserver.core.cashregistry.domain.Shop;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.rest.domain.CashServerModeInfo;
import su.artix.cashserver.rest.domain.CategoryInfo;
import su.artix.cashserver.rest.domain.GroupInfo;
import su.artix.cashserver.rest.domain.MiddleServerInfo;
import su.artix.cashserver.rest.domain.ParentObject;
import su.artix.cashserver.rest.domain.ParentType;
import su.artix.cashserver.rest.domain.ShopInfo;
import su.artix.cashserver.rest.domain.converter.RestDomainConverter;

public class DefaultRestDomainConverter
implements RestDomainConverter {
    protected Group getParentGroup(String groupCode, String clusterId) {
        Group parentGroup = new Group();
        parentGroup.setStoreId(groupCode);
        parentGroup.setClusterId(clusterId);
        return parentGroup;
    }

    protected Shop getParentShop(String shopCode, String clusterId) {
        Shop parentShop = new Shop();
        parentShop.setCode(shopCode);
        parentShop.setClusterId(clusterId);
        return parentShop;
    }

    protected MiddleServer getParentMiddleServer(String middleServerCode, String clusterId) {
        MiddleServer middleServer = new MiddleServer();
        middleServer.setCode(middleServerCode);
        middleServer.setClusterId(clusterId);
        return middleServer;
    }

    protected WebUser getWebUser(String userName) {
        WebUser webUser = new WebUser();
        webUser.setName(userName);
        return webUser;
    }

    @Override
    public GroupInfo groupToGroupInfo(Group group) {
        GroupInfo groupInfo = new GroupInfo();
        groupInfo.setId(group.getCode());
        groupInfo.setGroupCode(group.getDisplayCode());
        groupInfo.setClusterId(group.getClusterId());
        groupInfo.setTitle(group.getTitle());
        if (group.getParent() != null) {
            groupInfo.setParentGroup(group.getParent().getCode());
        }
        return groupInfo;
    }

    @Override
    public Group groupInfoToGroup(GroupInfo groupInfo) {
        Group group = new Group();
        group.setStoreId(groupInfo.getId());
        group.setClusterId(groupInfo.getClusterId());
        group.setDisplayCode(groupInfo.getGroupCode());
        group.setTitle(groupInfo.getTitle());
        if (groupInfo.getParentGroup() != null) {
            group.setParent(this.getParentGroup(groupInfo.getParentGroup(), groupInfo.getClusterId()));
        }
        group.setHasChildren(groupInfo.getHasChildren());
        return group;
    }

    @Override
    public MiddleServerInfo middleServerToMiddleServerInfo(MiddleServer middleServer) {
        MiddleServerInfo middleServerInfo = new MiddleServerInfo();
        middleServerInfo.setId(middleServer.getCode());
        middleServerInfo.setMiddleServerCode(middleServer.getDisplayCode());
        middleServerInfo.setClusterId(middleServer.getClusterId());
        middleServerInfo.setTitle(middleServer.getTitle());
        middleServerInfo.setCashserverId(middleServer.getCashserverId());
        if (middleServer.getParentGroup() != null) {
            middleServerInfo.setParentGroup(middleServer.getParentGroup().getCode());
        }
        middleServerInfo.setIp(middleServer.getIp());
        middleServerInfo.setTags(middleServer.getTags());
        middleServerInfo.setInited(middleServer.isInited());
        List categories = middleServer.getCategories();
        if (categories != null) {
            if (categories.size() == 1 && categories.get(0) == null) {
                middleServerInfo.getCategories().clear();
            } else {
                ArrayList<CategoryInfo> categoryInfos = new ArrayList<CategoryInfo>(categories.size());
                for (Category category : categories) {
                    categoryInfos.add(this.categoryToCategoryInfo(category));
                }
                middleServerInfo.setCategories(categoryInfos);
            }
        }
        return middleServerInfo;
    }

    @Override
    public MiddleServer middleServerInfoToMiddleServer(MiddleServerInfo middleServerInfo) {
        MiddleServer middleServer = new MiddleServer();
        middleServer.setCode(middleServerInfo.getId());
        middleServer.setDisplayCode(middleServerInfo.getMiddleServerCode());
        middleServer.setClusterId(middleServerInfo.getClusterId());
        middleServer.setTitle(middleServerInfo.getTitle());
        middleServer.setCashserverId(middleServerInfo.getCashserverId());
        if (middleServerInfo.getParentGroup() != null) {
            middleServer.setParentGroup(this.getParentGroup(middleServerInfo.getParentGroup(), middleServerInfo.getClusterId()));
        }
        middleServer.setIp(middleServerInfo.getIp());
        middleServer.setTags(middleServerInfo.getTags());
        middleServer.setInited(middleServerInfo.isInited());
        List<CategoryInfo> categoryInfos = middleServerInfo.getCategories();
        if (categoryInfos != null) {
            ArrayList<Category> categories = new ArrayList<Category>(categoryInfos.size());
            for (CategoryInfo category : categoryInfos) {
                categories.add(this.categoryInfoToCategory(category));
            }
            middleServer.setCategories(categories);
        }
        middleServer.setHasChildren(middleServerInfo.getHasChildren());
        return middleServer;
    }

    @Override
    public ShopInfo shopToShopInfo(Shop shop) {
        List categories;
        ShopInfo shopInfo = new ShopInfo();
        shopInfo.setId(shop.getCode());
        shopInfo.setShopCode(shop.getDisplayCode());
        shopInfo.setClusterId(shop.getClusterId());
        shopInfo.setTitle(shop.getTitle());
        if (shop.getParent() != null) {
            if (shop.getParent() instanceof Group) {
                shopInfo.setParentObject(new ParentObject(ParentType.GROUP, shop.getParent().getCode()));
            } else if (shop.getParent() instanceof MiddleServer) {
                shopInfo.setParentObject(new ParentObject(ParentType.MIDDLE_SERVER, shop.getParent().getCode()));
            }
        }
        if ((categories = shop.getCategories()) != null) {
            if (categories.size() == 1 && categories.get(0) == null) {
                shopInfo.getCategories().clear();
            } else {
                ArrayList<CategoryInfo> categoryInfos = new ArrayList<CategoryInfo>(categories.size());
                for (Category category : categories) {
                    categoryInfos.add(this.categoryToCategoryInfo(category));
                }
                shopInfo.setCategories(categoryInfos);
            }
        }
        shopInfo.setTags(shop.getTags());
        shopInfo.setShopLabels(shop.getShopLabels());
        shopInfo.setExtendedOptions(shop.getExtendedOptions());
        shopInfo.setAddress(shop.getAddress());
        shopInfo.setKppExcise(shop.getKppExcise());
        shopInfo.setKppNonExcise(shop.getKppNonExcise());
        shopInfo.setFsrarIdExcise(shop.getFsrarIdExcise());
        shopInfo.setFsrarIdNonExcise(shop.getFsrarIdNonExcise());
        shopInfo.setEqualsExciseAndNonExcise(shop.isEqualsExciseAndNonExcise());
        return shopInfo;
    }

    @Override
    public Shop shopInfoToShop(ShopInfo shopInfo) {
        List<CategoryInfo> categoryInfos;
        Shop shop = new Shop();
        shop.setCode(shopInfo.getId());
        shop.setClusterId(shopInfo.getClusterId());
        shop.setDisplayCode(shopInfo.getShopCode());
        shop.setTitle(shopInfo.getTitle());
        if (shopInfo.getParentObject() != null) {
            ParentObject parentObject = shopInfo.getParentObject();
            if (parentObject.getParentType() == ParentType.GROUP) {
                shop.setParent((IParentObject)this.getParentGroup(parentObject.getParentCode(), shopInfo.getClusterId()));
            } else if (parentObject.getParentType() == ParentType.MIDDLE_SERVER) {
                shop.setParent((IParentObject)this.getParentMiddleServer(parentObject.getParentCode(), shopInfo.getClusterId()));
            }
        }
        if ((categoryInfos = shopInfo.getCategories()) != null) {
            ArrayList<Category> categories = new ArrayList<Category>(categoryInfos.size());
            for (CategoryInfo category : categoryInfos) {
                categories.add(this.categoryInfoToCategory(category));
            }
            shop.setCategories(categories);
        }
        shop.setTags(shopInfo.getTags());
        shop.setShopLabels(shopInfo.getShopLabels());
        shop.setExtendedOptions(shopInfo.getExtendedOptions());
        shop.setHasChildren(shopInfo.getHasChildren());
        shop.setAddress(shopInfo.getAddress());
        shop.setKppExcise(shopInfo.getKppExcise());
        shop.setKppNonExcise(shopInfo.getKppNonExcise());
        shop.setFsrarIdExcise(shopInfo.getFsrarIdExcise());
        shop.setFsrarIdNonExcise(shopInfo.getFsrarIdNonExcise());
        shop.setEqualsExciseAndNonExcise(shopInfo.isEqualsExciseAndNonExcise());
        return shop;
    }

    @Override
    public CashServerModeInfo cashServerModeToCashServerModeInfo(CashServerMode cashServerMode) {
        return new CashServerModeInfo(cashServerMode.getCashserverId(), cashServerMode.getCashserverName(), cashServerMode.getClusterMode(), cashServerMode.getHierarhyMode(), cashServerMode.getMiddleServerState(), cashServerMode.getStateDescription());
    }

    @Override
    public CashServerMode cashServerModeInfoToCashServerMode(CashServerModeInfo cashServerModeInfo) {
        CashServerMode cashServerMode = new CashServerMode();
        cashServerMode.setCashserverId(cashServerModeInfo.getCashserverId());
        cashServerMode.setCashserverName(cashServerModeInfo.getCashserverName());
        cashServerMode.setClusterMode(cashServerModeInfo.getClusterMode());
        cashServerMode.setHierarhyMode(cashServerModeInfo.getHierarhyMode());
        cashServerMode.setMiddleServerState(cashServerModeInfo.getMiddleServerState());
        cashServerMode.setStateDescription(cashServerModeInfo.getStateDescription());
        return cashServerMode;
    }

    @Override
    public CategoryInfo categoryToCategoryInfo(Category category) {
        CategoryInfo categoryInfo = new CategoryInfo();
        categoryInfo.setId(category.getId());
        categoryInfo.setDisplayCode(category.getDisplayCode());
        categoryInfo.setTitle(category.getTitle());
        categoryInfo.setClusterId(category.getClusterId());
        return categoryInfo;
    }

    @Override
    public Category categoryInfoToCategory(CategoryInfo categoryInfo) {
        Category category = new Category();
        category.setId(categoryInfo.getId());
        category.setDisplayCode(categoryInfo.getDisplayCode());
        category.setTitle(categoryInfo.getTitle());
        category.setClusterId(categoryInfo.getClusterId());
        return category;
    }
}

