/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import jdk.internal.util.xml.XMLStreamException;
import jdk.internal.util.xml.XMLStreamWriter;
import jdk.internal.util.xml.impl.XMLWriter;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    static final int STATE_XML_DECL = 1;
    static final int STATE_PROLOG = 2;
    static final int STATE_DTD_DECL = 3;
    static final int STATE_ELEMENT = 4;
    static final int ELEMENT_STARTTAG_OPEN = 10;
    static final int ELEMENT_STARTTAG_CLOSE = 11;
    static final int ELEMENT_ENDTAG_OPEN = 12;
    static final int ELEMENT_ENDTAG_CLOSE = 13;
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String ENCODING_PREFIX = "&#x";
    public static final char SPACE = ' ';
    public static final char AMPERSAND = '&';
    public static final char DOUBLEQUOT = '\"';
    public static final char SEMICOLON = ';';
    private int _state = 0;
    private Element _currentEle;
    private XMLWriter _writer;
    private String _encoding;
    boolean _escapeCharacters = true;
    private boolean _doIndent = true;
    private char[] _lineSep = System.getProperty("line.separator").toCharArray();

    public XMLStreamWriterImpl(OutputStream outputStream) throws XMLStreamException {
        this(outputStream, "UTF-8");
    }

    public XMLStreamWriterImpl(OutputStream outputStream, String string) throws XMLStreamException {
        Charset charset = null;
        if (string == null) {
            this._encoding = "UTF-8";
        } else {
            try {
                charset = this.getCharset(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException(unsupportedEncodingException);
            }
            this._encoding = string;
        }
        this._writer = new XMLWriter(outputStream, string, charset);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(this._encoding, "1.0");
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument(this._encoding, string, null);
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.writeStartDocument(string, string2, null);
    }

    public void writeStartDocument(String string, String string2, String string3) throws XMLStreamException {
        if (this._state > 0) {
            throw new XMLStreamException("XML declaration must be as the first line in the XML document.");
        }
        this._state = 1;
        String string4 = string;
        if (string4 == null) {
            string4 = this._encoding;
        } else {
            try {
                this.getCharset(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException(unsupportedEncodingException);
            }
        }
        if (string2 == null) {
            string2 = "1.0";
        }
        this._writer.write("<?xml version=\"");
        this._writer.write(string2);
        this._writer.write(34);
        if (string4 != null) {
            this._writer.write(" encoding=\"");
            this._writer.write(string4);
            this._writer.write(34);
        }
        if (string3 != null) {
            this._writer.write(" standalone=\"");
            this._writer.write(string3);
            this._writer.write(34);
        }
        this._writer.write("?>");
        this.writeLineSeparator();
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._writer.write(string);
        this.writeLineSeparator();
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        if (string == null || string.isEmpty()) {
            throw new XMLStreamException("Local Name cannot be null or empty");
        }
        this._state = 4;
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._currentEle = new Element(this._currentEle, string, false);
        this.openStartTag();
        this._writer.write(string);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._currentEle = new Element(this._currentEle, string, true);
        this.openStartTag();
        this._writer.write(string);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (this._currentEle.getState() != 10) {
            throw new XMLStreamException("Attribute not associated with any element");
        }
        this._writer.write(32);
        this._writer.write(string);
        this._writer.write("=\"");
        this.writeXMLContent(string2, true, true);
        this._writer.write(34);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        while (this._currentEle != null) {
            if (!this._currentEle.isEmpty()) {
                this._writer.write(OPEN_END_TAG);
                this._writer.write(this._currentEle.getLocalName());
                this._writer.write(62);
            }
            this._currentEle = this._currentEle.getParent();
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        if (this._currentEle == null) {
            throw new XMLStreamException("No element was found to write");
        }
        if (this._currentEle.isEmpty()) {
            return;
        }
        this._writer.write(OPEN_END_TAG);
        this._writer.write(this._currentEle.getLocalName());
        this._writer.write(62);
        this.writeLineSeparator();
        this._currentEle = this._currentEle.getParent();
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("cdata cannot be null");
        }
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._writer.write(START_CDATA);
        this._writer.write(string);
        this._writer.write(END_CDATA);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this.writeXMLContent(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this.writeXMLContent(cArray, n, n2, this._escapeCharacters);
    }

    @Override
    public void close() throws XMLStreamException {
        if (this._writer != null) {
            this._writer.close();
        }
        this._writer = null;
        this._currentEle = null;
        this._state = 0;
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    public void setDoIndent(boolean bl) {
        this._doIndent = bl;
    }

    private void writeXMLContent(char[] cArray, int n, int n2, boolean bl) throws XMLStreamException {
        if (!bl) {
            this._writer.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        block5: for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            if (!this._writer.canEncode(c)) {
                this._writer.write(cArray, n3, i - n3);
                this._writer.write(ENCODING_PREFIX);
                this._writer.write(Integer.toHexString(c));
                this._writer.write(59);
                n3 = i + 1;
                continue;
            }
            switch (c) {
                case '<': {
                    this._writer.write(cArray, n3, i - n3);
                    this._writer.write("&lt;");
                    n3 = i + 1;
                    continue block5;
                }
                case '&': {
                    this._writer.write(cArray, n3, i - n3);
                    this._writer.write("&amp;");
                    n3 = i + 1;
                    continue block5;
                }
                case '>': {
                    this._writer.write(cArray, n3, i - n3);
                    this._writer.write("&gt;");
                    n3 = i + 1;
                }
            }
        }
        this._writer.write(cArray, n3, n4 - n3);
    }

    private void writeXMLContent(String string) throws XMLStreamException {
        if (string != null && !string.isEmpty()) {
            this.writeXMLContent(string, this._escapeCharacters, false);
        }
    }

    private void writeXMLContent(String string, boolean bl, boolean bl2) throws XMLStreamException {
        if (!bl) {
            this._writer.write(string);
            return;
        }
        int n = 0;
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (!this._writer.canEncode(c)) {
                this._writer.write(string, n, i - n);
                this._writer.write(ENCODING_PREFIX);
                this._writer.write(Integer.toHexString(c));
                this._writer.write(59);
                n = i + 1;
                continue;
            }
            switch (c) {
                case '<': {
                    this._writer.write(string, n, i - n);
                    this._writer.write("&lt;");
                    n = i + 1;
                    continue block6;
                }
                case '&': {
                    this._writer.write(string, n, i - n);
                    this._writer.write("&amp;");
                    n = i + 1;
                    continue block6;
                }
                case '>': {
                    this._writer.write(string, n, i - n);
                    this._writer.write("&gt;");
                    n = i + 1;
                    continue block6;
                }
                case '\"': {
                    this._writer.write(string, n, i - n);
                    if (bl2) {
                        this._writer.write("&quot;");
                    } else {
                        this._writer.write(34);
                    }
                    n = i + 1;
                }
            }
        }
        this._writer.write(string, n, n2 - n);
    }

    private void openStartTag() throws XMLStreamException {
        this._currentEle.setState(10);
        this._writer.write(60);
    }

    private void closeStartTag() throws XMLStreamException {
        if (this._currentEle.isEmpty()) {
            this._writer.write(CLOSE_EMPTY_ELEMENT);
        } else {
            this._writer.write(62);
        }
        if (this._currentEle.getParent() == null) {
            this.writeLineSeparator();
        }
        this._currentEle.setState(11);
    }

    private void writeLineSeparator() throws XMLStreamException {
        if (this._doIndent) {
            this._writer.write(this._lineSep, 0, this._lineSep.length);
        }
    }

    private Charset getCharset(String string) throws UnsupportedEncodingException {
        Charset charset;
        if (string.equalsIgnoreCase("UTF-32")) {
            throw new UnsupportedEncodingException("The basic XMLWriter does not support " + string);
        }
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
        return charset;
    }

    protected class Element {
        protected Element _parent;
        protected short _Depth;
        boolean _isEmptyElement = false;
        String _localpart;
        int _state;

        public Element() {
        }

        public Element(Element element, String string, boolean bl) {
            this._parent = element;
            this._localpart = string;
            this._isEmptyElement = bl;
        }

        public Element getParent() {
            return this._parent;
        }

        public String getLocalName() {
            return this._localpart;
        }

        public int getState() {
            return this._state;
        }

        public void setState(int n) {
            this._state = n;
        }

        public boolean isEmpty() {
            return this._isEmptyElement;
        }
    }
}

