/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jdk.internal.instrumentation.Logger;
import jdk.internal.instrumentation.TypeMapping;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.Handle;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.RemappingMethodAdapter;
import jdk.internal.org.objectweb.asm.commons.SimpleRemapper;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;

final class MethodMergeAdapter
extends ClassVisitor {
    private final ClassNode cn;
    private final List<Method> methodFilter;
    private final Map<String, String> typeMap;
    private final Logger logger;

    public MethodMergeAdapter(ClassVisitor classVisitor, ClassNode classNode, List<Method> list, TypeMapping[] typeMappingArray, Logger logger) {
        super(327680, classVisitor);
        this.cn = classNode;
        this.methodFilter = list;
        this.logger = logger;
        this.typeMap = new HashMap<String, String>();
        for (TypeMapping typeMapping : typeMappingArray) {
            this.typeMap.put(typeMapping.from().replace('.', '/'), typeMapping.to().replace('.', '/'));
        }
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super.visit(n, n2, string, string2, string3, stringArray);
        this.typeMap.put(this.cn.name, string);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (this.methodInFilter(string, string2)) {
            this.logger.trace("Deleting " + string + string2);
            return null;
        }
        return super.visitMethod(n, string, string2, string3, stringArray);
    }

    @Override
    public void visitEnd() {
        SimpleRemapper simpleRemapper = new SimpleRemapper(this.typeMap);
        LinkedList<MethodNode> linkedList = new LinkedList<MethodNode>();
        for (MethodNode stringArray : this.cn.methods) {
            if (!this.methodInFilter(stringArray.name, stringArray.desc)) continue;
            linkedList.add(stringArray);
        }
        while (!linkedList.isEmpty()) {
            MethodNode methodNode = (MethodNode)linkedList.remove(0);
            this.logger.trace("Copying method: " + methodNode.name + methodNode.desc);
            this.logger.trace("   with mapper: " + this.typeMap);
            String[] stringArray = methodNode.exceptions.toArray(new String[0]);
            MethodVisitor methodVisitor = this.cv.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, stringArray);
            methodNode.instructions.resetLabels();
            methodNode.accept(new RemappingMethodAdapter(methodNode.access, methodNode.desc, methodVisitor, simpleRemapper));
            this.findMethodsReferencedByInvokeDynamic(methodNode, linkedList);
        }
        super.visitEnd();
    }

    private void findMethodsReferencedByInvokeDynamic(final MethodNode methodNode, final List<MethodNode> list) {
        methodNode.accept(new MethodVisitor(327680){

            @Override
            public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
                for (Object object : objectArray) {
                    if (!(object instanceof Handle)) continue;
                    Handle handle2 = (Handle)object;
                    MethodNode methodNode2 = MethodMergeAdapter.findMethod(MethodMergeAdapter.this.cn, handle2);
                    if (methodNode2 == null) {
                        MethodMergeAdapter.this.logger.error("Could not find method " + handle2.getName() + handle2.getDesc() + " referenced from an invokedynamic in " + methodNode.name + methodNode.desc + " while processing class " + ((MethodMergeAdapter)MethodMergeAdapter.this).cn.name);
                    }
                    MethodMergeAdapter.this.logger.trace("Adding method referenced from invokedynamic " + methodNode2.name + methodNode2.desc + " to the list of methods to be copied from " + ((MethodMergeAdapter)MethodMergeAdapter.this).cn.name);
                    list.add(methodNode2);
                }
            }
        });
    }

    private static MethodNode findMethod(ClassNode classNode, Handle handle) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(handle.getName()) || !methodNode.desc.equals(handle.getDesc())) continue;
            return methodNode;
        }
        return null;
    }

    private boolean methodInFilter(String string, String string2) {
        for (Method method : this.methodFilter) {
            if (!method.getName().equals(string) || !Type.getMethodDescriptor(method).equals(string2)) continue;
            return true;
        }
        return false;
    }
}

