/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.button;

import com.richclientgui.toolbox.button.CoolButtonSelectionEvent;
import com.richclientgui.toolbox.button.CoolButtonSelectionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CoolButton
extends Canvas {
    private static final int MIN_PIXEL_VALUE = 10;
    private final boolean isToggleButton;
    private boolean isToggled = false;
    private ButtonState currentState;
    private final ButtonState normalState;
    private final ButtonState hoverState;
    private final ButtonState pressedState;
    private final Image normalStateImage;
    private final Image normalStateFocusedImage;
    private final Image hoverStateImage;
    private final Image hoverStateFocusedImage;
    private final Image pressedStateImage;
    private final Image pressedStateFocusedImage;
    private final Image normalStateDisabledImage;
    private final Image normalToggledStateImage;
    private final Image normalToggledStateFocusedImage;
    private final Image hoverToggledStateImage;
    private final Image hoverToggledStateFocusedImage;
    private final Image pressedToggledStateImage;
    private final Image pressedToggledStateFocusedImage;
    private final Image normalToggledDisabledState;
    private String tooltipText;
    private String toggledTooltipText;
    private boolean focused = false;
    private final List<CoolButtonSelectionListener> listeners = new ArrayList<CoolButtonSelectionListener>();
    private boolean hotSpot = false;
    private boolean hotSpotToggled = false;
    private ImageData hotSpotMatrix;
    private ImageData hotSpotMatrixToggled;
    private boolean inHotSpot = true;

    public CoolButton(Composite parent, Image normalStateImage, Image hoverStateImage, Image pressedStateImage) {
        this(parent, 8, normalStateImage, hoverStateImage, pressedStateImage, normalStateImage, null, null, null, null, normalStateImage, hoverStateImage, pressedStateImage, null, null, null);
    }

    public CoolButton(Composite parent, Image normalStateImage, Image hoverStateImage, Image pressedStateImage, Image normalStateDisabledImage) {
        this(parent, 8, normalStateImage, hoverStateImage, pressedStateImage, normalStateDisabledImage, null, null, null, null, normalStateImage, hoverStateImage, pressedStateImage, null, null, null);
    }

    public CoolButton(Composite parent, Image normalStateImage, Image hoverStateImage, Image pressedStateImage, Image normalStateDisabledImage, Image normalStateFocusedImage, Image hoverStateFocusedImage, Image pressedStateFocusedImage) {
        this(parent, 8, normalStateImage, hoverStateImage, pressedStateImage, normalStateDisabledImage, null, null, null, null, normalStateFocusedImage, hoverStateFocusedImage, pressedStateFocusedImage, null, null, null);
    }

    public CoolButton(Composite parent, Image normalStateImage, Image hoverStateImage, Image pressedStateImage, Image normalToggledStateImage, Image hoverToggledStateImage, Image pressedToggledStateImage) {
        this(parent, 2, normalStateImage, hoverStateImage, pressedStateImage, normalStateImage, normalToggledStateImage, hoverToggledStateImage, pressedToggledStateImage, normalToggledStateImage, normalStateImage, hoverStateImage, pressedStateImage, normalToggledStateImage, hoverToggledStateImage, pressedToggledStateImage);
    }

    public CoolButton(Composite parent, Image normalStateImage, Image hoverStateImage, Image pressedStateImage, Image normalStateDisabledImage, Image normalToggledStateImage, Image hoverToggledStateImage, Image pressedToggledStateImage, Image normalToggledDisabledState) {
        this(parent, 2, normalStateImage, hoverStateImage, pressedStateImage, normalStateDisabledImage, normalToggledStateImage, hoverToggledStateImage, pressedToggledStateImage, normalToggledDisabledState, normalStateImage, hoverStateImage, pressedStateImage, normalToggledStateImage, hoverToggledStateImage, pressedToggledStateImage);
    }

    public CoolButton(Composite parent, int style, Image normalStateImage, Image hoverStateImage, Image pressedStateImage, Image normalStateDisabledImage, Image normalToggledStateImage, Image hoverToggledStateImage, Image pressedToggledStateImage, Image normalToggledDisabledState, Image normalStateFocusedImage, Image hoverStateFocusedImage, Image pressedStateFocusedImage, Image normalToggledStateFocusedImage, Image hoverToggledStateFocusedImage, Image pressedToggledStateFocusedImage) {
        super(parent, style | 0x20000000);
        this.normalStateImage = normalStateImage;
        this.hoverStateImage = hoverStateImage;
        this.pressedStateImage = pressedStateImage;
        this.normalStateDisabledImage = normalStateDisabledImage == null ? normalStateImage : normalStateDisabledImage;
        this.normalToggledStateImage = normalToggledStateImage;
        this.hoverToggledStateImage = hoverToggledStateImage;
        this.pressedToggledStateImage = pressedToggledStateImage;
        this.normalToggledDisabledState = normalToggledDisabledState == null ? normalToggledStateImage : normalToggledDisabledState;
        this.normalStateFocusedImage = normalStateFocusedImage == null ? normalStateImage : normalStateFocusedImage;
        this.hoverStateFocusedImage = hoverStateFocusedImage == null ? hoverStateImage : hoverStateFocusedImage;
        this.pressedStateFocusedImage = pressedStateFocusedImage == null ? pressedStateImage : pressedStateFocusedImage;
        this.normalToggledStateFocusedImage = normalToggledStateFocusedImage == null ? normalToggledStateImage : normalToggledStateFocusedImage;
        this.hoverToggledStateFocusedImage = hoverToggledStateFocusedImage == null ? hoverToggledStateImage : hoverToggledStateFocusedImage;
        this.pressedToggledStateFocusedImage = pressedToggledStateFocusedImage == null ? pressedToggledStateImage : pressedToggledStateFocusedImage;
        this.setLayout((Layout)new GridLayout(1, false));
        boolean bl = this.isToggleButton = 2 == (style & 2);
        if (!(this.isToggleButton || normalStateImage != null && hoverStateImage != null && pressedStateImage != null)) {
            throw new IllegalArgumentException("Any of 3 images parameters: normal, hover and pressed, may not be null");
        }
        if (this.isToggleButton && (normalToggledStateImage == null || hoverStateFocusedImage == null || pressedStateFocusedImage == null)) {
            throw new IllegalArgumentException("If the style SWT.TOGGLE is specified the images for the toggle button may not be null");
        }
        this.normalState = new NormalButtonState();
        this.hoverState = new HoverButtonState();
        this.pressedState = new PressedButtonState();
        this.currentState = this.normalState;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(CoolButton.this.currentState.getImage(), 0, 0);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (CoolButton.this.isToggled) {
                    if ((CoolButton.this.hotSpotToggled && CoolButton.this.inHotSpot || !CoolButton.this.hotSpotToggled) && (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot)) {
                        CoolButton.this.currentState.mouseDown();
                    }
                } else if (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot) {
                    CoolButton.this.currentState.mouseDown();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (CoolButton.this.isToggled) {
                    if ((CoolButton.this.hotSpotToggled && CoolButton.this.inHotSpot || !CoolButton.this.hotSpotToggled) && (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot)) {
                        CoolButton.this.currentState.mouseUp();
                    }
                } else if (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot) {
                    CoolButton.this.currentState.mouseUp();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolButton.this.isToggled && !CoolButton.this.hotSpotToggled && !CoolButton.this.hotSpot) {
                    return;
                }
                if (!CoolButton.this.isToggled && !CoolButton.this.hotSpot) {
                    return;
                }
                boolean prevHotSpot = CoolButton.this.inHotSpot;
                CoolButton.this.inHotSpot = CoolButton.this.isInHotSpot(e.x, e.y);
                if (prevHotSpot && !CoolButton.this.inHotSpot) {
                    CoolButton.this.currentState.mouseExit();
                } else if (!prevHotSpot && CoolButton.this.inHotSpot) {
                    CoolButton.this.currentState.mouseHover();
                }
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                if (CoolButton.this.isToggled) {
                    if ((CoolButton.this.hotSpotToggled && CoolButton.this.inHotSpot || !CoolButton.this.hotSpotToggled) && (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot)) {
                        CoolButton.this.currentState.mouseHover();
                    }
                } else if (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot) {
                    CoolButton.this.currentState.mouseHover();
                }
            }

            public void mouseExit(MouseEvent e) {
                if (CoolButton.this.isToggled) {
                    if ((CoolButton.this.hotSpotToggled && CoolButton.this.inHotSpot || !CoolButton.this.hotSpotToggled) && (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot)) {
                        CoolButton.this.currentState.mouseExit();
                    }
                } else if (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot) {
                    CoolButton.this.currentState.mouseExit();
                }
            }

            public void mouseHover(MouseEvent e) {
                if (CoolButton.this.isToggled) {
                    if ((CoolButton.this.hotSpotToggled && CoolButton.this.inHotSpot || !CoolButton.this.hotSpotToggled) && (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot)) {
                        CoolButton.this.currentState.mouseHover();
                    }
                } else if (CoolButton.this.hotSpot && CoolButton.this.inHotSpot || !CoolButton.this.hotSpot) {
                    CoolButton.this.currentState.mouseHover();
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' || e.character == '\r' || e.character == '\n') {
                    CoolButton.this.currentState.mouseDown();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ' || e.character == '\r' || e.character == '\n') {
                    if (CoolButton.this.isToggleButton) {
                        CoolButton.this.isToggled = !CoolButton.this.isToggled;
                    }
                    CoolButton.this.doReleaseEvents();
                    CoolButton.this.currentState.mouseExit();
                }
            }
        });
    }

    private boolean isInHotSpot(int x, int y) {
        if (this.isToggled && this.hotSpotToggled) {
            if (y < 0 || y >= this.hotSpotMatrixToggled.height || x >= this.hotSpotMatrixToggled.width || x < 0) {
                return false;
            }
            return this.hotSpotMatrixToggled.getPixel(x, y) < 10;
        }
        if (y < 0 || y >= this.hotSpotMatrix.height || x >= this.hotSpotMatrix.width || x < 0) {
            return false;
        }
        return this.hotSpotMatrix.getPixel(x, y) < 10;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.tooltipText = string;
        super.setToolTipText(string);
    }

    public void setHotRegionMask(Image maskImage) {
        this.checkWidget();
        boolean bl = this.hotSpot = maskImage != null;
        if (maskImage == null) {
            return;
        }
        this.hotSpotMatrix = maskImage.getImageData();
    }

    public void setHotToggledRegionMask(Image maskImage) {
        this.checkWidget();
        boolean bl = this.hotSpotToggled = maskImage != null;
        if (maskImage == null) {
            return;
        }
        this.hotSpotMatrixToggled = maskImage.getImageData();
    }

    public void setToolTipTextToggled(String string) {
        this.checkWidget();
        this.toggledTooltipText = string;
    }

    public final void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            this.changeState(this.normalState);
        }
        this.redraw();
        super.setEnabled(enabled);
    }

    private void setParentTooltip(String string) {
        super.setToolTipText(string);
    }

    private synchronized void changeState(ButtonState state) {
        this.currentState = state;
        this.currentState.enter();
    }

    public void setSelection(boolean toggle) {
        this.checkWidget();
        if (this.isToggleButton) {
            this.isToggled = toggle;
            this.redraw();
        }
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.isToggleButton && this.isToggled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(CoolButtonSelectionListener listener) {
        List<CoolButtonSelectionListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(CoolButtonSelectionListener listener) {
        List<CoolButtonSelectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReleaseEvents() {
        List<CoolButtonSelectionListener> list = this.listeners;
        synchronized (list) {
            Iterator<CoolButtonSelectionListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().selectionOnRelease(new CoolButtonSelectionEvent((Object)this, 0, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPressEvents() {
        List<CoolButtonSelectionListener> list = this.listeners;
        synchronized (list) {
            Iterator<CoolButtonSelectionListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().selectionOnPress(new CoolButtonSelectionEvent((Object)this, 0, 0));
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.currentState.getImage() != null && !this.currentState.getImage().isDisposed()) {
            Rectangle bounds = this.currentState.getImage().getBounds();
            width = bounds.width;
            height = bounds.height;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    private abstract class ButtonState {
        private ButtonState() {
        }

        void enter() {
            CoolButton.this.redraw();
        }

        final Image getImage() {
            if (CoolButton.this.isToggleButton && CoolButton.this.isToggled) {
                if (!CoolButton.this.focused) {
                    return CoolButton.this.getEnabled() ? this.getToggleImage() : this.getDisabledToggledImage();
                }
                return CoolButton.this.getEnabled() ? this.getToggledFocusedImage() : this.getDisabledToggledImage();
            }
            if (!CoolButton.this.focused) {
                return CoolButton.this.getEnabled() ? this.getDefaultImage() : this.getDefaultDisabledImage();
            }
            return CoolButton.this.getEnabled() ? this.getFocusedImage() : this.getDefaultDisabledImage();
        }

        abstract Image getFocusedImage();

        abstract Image getToggledFocusedImage();

        abstract Image getToggleImage();

        abstract Image getDisabledToggledImage();

        abstract Image getDefaultImage();

        abstract Image getDefaultDisabledImage();

        void mouseUp() {
        }

        void mouseDown() {
        }

        void mouseHover() {
        }

        void mouseExit() {
        }
    }

    private class HoverButtonState
    extends ButtonState {
        private HoverButtonState() {
        }

        @Override
        void enter() {
            super.enter();
            CoolButton.this.setParentTooltip(CoolButton.this.isToggled ? CoolButton.this.toggledTooltipText : CoolButton.this.tooltipText);
        }

        @Override
        Image getToggleImage() {
            return CoolButton.this.hoverToggledStateImage;
        }

        @Override
        Image getDisabledToggledImage() {
            return CoolButton.this.normalToggledDisabledState;
        }

        @Override
        Image getDefaultImage() {
            return CoolButton.this.hoverStateImage;
        }

        @Override
        Image getDefaultDisabledImage() {
            return CoolButton.this.normalStateDisabledImage;
        }

        @Override
        Image getFocusedImage() {
            return CoolButton.this.hoverStateFocusedImage;
        }

        @Override
        Image getToggledFocusedImage() {
            return CoolButton.this.hoverToggledStateFocusedImage;
        }

        @Override
        void mouseDown() {
            CoolButton.this.changeState(CoolButton.this.pressedState);
        }

        @Override
        void mouseExit() {
            CoolButton.this.changeState(CoolButton.this.normalState);
        }
    }

    private class NormalButtonState
    extends ButtonState {
        private NormalButtonState() {
        }

        @Override
        Image getToggleImage() {
            return CoolButton.this.normalToggledStateImage;
        }

        @Override
        Image getDisabledToggledImage() {
            return CoolButton.this.normalToggledDisabledState;
        }

        @Override
        Image getDefaultImage() {
            return CoolButton.this.normalStateImage;
        }

        @Override
        Image getDefaultDisabledImage() {
            return CoolButton.this.normalStateDisabledImage;
        }

        @Override
        Image getFocusedImage() {
            return CoolButton.this.normalStateFocusedImage;
        }

        @Override
        Image getToggledFocusedImage() {
            return CoolButton.this.normalToggledStateFocusedImage;
        }

        @Override
        void mouseDown() {
            CoolButton.this.changeState(CoolButton.this.pressedState);
        }

        @Override
        void mouseHover() {
            CoolButton.this.changeState(CoolButton.this.hoverState);
        }
    }

    private class PressedButtonState
    extends ButtonState {
        private PressedButtonState() {
        }

        @Override
        Image getToggleImage() {
            return CoolButton.this.pressedToggledStateImage;
        }

        @Override
        Image getDisabledToggledImage() {
            return CoolButton.this.normalToggledDisabledState;
        }

        @Override
        Image getDefaultImage() {
            return CoolButton.this.pressedStateImage;
        }

        @Override
        Image getDefaultDisabledImage() {
            return CoolButton.this.normalStateDisabledImage;
        }

        @Override
        Image getFocusedImage() {
            return CoolButton.this.pressedStateFocusedImage;
        }

        @Override
        Image getToggledFocusedImage() {
            return CoolButton.this.pressedToggledStateFocusedImage;
        }

        @Override
        void enter() {
            super.enter();
            CoolButton.this.doPressEvents();
        }

        @Override
        void mouseUp() {
            if (CoolButton.this.isToggleButton) {
                CoolButton.this.isToggled = !CoolButton.this.isToggled;
            }
            CoolButton.this.doReleaseEvents();
            CoolButton.this.changeState(CoolButton.this.hoverState);
        }

        @Override
        void mouseExit() {
            CoolButton.this.changeState(CoolButton.this.normalState);
        }
    }
}

