/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.Tag;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;

public class TagsRestClient {
    private static final String TAG_URL = "tags";
    private final RestInvokerManager restInvokerManager;

    public TagsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countTags() {
        return this.restInvokerManager.getRestInvoker().invokeGet("tags/count", Long.class);
    }

    public Boolean existsTag(String tagId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("tags/{0}/exists", tagId), Boolean.class);
    }

    public List<Tag> getTags() {
        ParameterizedTypeReference<List<Tag>> returnTypeRef = new ParameterizedTypeReference<List<Tag>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(TAG_URL, returnTypeRef);
    }

    public List<Tag> getTags(int page, int size) {
        ParameterizedTypeReference<List<Tag>> returnTypeRef = new ParameterizedTypeReference<List<Tag>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("tags?page=" + page + "&size=" + size, returnTypeRef);
    }

    public List<Tag> getTags(String clusterId) {
        ParameterizedTypeReference<List<Tag>> returnTypeRef = new ParameterizedTypeReference<List<Tag>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("tags?clusterId={0}", clusterId), returnTypeRef);
    }

    public Tag getTag(String tagId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("tags/{0}", tagId), Tag.class);
    }

    public Tag getTagByName(String name) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("tags/name/{0}", name), Tag.class);
    }
}

