/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    private static final boolean debug = false;
    static Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    static {
        Object object;
        Sync = new Object();
        try {
            object = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            object.initialize();
        }
        catch (Throwable throwable) {
            System.err.println(String.valueOf(String.valueOf(throwable)) + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        object = System.getProperty("os.name");
        ((String)object).toLowerCase().indexOf("linux");
        System.loadLibrary("rxtxSerial");
    }

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.PortName = string;
        this.commport = commPort;
        this.PortType = n;
        this.next = null;
        this.RXTXDriver = commDriver;
    }

    private static void AddIdentifierToList(CommPortIdentifier commPortIdentifier) {
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = commPortIdentifier;
            } else {
                CommPortIdentifier commPortIdentifier2 = CommPortIndex;
                while (commPortIdentifier2.next != null) {
                    commPortIdentifier2 = commPortIdentifier2.next;
                }
                commPortIdentifier2.next = commPortIdentifier;
            }
        }
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(string, null, n, commDriver));
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(commPortOwnershipListener)) {
            this.ownershipListener.addElement(commPortOwnershipListener);
        }
    }

    void fireOwnershipEvent(int n) {
        if (this.ownershipListener != null) {
            Enumeration enumeration = this.ownershipListener.elements();
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)enumeration.nextElement();
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }

    public String getCurrentOwner() {
        return this.Owner;
    }

    public String getName() {
        return this.PortName;
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier;
        Object object = Sync;
        synchronized (object) {
            commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null && commPortIdentifier.commport != commPort) {
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier;
        Object object = Sync;
        synchronized (object) {
            CommPortIdentifier.getPortIdentifiers();
            commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.PortName.equals(string)) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static Enumeration getPortIdentifiers() {
        Object object = Sync;
        synchronized (object) {
            HashMap<String, CommPortIdentifier> hashMap = new HashMap<String, CommPortIdentifier>();
            CommPortIdentifier commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null) {
                hashMap.put(commPortIdentifier.PortName, commPortIdentifier);
                commPortIdentifier = commPortIdentifier.next;
            }
            CommPortIndex = null;
            try {
                CommDriver commDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                commDriver.initialize();
                CommPortIdentifier commPortIdentifier2 = CommPortIndex;
                CommPortIdentifier commPortIdentifier3 = null;
                while (commPortIdentifier2 != null) {
                    CommPortIdentifier commPortIdentifier4 = (CommPortIdentifier)hashMap.get(commPortIdentifier2.PortName);
                    if (commPortIdentifier4 != null && commPortIdentifier4.PortType == commPortIdentifier2.PortType) {
                        commPortIdentifier4.RXTXDriver = commPortIdentifier2.RXTXDriver;
                        commPortIdentifier4.next = commPortIdentifier2.next;
                        if (commPortIdentifier3 == null) {
                            CommPortIndex = commPortIdentifier4;
                        } else {
                            commPortIdentifier3.next = commPortIdentifier4;
                        }
                        commPortIdentifier3 = commPortIdentifier4;
                    } else {
                        commPortIdentifier3 = commPortIdentifier2;
                    }
                    commPortIdentifier2 = commPortIdentifier2.next;
                }
            }
            catch (Throwable throwable) {
                System.err.println(String.valueOf(String.valueOf(throwable)) + " thrown while loading " + "gnu.io.RXTXCommDriver");
            }
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.PortType;
    }

    void internalClosePort() {
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            this.Owner = null;
            this.Available = true;
            this.commport = null;
            this.notifyAll();
        }
        this.fireOwnershipEvent(2);
    }

    public synchronized boolean isCurrentlyOwned() {
        return this.Available ^ true;
    }

    private native String native_psmisc_report_owner(String var1);

    public synchronized CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommPort open(String string, int n) throws PortInUseException {
        CommPortIdentifier commPortIdentifier;
        boolean bl;
        Object object = this;
        synchronized (object) {
            bl = this.Available;
            if (bl) {
                this.Available = false;
                this.Owner = string;
            }
        }
        if (!bl) {
            long l = System.currentTimeMillis() + (long)n;
            this.fireOwnershipEvent(3);
            CommPortIdentifier commPortIdentifier2 = this;
            synchronized (commPortIdentifier2) {
                long l2;
                while (!this.Available && (l2 = System.currentTimeMillis()) < l) {
                    try {
                        this.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                bl = this.Available;
                if (bl) {
                    this.Available = false;
                    this.Owner = string;
                }
            }
        }
        if (!bl) {
            throw new PortInUseException(this.getCurrentOwner());
        }
        try {
            if (this.commport == null) {
                this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
            }
            if (this.commport == null) throw new PortInUseException(this.native_psmisc_report_owner(this.PortName));
            this.fireOwnershipEvent(1);
            object = this.commport;
            Object var6_8 = null;
            if (this.commport != null) return object;
            commPortIdentifier = this;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.commport != null) throw throwable;
            CommPortIdentifier commPortIdentifier3 = this;
            synchronized (commPortIdentifier3) {
                this.Available = true;
                this.Owner = null;
                throw throwable;
            }
        }
        synchronized (commPortIdentifier) {
            this.Available = true;
            this.Owner = null;
            return object;
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(commPortOwnershipListener);
        }
    }
}

