/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.WithParent;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.provider.ICachedLazyTreeContentProvider;
import su.artix.yuki.provider.SimpleLRUCache;

public class GroupTreeLazyContentProvider<T extends WithParent>
implements ICachedLazyTreeContentProvider {
    private static final Logger log = LoggerFactory.getLogger(GroupTreeLazyContentProvider.class);
    private final Class<T> cl;
    private TreeViewer viewer;
    private final int cacheSize = 150;
    private final SimpleLRUCache<Integer, T> cachedRecords;
    private final SimpleLRUCache<T, List<T>> cachedChildRecords;

    private void fillCache(int index) {
        log.debug("filling cash for index {}", (Object)index);
        int minIndex = Math.max(index - 75, 0);
        int maxIndex = Math.min(index + 75, this.getRootsCount());
        log.debug("from {} to {}", (Object)minIndex, (Object)maxIndex);
        List<T> recordList = this.getRoots(minIndex, maxIndex - minIndex);
        log.debug("returned list size {}", (Object)recordList.size());
        int i = minIndex;
        while (i < maxIndex) {
            this.cachedRecords.put((Object)i, (Object)((WithParent)recordList.get(i - minIndex)));
            ++i;
        }
        log.trace("end fill cash");
    }

    public GroupTreeLazyContentProvider(Class<T> cl, TreeViewer viewer) {
        this.cl = cl;
        this.viewer = viewer;
        this.cachedRecords = new SimpleLRUCache(150);
        this.cachedChildRecords = new SimpleLRUCache(150);
        log.trace("constract");
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void updateElement(Object parent, int index) {
        Object element;
        log.debug("update element index={}", (Object)index);
        if (this.isRoot(parent)) {
            if (!this.cachedRecords.containsKey((Object)index)) {
                this.fillCache(index);
            }
            element = this.cachedRecords.get((Object)index);
        } else {
            if (!this.cachedChildRecords.containsKey(parent) || ((List)this.cachedChildRecords.get(parent)).size() <= index) {
                WithParent state = (WithParent)LibActivator.getDefault().getActualClassResolver().getInstance(this.cl);
                state.setParentCode(((WithParent)parent).getCode());
                List a = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).getList((Object)state);
                log.info("list size={}", (Object)a.size());
                this.cachedChildRecords.put((Object)((WithParent)parent), (Object)a);
            }
            element = ((List)this.cachedChildRecords.get(parent)).get(index);
        }
        this.viewer.replace(parent, index, element);
        this.updateChildCount(element, -1);
    }

    public void updateChildCount(Object element, int currentChildCount) {
        log.trace("update child count for {}", element);
        if (this.isRoot(element)) {
            int count = this.getRootsCount();
            log.info("count={}", (Object)count);
            this.viewer.setChildCount(element, count);
        } else {
            this.viewer.setChildCount(element, this.getElementCount((WithParent)element));
        }
    }

    private boolean isRoot(Object element) {
        return element == null || ((WithParent)element).getCode() == null;
    }

    public int getRootsCount() {
        Object o = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).findByNamedQuery("findRootCount" + this.cl.getSimpleName(), Integer.valueOf(0), Integer.valueOf(1)).get(0);
        return ((Long)o).intValue();
    }

    public List<T> getRoots(Integer firstResult, Integer maxResults) {
        log.trace("get roots maxResults={}", (Object)maxResults);
        List roots = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).findByNamedQuery("findRoot" + this.cl.getSimpleName(), firstResult, maxResults);
        log.trace("get roots size {}", (Object)roots.size());
        return roots;
    }

    public int getElementCount(T parent) {
        log.trace("get element count for parent:{}", parent);
        WithParent state = (WithParent)LibActivator.getDefault().getActualClassResolver().getInstance(this.cl);
        state.setParentCode(parent.getCode());
        int result = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).getItemCount((Object)state).intValue();
        log.trace("result={} element count for parent", (Object)result);
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    private void clearCache() {
        this.cachedRecords.clear();
        this.cachedChildRecords.clear();
    }

    public void disposeCache() {
        this.clearCache();
        this.updateChildCount(this.viewer.getTree().getData(), -1);
    }
}

