/*
 * Decompiled with CFR 0.152.
 */
package su.artix.lazyload;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.OneToMany;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DomainUtils;
import su.artix.lazyload.LoadUtils;
import su.artix.rll.core.PreloadService;

public class LazyLoadUtils
implements LoadUtils {
    private static final Logger log = LoggerFactory.getLogger(LazyLoadUtils.class);
    private PreloadService preloadService;

    @Override
    public void deepCopyCollection(Object donor, Object recipient, boolean newSubElements) {
        List collections = DomainUtils.getAnnotationField(recipient.getClass(), OneToMany.class, (boolean)false);
        try {
            for (String collection : collections) {
                log.trace("work with collection: {}", (Object)collection);
                this.setCollection(donor, recipient, collection, newSubElements);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setCollection(Object donor, Object recipient, String collectionName, boolean newSubElements) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String getterName = this.getGetterName(collectionName);
        log.trace("getter name={}", (Object)getterName);
        Collection preloadedCollection = (Collection)this.preloadService.preloadCollection(donor, getterName);
        this.changeParent(preloadedCollection, recipient, newSubElements);
        this.setPreloadedResult(recipient, getterName, preloadedCollection);
    }

    private String getGetterName(String collectionName) {
        return "get" + this.getMethodName(collectionName);
    }

    private String getSetterName(String collectionName) {
        return "set" + this.getMethodName(collectionName);
    }

    private String getMethodName(String fieldName) {
        return String.valueOf(String.valueOf(fieldName.charAt(0)).toUpperCase()) + fieldName.substring(1);
    }

    private void changeParent(Collection preloadedCollection, Object recipient, boolean newSubElements) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        log.trace("set parent of collection elements");
        if (preloadedCollection != null && !preloadedCollection.isEmpty()) {
            String finded = null;
            String idField = null;
            Object firstElement = preloadedCollection.iterator().next();
            finded = this.getParenFieldName(recipient, firstElement);
            idField = DomainUtils.getIdColum(firstElement.getClass());
            if (finded != null) {
                for (Object element : preloadedCollection) {
                    String setterName = this.getSetterName(finded);
                    Method setter = element.getClass().getMethod(setterName, recipient.getClass());
                    setter.invoke(element, recipient);
                    if (!newSubElements) continue;
                    DomainUtils.setFieldValue((String)idField, element, null);
                }
            }
        }
    }

    private String getParenFieldName(Object recipient, Object element) {
        Field[] fields;
        Field[] fieldArray = fields = element.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().equals(recipient.getClass())) {
                log.trace("parent field name={}", (Object)field.getName());
                return field.getName();
            }
            ++n2;
        }
        return null;
    }

    private void setPreloadedResult(Object target, String getterName, Object preloadedContent) {
        String setterName;
        if (target != null && getterName != null && preloadedContent != null && (setterName = getterName.replaceFirst("get", "set")).startsWith("set")) {
            try {
                if (preloadedContent instanceof Collection) {
                    this.setPreloadedCollection(target, setterName, (Collection)preloadedContent);
                } else if (preloadedContent instanceof Map) {
                    this.setPreloadedMap(target, setterName, (Map)preloadedContent);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setPreloadedMap(Object target, String setterName, Map preloadedMap) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method setter = target.getClass().getMethod(setterName, Map.class);
        setter.invoke(target, preloadedMap);
    }

    private void setPreloadedCollection(Object target, String setterName, Collection preloadedCollection) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (preloadedCollection instanceof List) {
            Method setter = target.getClass().getMethod(setterName, List.class);
            setter.invoke(target, preloadedCollection);
        } else if (preloadedCollection instanceof Set) {
            Method setter = target.getClass().getMethod(setterName, Set.class);
            setter.invoke(target, preloadedCollection);
        }
    }

    public PreloadService getPreloadService() {
        return this.preloadService;
    }

    public void setPreloadService(PreloadService preloadService) {
        this.preloadService = preloadService;
    }
}

