/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.bundle;

import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtils {
    private static final int SLEEP_TIME = 1000;
    private static final int TRY_COUNT = 5;
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    private ServiceUtils() {
    }

    private static <T> T innerGetBean(BundleContext context, Class<T> clazz, String beanName) {
        try {
            ServiceReference reference = context.getServiceReferences(clazz.getName(), "(org.springframework.osgi.bean.name=" + beanName + ")")[0];
            return (T)context.getService(reference);
        }
        catch (InvalidSyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NullPointerException e) {
            log.error("{} class {} and bean name {}", new Object[]{e.getMessage(), clazz, beanName, e});
            return null;
        }
    }

    public static <T> T getBeanByClass(BundleContext context, Class<T> clazz, String beanName) {
        log.trace("get bean by class {} and bean name {}", clazz, (Object)beanName);
        T bean = null;
        int count = 0;
        while (count < 5) {
            bean = StringUtils.isEmpty((String)beanName) ? (T)ServiceUtils.innerGetBean(context, clazz) : (T)ServiceUtils.innerGetBean(context, clazz, beanName);
            if (bean != null) break;
            log.debug("try next again, count={}", (Object)(++count));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }

    private static <T> T innerGetBean(BundleContext context, Class<T> clazz) {
        ServiceReference reference = context.getServiceReference(clazz.getName());
        if (reference == null) {
            log.error("reference for class:{} is null", clazz);
            return null;
        }
        return (T)context.getService(reference);
    }

    public static <T> T getBeanByClass(BundleContext context, Class<T> clazz) {
        log.trace("get bean by class {}", clazz);
        return ServiceUtils.getBeanByClass(context, clazz, null);
    }
}

