/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.utils;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.Command;
import ru.ssa.cashadmin.domain.Menu;
import ru.ssa.cashadmin.domain.Menuitem;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;

public class MenuImport {
    private static final Logger log = LoggerFactory.getLogger(MenuImport.class);
    private HierarchicalMenuItem resultMenu;
    private Document document;

    private Menuitem parseMenuItem(Element parentElement, Cmaction cmaction, Menu menu) {
        Menuitem menuitem = LibActivator.getDefault().getActualClassResolver().getInstance(Menuitem.class);
        menuitem.setCmactioncode(cmaction);
        menuitem.setMenucode(menu);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("code")) {
                menuitem.setMenuitemcode(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("order")) {
                menuitem.setMenuitemorder(Integer.valueOf(attribute.getValue()));
            }
            ++i;
        }
        return menuitem;
    }

    private Menu parseMenu(Element parentElement) {
        Menu menu = LibActivator.getDefault().getActualClassResolver().getInstance(Menu.class);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("code")) {
                menu.setMenucode(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("name")) {
                menu.setMenuname(attribute.getValue());
            }
            ++i;
        }
        return menu;
    }

    private Actionparameter parseParameters(Element parentElement, Cmaction cmaction) {
        Actionparameter parameter = LibActivator.getDefault().getActualClassResolver().getInstance(Actionparameter.class);
        parameter.setCmaction(cmaction);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("code")) {
                parameter.setActionparametercode(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("order")) {
                parameter.setParameterorder(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("value")) {
                parameter.setParametervalue(attribute.getValue());
            }
            ++i;
        }
        return parameter;
    }

    private Command parseCommand(Element parentElement) {
        Command command = LibActivator.getDefault().getActualClassResolver().getInstance(Command.class);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("code")) {
                command.setCommandcode(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("name")) {
                command.setCommandname(attribute.getValue());
            } else if (attribute.getName().equals("description")) {
                command.setDescription(attribute.getValue());
            }
            ++i;
        }
        return command;
    }

    private Cmaction parseCmaction(Element parentElement) {
        Cmaction cmaction = LibActivator.getDefault().getActualClassResolver().getInstance(Cmaction.class);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("code")) {
                cmaction.setCmactioncode(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("name")) {
                cmaction.setCmactionname(attribute.getValue());
            }
            ++i;
        }
        i = 0;
        while (i < parentElement.nodeCount()) {
            Node node = parentElement.node(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.getName().equals("TABLE_COMMAND")) {
                    cmaction.setCommand(this.parseCommand(element));
                } else if (element.getName().equals("TABLE_PARAMETER")) {
                    cmaction.getActionparameterCollection().add(this.parseParameters(element, cmaction));
                }
            }
            ++i;
        }
        return cmaction;
    }

    private HierarchicalMenuItem parseMenuTree(Element parentElement, HierarchicalMenuItem item) {
        HierarchicalMenuItem menuItem = new HierarchicalMenuItem();
        menuItem.setParent(item);
        int i = 0;
        while (i < parentElement.attributeCount()) {
            Attribute attribute = parentElement.attribute(i);
            if (attribute.getName().equals("order")) {
                menuItem.setOrder(Integer.valueOf(attribute.getValue()));
            } else if (attribute.getName().equals("name")) {
                menuItem.setName(attribute.getValue());
            }
            ++i;
        }
        i = 0;
        while (i < parentElement.nodeCount()) {
            Node node = parentElement.node(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.getName().equals("TREE_MENU")) {
                    menuItem.getMenues().add(this.parseMenuTree(element, menuItem));
                }
                if (element.getName().equals("TREE_ACTION")) {
                    menuItem.getActions().add(this.parseMenuTree(element, menuItem));
                } else if (element.getName().equals("TABLE_CMACTION")) {
                    menuItem.setCmaction(this.parseCmaction(element));
                } else if (element.getName().equals("TABLE_MENU")) {
                    menuItem.setMenu(this.parseMenu(element));
                } else if (element.getName().equals("TABLE_MENUITEM")) {
                    menuItem.setMenuitem(this.parseMenuItem(element, menuItem.getCmaction(), menuItem.getMenu()));
                }
            }
            ++i;
        }
        return menuItem;
    }

    private HierarchicalMenuItem parseDocument(Document document, HierarchicalMenuItem item) {
        return this.parseMenuTree(document.getRootElement(), item);
    }

    public HierarchicalMenuItem importMenu(String fileName, HierarchicalMenuItem item) {
        try {
            SAXReader reader = new SAXReader();
            this.document = reader.read(fileName);
            this.resultMenu = this.parseDocument(this.document, item);
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.resultMenu;
    }
}

