/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.utils;

import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.ActualClassResolver;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.SessionFactoryBuilder;
import ru.ssa.cashadmin.domain.Abnormalquantity;
import ru.ssa.cashadmin.domain.AccumulateSprices;
import ru.ssa.cashadmin.domain.Actionpanel;
import ru.ssa.cashadmin.domain.Actionpanelitem;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.Button;
import ru.ssa.cashadmin.domain.Campaign;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.Cardgroup;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Catalogattribute;
import ru.ssa.cashadmin.domain.Catalogrestrict;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.Cmevent;
import ru.ssa.cashadmin.domain.Command;
import ru.ssa.cashadmin.domain.Connect;
import ru.ssa.cashadmin.domain.Consultant;
import ru.ssa.cashadmin.domain.Country;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.Disccard;
import ru.ssa.cashadmin.domain.DisccardAccumulate;
import ru.ssa.cashadmin.domain.DisccardAccumulatePK;
import ru.ssa.cashadmin.domain.DiscountAuto;
import ru.ssa.cashadmin.domain.DiscountAutoPK;
import ru.ssa.cashadmin.domain.DiscountFixed;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.HotKey;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import ru.ssa.cashadmin.domain.Kbkey;
import ru.ssa.cashadmin.domain.KbkeyPK;
import ru.ssa.cashadmin.domain.Kit;
import ru.ssa.cashadmin.domain.Kitdisc;
import ru.ssa.cashadmin.domain.Kitgoods;
import ru.ssa.cashadmin.domain.Macro;
import ru.ssa.cashadmin.domain.Macroparameters;
import ru.ssa.cashadmin.domain.Medicine;
import ru.ssa.cashadmin.domain.Mol;
import ru.ssa.cashadmin.domain.Note;
import ru.ssa.cashadmin.domain.RemainBarcode;
import ru.ssa.cashadmin.domain.RemainDarftBeer;
import ru.ssa.cashadmin.domain.Role;
import ru.ssa.cashadmin.domain.Rolerelation;
import ru.ssa.cashadmin.domain.Roleuser;
import ru.ssa.cashadmin.domain.Sprices;
import ru.ssa.cashadmin.domain.Timeperiod;
import ru.ssa.cashadmin.domain.Tr;
import ru.ssa.cashadmin.domain.TrPK;
import ru.ssa.cashadmin.domain.Units;
import ru.ssa.cashadmin.domain.Valut;
import ru.ssa.cashadmin.domain.Vat;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;

public enum JaxbUtil {
    INSTANCE;

    private static final int MAX_VERSION = 150;
    private static final Logger log;
    private static ActualClassResolver resolver;

    static {
        log = LoggerFactory.getLogger(JaxbUtil.class);
    }

    public void exportToXML(String xmlFileName, DomainCollections domainCollections) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFileName), "UTF-8");
            JAXBContext jaxbContext = this.createContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)domainCollections, (Writer)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private JAXBContext createContext() throws JAXBException {
        ArrayList classes = new ArrayList();
        classes.addAll(this.findClass(DomainCollections.class));
        classes.addAll(this.findClass(Command.class));
        classes.addAll(this.findClass(Cmaction.class));
        classes.addAll(this.findClass(Actionparameter.class));
        classes.addAll(this.findClass(Kbkey.class));
        classes.addAll(this.findClass(KbkeyPK.class));
        classes.addAll(this.findClass(Tr.class));
        classes.addAll(this.findClass(TrPK.class));
        classes.addAll(this.findClass(Macro.class));
        classes.addAll(this.findClass(Macroparameters.class));
        classes.addAll(this.findClass(Cmevent.class));
        classes.addAll(this.findClass(Mol.class));
        classes.addAll(this.findClass(Role.class));
        classes.addAll(this.findClass(Rolerelation.class));
        classes.addAll(this.findClass(Roleuser.class));
        classes.addAll(this.findClass(Catalog.class));
        classes.addAll(this.findClass(Catalogattribute.class));
        classes.addAll(this.findClass(Catalogrestrict.class));
        classes.addAll(this.findClass(Button.class));
        classes.addAll(this.findClass(Dept.class));
        classes.addAll(this.findClass(Country.class));
        classes.addAll(this.findClass(Medicine.class));
        classes.addAll(this.findClass(Note.class));
        classes.addAll(this.findClass(RemainDarftBeer.class));
        classes.addAll(this.findClass(Vat.class));
        classes.addAll(this.findClass(Units.class));
        classes.addAll(this.findClass(Valut.class));
        classes.addAll(this.findClass(Campaign.class));
        classes.addAll(this.findClass(Kit.class));
        classes.addAll(this.findClass(Kitgoods.class));
        classes.addAll(this.findClass(Kitdisc.class));
        classes.addAll(this.findClass(Timeperiod.class));
        classes.addAll(this.findClass(Disccard.class));
        classes.addAll(this.findClass(AccumulateSprices.class));
        classes.addAll(this.findClass(DisccardAccumulate.class));
        classes.addAll(this.findClass(DisccardAccumulatePK.class));
        classes.addAll(this.findClass(Sprices.class));
        classes.addAll(this.findClass(DiscountAuto.class));
        classes.addAll(this.findClass(DiscountAutoPK.class));
        classes.addAll(this.findClass(DiscountFixed.class));
        classes.addAll(this.findClass(Cardgroup.class));
        classes.addAll(this.findClass(HierarchicalMenuItem.class));
        classes.addAll(this.findClass(Connect.class));
        classes.addAll(this.findClass(HotKey.class));
        classes.addAll(this.findClass(HotKeyInvent.class));
        classes.addAll(this.findClass(Card.class));
        classes.addAll(this.findClass(Consultant.class));
        classes.addAll(this.findClass(Actionpanel.class));
        classes.addAll(this.findClass(Actionpanelitem.class));
        classes.addAll(this.findClass(RemainBarcode.class));
        classes.addAll(this.findClass(Abnormalquantity.class));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
        return jaxbContext;
    }

    private List<Class<?>> findClass(Class<?> cl) {
        Class<?> result = JaxbUtil.getResolver().getActual(cl);
        ImmutableList list = ImmutableList.of(result, this.getMaxServer(cl), this.getMaxCash(cl));
        return list;
    }

    private Class<?> getMaxServer(Class<?> cl) {
        return SessionFactoryBuilder.findClass(cl, 150, true);
    }

    private Class<?> getMaxCash(Class<?> cl) {
        return SessionFactoryBuilder.findClass(cl, 150, false);
    }

    protected static ActualClassResolver getResolver() {
        if (LibActivator.getDefault() == null) {
            return resolver;
        }
        return LibActivator.getDefault().getActualClassResolver();
    }

    public DomainCollections importFromXml(String xmlFileName) {
        try {
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(xmlFileName), "UTF-8");
            JAXBContext jaxbContext = this.createContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            DomainCollections domainCollections = (DomainCollections)unmarshaller.unmarshal((Reader)fileReader);
            fileReader.close();
            return domainCollections;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static void setResolver(ActualClassResolver resolver) {
        JaxbUtil.resolver = resolver;
    }
}

