/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.payment.Agent;

@Entity
@Table(name="category")
@MappedSuperclass
public class Category
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer categoryid;
    @NotNull
    @Column(name="agentcode")
    private String agentcode;
    @ManyToOne
    @JoinColumn(name="agentcode", referencedColumnName="code", insertable=false, updatable=false)
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    private Agent agent;
    @ManyToOne
    @JoinColumn(name="categorycode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Invent.class)
    @NotNull
    private Invent invent;
    @NotNull
    @Length(max=100, min=1)
    private String categorycode;

    protected Category() {
    }

    public Integer getCategoryid() {
        return this.categoryid;
    }

    public void setCategoryid(Integer categoryid) {
        this.categoryid = categoryid;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
        this.agentcode = agent != null ? agent.getCode() : null;
    }

    public void setInvent(Invent invent) {
        this.invent = invent;
        this.categorycode = invent != null ? invent.getCode() : null;
    }

    public Invent getInvent() {
        return this.invent;
    }

    public String getCategorycode() {
        return this.categorycode;
    }

    public void setCategorycode(String categorycode) {
        this.categorycode = categorycode;
    }

    public String getAgentcode() {
        return this.agentcode;
    }

    public void setAgentcode(String agentcode) {
        this.agentcode = agentcode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.agentcode == null ? 0 : this.agentcode.hashCode());
        result = 31 * result + (this.categorycode == null ? 0 : this.categorycode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (this.agentcode == null ? other.agentcode != null : !this.agentcode.equals(other.agentcode)) {
            return false;
        }
        return !(this.categorycode == null ? other.categorycode != null : !this.categorycode.equals(other.categorycode));
    }

    public String toString() {
        return "Category [categoryid=" + this.categoryid + ", agentcode=" + this.agentcode + ", categorycode=" + this.categorycode + "]";
    }
}

