/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Country;

@XmlAccessorType(value=XmlAccessType.FIELD)
@Entity
@Table(name="medicine")
@MappedSuperclass
public class Medicine
implements Serializable {
    @XmlElement
    @NotNull
    @Id
    private Integer code;
    @NotNull
    @XmlElement
    @Size(max=255)
    private String barcode;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="barcode", referencedColumnName="barcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Barcodes.class)
    @NotNull
    private Barcodes barcodes;
    @XmlElement
    @Size(max=255)
    private String party;
    @XmlElement
    @Size(max=255)
    private String series;
    @XmlElement
    private Date shelflife;
    @XmlElement
    @Size(max=255)
    private String producer;
    @NotNull
    @XmlElement
    private BigDecimal price;
    @Column(name="packingprice")
    @XmlElement
    private BigDecimal packingPrice = null;
    @XmlElement
    private String inn = null;
    @Column(name="remainquant")
    @XmlElement
    private Integer remainQuant = null;
    @Column(name="remaindatetime")
    @XmlElement
    private Date remainDatetime = null;
    @XmlElement
    @Column(name="countrycode", insertable=false, updatable=false)
    private Integer countryCode = null;
    @ManyToOne
    @JoinColumn(name="countrycode")
    @NotFound(action=NotFoundAction.IGNORE)
    private Country country;
    @XmlElement
    private Integer options = null;
    private static final long serialVersionUID = 1L;

    protected Medicine() {
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Medicine other = (Medicine)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Barcodes getBarcodes() {
        return this.barcodes;
    }

    public void setBarcodes(Barcodes barcodes) {
        this.barcodes = barcodes;
        this.barcode = barcodes != null ? barcodes.getBarcode() : null;
    }

    public String getParty() {
        return this.party;
    }

    public void setParty(String party) {
        this.party = party;
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public Date getShelflife() {
        return this.shelflife;
    }

    public void setShelflife(Date shelflife) {
        this.shelflife = shelflife;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPackingPrice() {
        return this.packingPrice;
    }

    public void setPackingPrice(BigDecimal packingPrice) {
        this.packingPrice = packingPrice;
    }

    public String getInn() {
        return this.inn;
    }

    public void setInn(String inn) {
        this.inn = inn;
    }

    public Integer getRemainQuant() {
        return this.remainQuant;
    }

    public void setRemainQuant(Integer remainQuant) {
        this.remainQuant = remainQuant;
    }

    public Date getRemainDatetime() {
        return this.remainDatetime;
    }

    public void setRemainDatetime(Date remainDatetime) {
        this.remainDatetime = remainDatetime;
    }

    public Integer getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(Integer countryCode) {
        this.countryCode = countryCode;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
        this.countryCode = country != null ? country.getCode() : null;
    }

    public Integer getOptions() {
        return this.options;
    }

    public void setOptions(Integer options) {
        this.options = options;
    }
}

