/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import ru.ssa.cashadmin.ActualClassResolver;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.AbstractSpringDao;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.dao.InventInfoDao;
import ru.ssa.cashadmin.domain.InventInfo;

public class DaoFactory {
    private static Map<Class<?>, DaoInterface<?>> map = new HashMap();
    private static SessionFactory sessionFactoryExternal;
    private static SessionFactory sessionFactoryDocuments;
    private static SessionFactory sessionFactoryDBAll;
    private static SessionFactory sessionFactoryCategory;
    private static Map<Class<?>, Boolean> actualExternal;
    private static Map<Class<?>, Boolean> actualDocuments;
    private static Map<Class<?>, Boolean> actualDBAll;
    private static Map<Class<?>, Boolean> actualCategory;
    private static ActualClassResolver resolver;
    private static final Logger log;
    private static final Map<String, Boolean> zeroCollections;

    static {
        log = LoggerFactory.getLogger(DaoFactory.class);
        zeroCollections = new ConcurrentHashMap<String, Boolean>();
    }

    public static <T> DaoInterface<T> getDAO(Class<T> cl) {
        Class<T> actualClazz = DaoFactory.getResolver().getActual(cl);
        if (actualClazz == null) {
            actualClazz = cl;
        }
        HibernateDaoSupport dao = null;
        dao = map.get(actualClazz);
        if (dao == null) {
            dao = InventInfo.class.isAssignableFrom(actualClazz) ? new InventInfoDao() : new AbstractSpringDao<T>(actualClazz);
            ((HibernateDaoSupport)dao).setSessionFactory(DaoFactory.findAppropriateSessionFactory(actualClazz));
            map.put(actualClazz, (DaoInterface<?>)dao);
        }
        return dao;
    }

    public static SessionFactory findAppropriateSessionFactory(Class<?> cl) {
        log.trace("find appropriate session factory for class:{}", cl);
        Class<?> base = DaoFactory.getResolver().getBase(cl);
        if (sessionFactoryCategory != null && actualCategory.containsKey(base) && actualCategory.get(base).booleanValue()) {
            log.trace("category session factory");
            return sessionFactoryCategory;
        }
        if (sessionFactoryDBAll != null && actualDBAll.containsKey(base) && actualDBAll.get(base).booleanValue()) {
            log.trace("all session factory");
            return sessionFactoryDBAll;
        }
        if (actualExternal != null && actualExternal.containsKey(base) && actualExternal.get(base).booleanValue()) {
            log.trace("external session factory");
            return sessionFactoryExternal;
        }
        if (actualDocuments != null && actualDocuments.containsKey(base) && actualDocuments.get(base).booleanValue()) {
            log.trace("documents session factory");
            return sessionFactoryDocuments;
        }
        return null;
    }

    protected static ActualClassResolver getResolver() {
        if (LibActivator.getDefault() == null) {
            return resolver;
        }
        return LibActivator.getDefault().getActualClassResolver();
    }

    public static void clearModels() {
        map.clear();
        zeroCollections.clear();
    }

    public static void setSessionFactoryExternal(SessionFactory sessionFactoryExternal, Map<Class<?>, Boolean> actualClasses) {
        DaoFactory.sessionFactoryExternal = sessionFactoryExternal;
        actualExternal = actualClasses;
    }

    public static void setSessionFactoryDocuments(SessionFactory sessionFactoryDocuments, Map<Class<?>, Boolean> actualClasses) {
        DaoFactory.sessionFactoryDocuments = sessionFactoryDocuments;
        actualDocuments = actualClasses;
    }

    public static void setSessionFactoryDBAll(SessionFactory sessionFactoryDBAll, Map<Class<?>, Boolean> actualClasses) {
        DaoFactory.sessionFactoryDBAll = sessionFactoryDBAll;
        actualDBAll = actualClasses;
    }

    public static void setSessionFactoryCategory(SessionFactory sessionFactoryCategory, Map<Class<?>, Boolean> actualClasses) {
        DaoFactory.sessionFactoryCategory = sessionFactoryCategory;
        actualCategory = actualClasses;
    }

    public static void setResolver(ActualClassResolver resolver) {
        DaoFactory.resolver = resolver;
    }

    public static Map<String, Boolean> getZeroCollections() {
        return zeroCollections;
    }
}

