/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQueryCreator;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.order.PropertyAuditOrder;
import org.hibernate.envers.query.property.EntityPropertyName;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Transactional;
import ru.ssa.cashadmin.dao.AbstractCriteriaWorker;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.utils.ArtixFilter;

public class AbstractSpringDao<E>
extends HibernateDaoSupport
implements DaoInterface<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractSpringDao.class);
    private Class<E> e;
    private final AbstractCriteriaWorker<E> criteriaWorker;
    private List<?> existsIds;

    public AbstractSpringDao(Class<E> cl) {
        this.setE(cl);
        this.criteriaWorker = new AbstractCriteriaWorker<E>(cl);
    }

    @Override
    @Transactional
    public void clear() throws ExecuteQueryException {
        log.trace("clear entity:{}", this.e);
        try {
            this.getHibernateTemplate().bulkUpdate("delete from " + this.e.getName());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void clearCascade() throws ExecuteQueryException {
        log.trace("clear cascade entity:{}", this.e);
        try {
            List list = this.getHibernateTemplate().find("from " + this.e.getName());
            this.getHibernateTemplate().deleteAll((Collection)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public Long count() throws ExecuteQueryException {
        return this.count((E)null);
    }

    @Override
    public Long count(E state) throws ExecuteQueryException {
        log.trace("begin count entity:{},state:{}", this.e, state);
        DetachedCriteria criteria = DetachedCriteria.forClass(this.e);
        criteria.setProjection(Projections.rowCount());
        if (state != null) {
            log.trace("state={}", state);
            if (!state.getClass().equals(this.e)) {
                log.error("Different class. State class:{}, Dao class:{}.", state.getClass(), this.e);
            }
            this.createFilterCriteria(state, criteria);
        }
        try {
            List list = this.getHibernateTemplate().findByCriteria(criteria);
            if (list.isEmpty()) {
                Long l = 0L;
                return l;
            }
            Long l = ((Integer)list.get(0)).longValue();
            return l;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        finally {
            log.trace("end count");
        }
    }

    @Override
    @Transactional
    public void delete(E o) throws ExecuteQueryException {
        log.trace("delete entity:{},object:{}", this.e, o);
        try {
            this.getHibernateTemplate().delete(o);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void deleteAll(Collection<E> o) throws ExecuteQueryException {
        log.trace("delete all entity:{}", this.e);
        try {
            this.getHibernateTemplate().deleteAll(o);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void deleteById(Object id) throws ExecuteQueryException {
        try {
            this.delete(this.getHibernateTemplate().get(this.e, (Serializable)id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public E getById(Object id) throws ExecuteQueryException {
        if (id == null) {
            return null;
        }
        try {
            return (E)this.getHibernateTemplate().get(this.e, (Serializable)id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public List<E> getList(String sortby, boolean sortAsc, E state, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        DetachedCriteria criteria = this.getListCriteria(sortby, sortAsc, state, firstResult, maxResults);
        try {
            return this.getHibernateTemplate().findByCriteria(criteria);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    protected DetachedCriteria getListCriteria(String sortby, boolean sortAsc, E state, Integer firstResult, Integer maxResults) {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.e);
        if (state != null) {
            this.createFilterCriteria(state, criteria);
        }
        this.updateOrder(sortby, sortAsc, criteria);
        if (firstResult != null) {
            criteria.getExecutableCriteria(this.getSession()).setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            criteria.getExecutableCriteria(this.getSession()).setMaxResults(maxResults.intValue());
        }
        this.setResultTransformer(criteria);
        return criteria;
    }

    @Override
    public List<E> findByNamedQuery(String queryName, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        try (Session session = this.getSessionFactory().openSession();){
            Transaction transaction = session.beginTransaction();
            Query query = session.getNamedQuery(queryName);
            if (firstResult != null) {
                query.setFirstResult(firstResult.intValue());
            }
            if (maxResults != null) {
                query.setMaxResults(maxResults.intValue());
            }
            List result = query.list();
            transaction.commit();
            List list = result;
            return list;
        }
    }

    @Override
    public List<Object> findIds() throws ExecuteQueryException {
        try (Session session = this.getSessionFactory().openSession();){
            Transaction transaction = session.beginTransaction();
            Query query = session.createQuery("select " + DomainUtils.getIdColum(this.e) + " from " + this.e.getSimpleName());
            List result = query.list();
            transaction.commit();
            List list = result;
            return list;
        }
    }

    protected void setResultTransformer(DetachedCriteria criteria) {
    }

    private void updateOrder(String sortby, boolean sortAsc, DetachedCriteria criteria) {
        this.criteriaWorker.updateOrder(sortby, sortAsc, criteria, this.getSession());
    }

    @Override
    public List<E> getList(String sortby, boolean sortAsc) throws ExecuteQueryException {
        return this.getList(sortby, sortAsc, null);
    }

    @Override
    public List<E> getList(E state) throws ExecuteQueryException {
        return this.getList(null, false, state);
    }

    @Override
    public List<E> getList() throws ExecuteQueryException {
        return this.getList(null, false, null);
    }

    @Override
    @Transactional
    public E update(E o) throws ExecuteQueryException {
        log.trace("begin update:{}", o);
        try {
            this.getHibernateTemplate().clear();
            this.getHibernateTemplate().saveOrUpdate(o);
            E e = o;
            return e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        finally {
            log.trace("end update");
        }
    }

    private void setE(Class<E> e) {
        this.e = e;
    }

    protected Class<E> getE() {
        return this.e;
    }

    protected void createFilterCriteria(E state, DetachedCriteria criteria) {
        try {
            this.createEntityExampleCriteria(state, criteria);
            this.addPrimaryKeyCriteria(state, criteria);
            this.addAssociatedCriteria(state, criteria);
            this.addCollectionCriteria(state, criteria);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void createEntityExampleCriteria(E state, DetachedCriteria criteria) {
        this.criteriaWorker.createEntityExampleCriteria(state, criteria);
    }

    protected void addPrimaryKeyCriteria(Object state, DetachedCriteria criteria) {
        this.criteriaWorker.addPrimaryKeyCriteria(state, criteria);
    }

    protected void addAssociatedCriteria(Object state, DetachedCriteria criteria) {
        this.criteriaWorker.addAssociatedCriteria(state, criteria);
    }

    protected void createAssociatedExampleCriteria(Object fieldValue, DetachedCriteria fieldCriteria) {
        this.criteriaWorker.createAssociatedExampleCriteria(fieldValue, fieldCriteria);
    }

    private void addCollectionCriteria(E state, DetachedCriteria criteria) {
        this.criteriaWorker.addCollectionCriteria(state, criteria);
    }

    @Override
    public List<?> findByHSQL(String hsql, Object[] param) throws ExecuteQueryException {
        try {
            String query = StringUtils.replace((String)hsql, (String)"{entity}", (String)this.e.getSimpleName());
            return this.getHibernateTemplate().find(query, param);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void changeId(Object oldId, Object newId, String ... idFields) throws ExecuteQueryException {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            log.trace("id field={}", (Object[])idFields);
            String queryStr = "update " + this.e.getName() + " set " + this.createPkSet(idFields, newId) + " where 1=1 " + this.createPkWhere(oldId, values, newId, idFields, false);
            this.getHibernateTemplate().bulkUpdate(queryStr, values.toArray(new Object[values.size()]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void changeIdNoExtractPK(Object oldId, Object newId, String ... idFields) throws ExecuteQueryException {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            log.trace("id field={}", (Object[])idFields);
            String queryStr = "update " + this.e.getName() + " set " + this.createPkSet(idFields, newId) + " where 1=1 " + this.createPkWhereSkipId(values, oldId, newId, idFields[0]);
            this.getHibernateTemplate().bulkUpdate(queryStr, values.toArray(new Object[values.size()]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    public String createPkSet(String[] fields, Object newId) {
        StringBuilder str = new StringBuilder();
        if (DomainUtils.isComposite(this.e, DomainUtils.getIdColum(this.e))) {
            Field[] real_fields = newId.getClass().getDeclaredFields();
            boolean firstField = true;
            Field[] fieldArray = real_fields;
            int n = real_fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers())) {
                    if (!firstField) {
                        str.append(", ");
                    }
                    firstField = false;
                    str.append(String.valueOf(field.getName()) + "=? ");
                }
                ++n2;
            }
        } else {
            String[] stringArray = fields;
            int n = fields.length;
            int n3 = 0;
            while (n3 < n) {
                String field = stringArray[n3];
                str.append(" " + field + "=?,");
                ++n3;
            }
        }
        String result = str.toString().substring(0, str.length() - 1);
        log.trace("pk set={}", (Object)result);
        return result;
    }

    private String createPkWhere(Object obj, List<Object> values, Object newId, String[] properties, boolean skipComposite) {
        return this.createPkWhere(obj, DomainUtils.getIdColum(this.e), values, newId, properties, skipComposite);
    }

    private String createPkWhereSkipId(List<Object> values, Object oldId, Object newId, String idField) {
        String str = "";
        str = String.valueOf(str) + " and " + idField + "=? ";
        values.add(newId);
        values.add(oldId);
        log.trace("pk where={}", (Object)str);
        return str;
    }

    private String createPkWhere(Object oldId, String idField, List<Object> values, Object newId, String[] properties, boolean skipComposite) {
        String str = "";
        log.trace("old id={}", oldId);
        if (!skipComposite && DomainUtils.isComposite(this.e, idField)) {
            Field[] fields;
            this.addSetValues(values, newId, properties);
            Field[] fieldArray = fields = oldId.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers())) {
                    str = String.valueOf(str) + " and " + field.getName() + "=? ";
                    values.add(DomainUtils.getFieldValue(field.getName(), oldId));
                }
                ++n2;
            }
        } else {
            str = String.valueOf(str) + " and " + idField + "=? ";
            values.add(newId);
            values.add(oldId);
        }
        log.trace("pk where={}", (Object)str);
        return str;
    }

    private void addSetValues(List<Object> values, Object newId, String[] properties) {
        log.trace("properties={}", (Object[])properties);
        if (DomainUtils.isComposite(this.e, DomainUtils.getIdColum(this.e))) {
            Field[] real_fields;
            Field[] fieldArray = real_fields = newId.getClass().getDeclaredFields();
            int n = real_fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers())) {
                    Object newO = DomainUtils.getFieldValue(field.getName(), newId);
                    log.trace("new property={}", newO);
                    values.add(newO);
                }
                ++n2;
            }
        } else {
            String[] stringArray = properties;
            int n = properties.length;
            int n3 = 0;
            while (n3 < n) {
                String property = stringArray[n3];
                Object newO = DomainUtils.getFieldValue(property, newId);
                log.trace("new property={}", newO);
                values.add(newO);
                ++n3;
            }
        }
    }

    @Override
    public Object getMaxId() throws ExecuteQueryException {
        return this.getMax(DomainUtils.getIdColum(this.getE()), null);
    }

    @Override
    public Object getMax(String column, E state) throws ExecuteQueryException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.e);
        criteria.setProjection((Projection)Projections.max((String)column));
        if (state != null) {
            log.trace("state={}", state);
            this.createFilterCriteria(state, criteria);
        }
        try {
            Object max = this.getHibernateTemplate().findByCriteria(criteria).get(0);
            log.trace("max={}", max);
            return max;
        }
        catch (IndexOutOfBoundsException e) {
            log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public E refresh(E o) throws ExecuteQueryException {
        try {
            this.getHibernateTemplate().refresh(o);
            return o;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public List<?> getProjectionList(String projectionProperty) throws ExecuteQueryException {
        return this.getProjectionList(projectionProperty, null);
    }

    @Override
    public List<?> getProjectionList(String projectionProperty, E state) throws ExecuteQueryException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.e);
        criteria.setProjection((Projection)Projections.property((String)projectionProperty));
        if (state != null) {
            log.trace("state={}", state);
            this.createFilterCriteria(state, criteria);
        }
        try {
            return this.getHibernateTemplate().findByCriteria(criteria);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public List<?> findByNamedParam(String queryString, String[] paramNames, Object[] values) throws ExecuteQueryException {
        try {
            return this.getHibernateTemplate().findByNamedParam(queryString, paramNames, values);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public List<?> findByNamedParam(String queryString, Map<String, Object> params) throws ExecuteQueryException {
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            paramNames.add(entry.getKey());
            values.add(entry.getValue());
        }
        return this.findByNamedParam(queryString, paramNames.toArray(new String[paramNames.size()]), values.toArray());
    }

    @Override
    public List<E> getList(String sortby, boolean sortAsc, E state) throws ExecuteQueryException {
        return this.getList(sortby, sortAsc, state, null, null);
    }

    @Override
    public List<E> getList(ArtixFilter<E> filter, String sortby, boolean sortAsc, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        DetachedCriteria criteria = filter.getDetachedCriteria();
        this.updateOrder(sortby, sortAsc, criteria);
        if (firstResult != null) {
            criteria.getExecutableCriteria(this.getSession()).setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            criteria.getExecutableCriteria(this.getSession()).setMaxResults(maxResults.intValue());
        }
        try {
            return this.getHibernateTemplate().findByCriteria(criteria);
        }
        catch (DataAccessException e) {
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public List<E> getList(ArtixFilter<E> filter) throws ExecuteQueryException {
        return this.getList(filter, null, false, null, null);
    }

    @Override
    public Long count(ArtixFilter<E> filter) throws ExecuteQueryException {
        log.trace("count entity:{},filter:{}", this.e, filter);
        DetachedCriteria criteria = filter.getDetachedCriteria();
        criteria.setProjection(Projections.rowCount());
        try {
            List list = this.getHibernateTemplate().findByCriteria(criteria);
            if (!list.isEmpty()) {
                return ((Integer)list.get(0)).longValue();
            }
            return 0L;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public void updateActionsMap(Map<E, String> map) {
        try {
            for (Map.Entry<E, String> entry : map.entrySet()) {
                if (!entry.getValue().equals("REMOVE")) continue;
                this.delete(entry.getKey());
            }
            for (Map.Entry<E, String> entry : map.entrySet()) {
                if (entry.getValue().equals("ADD")) {
                    this.save(entry.getKey());
                    continue;
                }
                if (!entry.getValue().equals("UPDATE")) continue;
                this.update(entry.getKey());
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateCollection(Collection<E> collection) {
        try {
            for (E object : collection) {
                this.update(object);
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public E save(E o) throws ExecuteQueryException {
        try {
            this.getHibernateTemplate().save(o);
            return o;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExecuteQueryException(e.getMessage(), e);
        }
    }

    @Override
    public void saveCollection(Collection<E> collection) {
        try {
            for (E object : collection) {
                Object id = DomainUtils.getIdValue(object);
                log.trace("find id={}", id);
                if (this.getById(id) != null) {
                    log.trace("object found, update it");
                    this.update(object);
                    continue;
                }
                this.save(object);
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<?> getAuditList(Object filter, int first, int maxItemCount, String sortByField, boolean ascending) {
        List auditResult = Collections.emptyList();
        if (filter == null) {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            AuditQueryCreator queryCreator = AuditReaderFactory.get((org.hibernate.Session)session).createQuery();
            auditResult = queryCreator.forRevisionsOfEntity(this.getE(), false, false).setFirstResult(first).setMaxResults(maxItemCount).addOrder((AuditOrder)new PropertyAuditOrder((PropertyNameGetter)new EntityPropertyName(sortByField), ascending)).getResultList();
            session.close();
        }
        return auditResult;
    }

    @Override
    public Object getAuditRevisionEntry(int revision) {
        Session session = this.getHibernateTemplate().getSessionFactory().openSession();
        AuditQueryCreator queryCreator = AuditReaderFactory.get((org.hibernate.Session)session).createQuery();
        List result = queryCreator.forRevisionsOfEntity(this.getE(), false, false).add(AuditEntity.revisionNumber().eq((Object)revision)).getResultList();
        session.close();
        if (result != null && result.size() == 1) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public void putExistsIds(List<?> ids) {
        this.existsIds = ids;
    }

    @Override
    public void clearExistsIds() {
        if (this.existsIds != null) {
            this.existsIds.clear();
        }
    }
}

