/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.event.AuditEventListener;
import org.hibernate.envers.synchronization.AuditSync;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.tools.Tools;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public class EnversAuditEventListener
extends AuditEventListener {
    private static final long serialVersionUID = -2499904286323112715L;

    private void generateBidirectionalCollectionChangeWorkUnits(AuditSync verSync, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.getVerCfg().getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        int i = 0;
        while (i < propertyNames.length) {
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.getVerCfg().getEntCfg().getRelationDescription(entityName, propertyName);
            if (relDesc != null && relDesc.isBidirectional() && relDesc.getRelationType() == RelationType.TO_ONE && relDesc.isInsertable()) {
                Object newValue;
                Object oldValue = oldState == null ? null : oldState[i];
                Object object = newValue = newState == null ? null : newState[i];
                if (!Tools.entitiesEqual((SessionImplementor)session, (Object)oldValue, (Object)newValue)) {
                    IdMapper idMapper;
                    Serializable id;
                    String toEntityName;
                    HibernateProxy hibernateProxy;
                    if (newValue != null) {
                        if (newValue instanceof HibernateProxy) {
                            hibernateProxy = (HibernateProxy)newValue;
                            toEntityName = session.bestGuessEntityName(newValue);
                            id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                            newValue = Tools.getTargetFromProxy((SessionFactoryImplementor)session.getFactory(), (HibernateProxy)hibernateProxy);
                        } else {
                            toEntityName = session.guessEntityName(newValue);
                            idMapper = this.getVerCfg().getEntCfg().get(toEntityName).getIdMapper();
                            id = (Serializable)idMapper.mapToIdFromEntity(newValue);
                        }
                        verSync.addWorkUnit((AuditWorkUnit)new CollectionChangeWorkUnit(session, toEntityName, this.getVerCfg(), id, newValue));
                    }
                    if (oldValue != null) {
                        if (oldValue instanceof HibernateProxy) {
                            hibernateProxy = (HibernateProxy)oldValue;
                            toEntityName = session.bestGuessEntityName(oldValue);
                            id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                            oldValue = Tools.getTargetFromProxy((SessionFactoryImplementor)session.getFactory(), (HibernateProxy)hibernateProxy);
                        } else {
                            toEntityName = session.guessEntityName(oldValue);
                            idMapper = this.getVerCfg().getEntCfg().get(toEntityName).getIdMapper();
                            id = (Serializable)idMapper.mapToIdFromEntity(oldValue);
                        }
                        verSync.addWorkUnit((AuditWorkUnit)new CollectionChangeWorkUnit(session, toEntityName, this.getVerCfg(), id, oldValue));
                    }
                }
            }
            ++i;
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getVerCfg().getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.getVerCfg().getSyncManager().get(event.getSession());
            AddWorkUnit workUnit = new AddWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getVerCfg(), event.getId(), event.getPersister(), event.getState());
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), null, (SessionImplementor)event.getSession());
            }
            workUnit.perform((Session)event.getSession(), verSync.getCurrentRevisionData((Session)event.getSession(), true));
            event.getSession().getActionQueue().executeInserts();
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getVerCfg().getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.getVerCfg().getSyncManager().get(event.getSession());
            ModWorkUnit workUnit = new ModWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getVerCfg(), event.getId(), event.getPersister(), event.getState(), event.getOldState());
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), event.getOldState(), (SessionImplementor)event.getSession());
            }
            workUnit.perform((Session)event.getSession(), verSync.getCurrentRevisionData((Session)event.getSession(), true));
            event.getSession().getActionQueue().executeInserts();
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getVerCfg().getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.getVerCfg().getSyncManager().get(event.getSession());
            DelWorkUnit workUnit = new DelWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getVerCfg(), event.getId(), event.getPersister(), event.getDeletedState());
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, null, event.getDeletedState(), (SessionImplementor)event.getSession());
            }
            workUnit.perform((Session)event.getSession(), verSync.getCurrentRevisionData((Session)event.getSession(), true));
            event.getSession().getActionQueue().executeInserts();
        }
    }
}

