/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets.macroparameter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.widgets.macroparameter.Format;
import su.artix.widgets.macroparameter.TextWithMacroparameter;
import su.artix.yuki.discount.macroparameter.domain.xml.Macroparameter;

public class TextFontWithMacroparameter
extends TextWithMacroparameter {
    private static final Logger log;
    private static final String FONT_NORMAL = "su.artix.widgets.macroparameter.font_normal";
    private static final String FONT_ENLARGE = "su.artix.widgets.macroparameter.font_enlarge";
    private static final String FONT_COMPRESSED = "su.artix.widgets.macroparameter.font_compressed";
    private static final String FONT_SMALLER = "su.artix.widgets.macroparameter.font_smaller";
    private static final String FONT_DOUBLEWIDTH = "su.artix.widgets.macroparameter.font_doublewidth";
    private static final String FONT_DOUBLEHEIGHT = "su.artix.widgets.macroparameter.font_doubleheight";
    private Map<Format, Font> fonts;
    private Format[] formats;
    private List<ToolItem> toolItems;

    static {
        ImageDescriptor doubleheight;
        ImageDescriptor smaller;
        ImageDescriptor doublewidth;
        ImageDescriptor compressed;
        ImageDescriptor enlarge;
        log = LoggerFactory.getLogger(TextFontWithMacroparameter.class);
        ImageDescriptor normal = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font.png");
        if (normal != null) {
            JFaceResources.getImageRegistry().put(FONT_NORMAL, normal);
        }
        if ((enlarge = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font_big.png")) != null) {
            JFaceResources.getImageRegistry().put(FONT_ENLARGE, enlarge);
        }
        if ((compressed = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font_small_1.png")) != null) {
            JFaceResources.getImageRegistry().put(FONT_COMPRESSED, compressed);
        }
        if ((doublewidth = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font_width.png")) != null) {
            JFaceResources.getImageRegistry().put(FONT_DOUBLEWIDTH, doublewidth);
        }
        if ((smaller = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font_small_2.png")) != null) {
            JFaceResources.getImageRegistry().put(FONT_SMALLER, smaller);
        }
        if ((doubleheight = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/fonts/16x16/plane/font_height.png")) != null) {
            JFaceResources.getImageRegistry().put(FONT_DOUBLEHEIGHT, doubleheight);
        }
    }

    public TextFontWithMacroparameter(Composite parent, int style, List<Macroparameter> macroparameters) {
        super(parent, style, macroparameters);
        this.initDefaultFormats();
    }

    private void createFonts() {
        this.fonts = new HashMap<Format, Font>();
        this.fonts.put(Format.NORMAL, new Font((Device)Display.getCurrent(), "Verdana", 10, 0));
        this.fonts.put(Format.ENLARGE, new Font((Device)Display.getCurrent(), "Verdana", 18, 1));
        this.fonts.put(Format.COMPRESSED, new Font((Device)Display.getCurrent(), "Arial", 8, 0));
        this.fonts.put(Format.SMALLER, new Font((Device)Display.getCurrent(), "Verdana", 6, 0));
        this.fonts.put(Format.DOUBLEWIDTH, new Font((Device)Display.getCurrent(), "Courier New", 14, 1));
        this.fonts.put(Format.DOUBLEHEIGHT, new Font((Device)Display.getCurrent(), "Bedrock", 11, 2));
    }

    private void initDefaultFormats() {
        this.formats = new Format[]{Format.NORMAL};
    }

    private void deleteFonts() {
        for (Font font : this.fonts.values()) {
            font.dispose();
        }
        this.fonts.clear();
    }

    private int getSelectionLine() {
        return this.textControl.getLineAtOffset(this.textControl.getCaretOffset());
    }

    private void changeFormat(Format format) {
        this.formats[this.getSelectionLine()] = format;
        this.updateStyles();
        this.refreshFontButtons();
        this.setChanged();
    }

    private void refreshFontButtons() {
        for (ToolItem toolItem : this.toolItems) {
            toolItem.setSelection(false);
        }
        if (this.formats.length == this.textControl.getLineCount()) {
            this.toolItems.get(this.formats[this.getSelectionLine()].toInt() - 1).setSelection(true);
        }
    }

    private void updateStyles() {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int i = 0;
        int offset = 0;
        while (i < this.textControl.getLineCount()) {
            int length = this.textControl.getLine(i).length();
            StyleRange style = new StyleRange();
            style.font = this.fonts.get((Object)this.formats[i]);
            style.start = offset;
            style.length = length;
            styles.add(style);
            offset += length + 2;
            ++i;
        }
        i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && !this.controls[i].isDisposed()) {
                for (StyleRange style : styles) {
                    if (this.offsets[i] < style.start || this.offsets[i] > style.start + style.length - 1) continue;
                    if (this.offsets[i] != style.start) {
                        StyleRange styleA = new StyleRange();
                        styleA.font = style.font;
                        styleA.start = style.start;
                        styleA.length = this.offsets[i] - styleA.start;
                        styles.add(styleA);
                    }
                    if (this.offsets[i] != style.start + style.length - 1) {
                        StyleRange styleB = new StyleRange();
                        styleB.font = style.font;
                        styleB.start = this.offsets[i] + 1;
                        styleB.length = style.start + style.length - styleB.start;
                        styles.add(styleB);
                    }
                    styles.remove(style);
                    break;
                }
            }
            ++i;
        }
        for (StyleRange style : styles) {
            this.textControl.replaceStyleRanges(style.start, style.length, new StyleRange[]{style});
        }
    }

    @Override
    protected void createContents() {
        super.createContents();
        this.createFonts();
        this.textControl.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                TextFontWithMacroparameter.this.refreshFontButtons();
            }
        });
    }

    @Override
    protected String textToInternalText(String text) {
        StringBuilder str = new StringBuilder();
        if (!text.isEmpty()) {
            String[] lines = text.split(Pattern.quote("\\"));
            this.formats = new Format[lines.length];
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].isEmpty()) {
                    if (lines[i].charAt(0) == '&') {
                        str.append(' ');
                        str.append(lines[i].substring(1));
                        this.formats[i] = Format.NORMAL;
                    } else if (lines[i].matches("^[1-6];.*")) {
                        str.append(lines[i].substring(2));
                        this.formats[i] = Format.valueOf(Integer.valueOf(lines[i].substring(0, lines[i].indexOf(59))));
                    } else {
                        str.append(lines[i].trim());
                        this.formats[i] = Format.NORMAL;
                    }
                } else {
                    this.formats[i] = Format.NORMAL;
                }
                if (i != lines.length - 1) {
                    str.append("\r\n");
                }
                ++i;
            }
        } else {
            this.initDefaultFormats();
        }
        return str.toString();
    }

    @Override
    protected String textToExternalText(String text) {
        StringBuilder str = new StringBuilder();
        if (!text.isEmpty()) {
            String[] lines = text.replace("\t", "    ").split(Pattern.quote("\r\n"));
            int i = 0;
            while (i < lines.length) {
                if (this.formats[i] == Format.NORMAL) {
                    if (!lines[i].isEmpty()) {
                        if (lines[i].charAt(0) == ' ') {
                            str.append('&');
                            str.append(lines[i].substring(1));
                        } else {
                            str.append(lines[i]);
                        }
                    }
                } else {
                    str.append(this.formats[i].toInt());
                    str.append(';');
                    str.append(lines[i]);
                }
                if (i != lines.length - 1) {
                    str.append("\\");
                }
                ++i;
            }
        }
        log.debug("\"{}\"", (Object)str.toString());
        return str.toString();
    }

    @Override
    protected List<ToolItem> createOtherToolItems(ToolBar toolBar) {
        this.toolItems = new ArrayList<ToolItem>();
        new ToolItem(toolBar, 2);
        ToolItem font1Item = new ToolItem(toolBar, 32);
        font1Item.setToolTipText("\u041d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439");
        font1Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_NORMAL).createImage());
        font1Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.NORMAL);
            }
        });
        this.toolItems.add(font1Item);
        ToolItem font2Item = new ToolItem(toolBar, 32);
        font2Item.setToolTipText("\u0411\u043e\u043b\u044c\u0448\u043e\u0439");
        font2Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_ENLARGE).createImage());
        font2Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.ENLARGE);
            }
        });
        this.toolItems.add(font2Item);
        ToolItem font3Item = new ToolItem(toolBar, 32);
        font3Item.setToolTipText("\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439");
        font3Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_COMPRESSED).createImage());
        font3Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.COMPRESSED);
            }
        });
        this.toolItems.add(font3Item);
        ToolItem font4Item = new ToolItem(toolBar, 32);
        font4Item.setToolTipText("\u041e\u0447\u0435\u043d\u044c \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439");
        font4Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_SMALLER).createImage());
        font4Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.SMALLER);
            }
        });
        this.toolItems.add(font4Item);
        ToolItem font5Item = new ToolItem(toolBar, 32);
        font5Item.setToolTipText("\u0414\u0432\u043e\u0439\u043d\u0430\u044f \u0448\u0438\u0440\u0438\u043d\u0430");
        font5Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_DOUBLEWIDTH).createImage());
        font5Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.DOUBLEWIDTH);
            }
        });
        this.toolItems.add(font5Item);
        ToolItem font6Item = new ToolItem(toolBar, 32);
        font6Item.setToolTipText("\u0414\u0432\u043e\u0439\u043d\u0430\u044f \u0432\u044b\u0441\u043e\u0442\u0430");
        font6Item.setImage(JFaceResources.getImageRegistry().getDescriptor(FONT_DOUBLEHEIGHT).createImage());
        font6Item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFontWithMacroparameter.this.changeFormat(Format.DOUBLEHEIGHT);
            }
        });
        this.toolItems.add(font6Item);
        return this.toolItems;
    }

    @Override
    protected void textModified() {
        if (this.formats.length > this.textControl.getLineCount()) {
            int deleteCount = this.formats.length - this.textControl.getLineCount();
            int index = this.getSelectionLine();
            Format[] tmpFormats = new Format[this.formats.length - deleteCount];
            System.arraycopy(this.formats, 0, tmpFormats, 0, ++index);
            if (index < this.formats.length) {
                System.arraycopy(this.formats, index + deleteCount, tmpFormats, index, this.formats.length - index - deleteCount);
            }
            this.formats = tmpFormats;
        } else if (this.formats.length < this.textControl.getLineCount()) {
            int addCount = this.textControl.getLineCount() - this.formats.length;
            int index = this.getSelectionLine();
            Format[] tmpFormats = new Format[this.formats.length + addCount];
            if (index < this.formats.length) {
                System.arraycopy(this.formats, 0, tmpFormats, 0, index);
                System.arraycopy(this.formats, index, tmpFormats, index + 1, tmpFormats.length - index - 1);
                int i = 0;
                while (i < addCount) {
                    tmpFormats[index + i] = Format.NORMAL;
                    ++i;
                }
            } else {
                System.arraycopy(this.formats, 0, tmpFormats, 0, this.formats.length);
                int i = this.formats.length - 1;
                while (i < tmpFormats.length) {
                    tmpFormats[i] = Format.NORMAL;
                    ++i;
                }
            }
            this.formats = tmpFormats;
        }
        this.updateStyles();
        this.refreshFontButtons();
    }

    public void dispose() {
        this.deleteFonts();
        super.dispose();
    }
}

