/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.convertor.discountsystem;

import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PythonInterpreterFactory {
    private static final Logger log = LoggerFactory.getLogger(PythonInterpreterFactory.class);
    private static Set<String> bundleLocations = new ConcurrentSkipListSet<String>();
    private static final Queue<PythonInterpreter> interpreters = new LinkedBlockingQueue<PythonInterpreter>();

    private PythonInterpreterFactory() {
    }

    public static void addBundleLocations(List<String> bundleLocations) {
        PythonInterpreterFactory.bundleLocations.addAll(bundleLocations);
    }

    public static PythonInterpreter resolveInterpreter() {
        PythonInterpreter interpreter = interpreters.poll();
        if (interpreter == null) {
            long point = System.currentTimeMillis();
            Properties preProperties = System.getProperties();
            Properties postProperties = new Properties();
            postProperties.setProperty("python.cachedir", "../cachedir");
            PythonInterpreter.initialize((Properties)preProperties, (Properties)postProperties, null);
            PySystemState systemState = Py.getSystemState();
            for (String location : bundleLocations) {
                systemState.path.append((PyObject)new PyString(location));
            }
            log.trace("systemState={}", (Object)systemState);
            systemState.setdefaultencoding("utf-8");
            interpreter = new PythonInterpreter(null, systemState);
            interpreter.exec("import sys");
            interpreter.exec("print sys.path");
            interpreter.exec("import yaml");
            interpreter.exec("import artixds.domain");
            log.info("python interpeter create={}", (Object)(System.currentTimeMillis() - point));
        }
        return interpreter;
    }

    public static void releaseInterpreter(PythonInterpreter interpreter) {
        interpreters.add(interpreter);
    }
}

