/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart.undoredo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.undoredo.IUndoRedoListener;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.IUndoRedoCommand;

public class GanttUndoRedoManager {
    public static final int STACK_SIZE = 50;
    private final List _undoRedoEvents;
    private int _currentIndex;
    private int _maxStackSize;
    private final GanttComposite _comp;
    private final List _listeners;

    public GanttUndoRedoManager(GanttComposite parent, int maxStackSize) {
        this._comp = parent;
        this._undoRedoEvents = new ArrayList();
        this._listeners = new ArrayList();
        this._maxStackSize = maxStackSize;
    }

    public List getUndoRedoEvents() {
        return this._undoRedoEvents;
    }

    public void addUndoRedoListener(IUndoRedoListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeUndoRedoListener(IUndoRedoListener listener) {
        this._listeners.remove(listener);
    }

    public void record(IUndoRedoCommand command) {
        this.fixStack();
        this._undoRedoEvents.add(command);
        ++this._currentIndex;
        for (int i = 0; i < this._listeners.size(); ++i) {
            IUndoRedoListener listener = (IUndoRedoListener)this._listeners.get(i);
            listener.undoableCommandAdded(command);
        }
        this.updateListeners();
    }

    private void updateListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            IUndoRedoListener listener = (IUndoRedoListener)this._listeners.get(i);
            listener.canRedoChanged(this.canRedo());
            listener.canUndoChanged(this.canUndo());
        }
    }

    public void clear() {
        this._undoRedoEvents.clear();
        this._currentIndex = 0;
        this.updateListeners();
    }

    public boolean canUndo() {
        return this._currentIndex != 0 && !this._undoRedoEvents.isEmpty();
    }

    public boolean undo() {
        if (!this.canUndo()) {
            return false;
        }
        IUndoRedoCommand command = (IUndoRedoCommand)this._undoRedoEvents.get(this._currentIndex - 1);
        command.undo();
        this._comp.heavyRedraw();
        --this._currentIndex;
        if (this._currentIndex < 0) {
            this._currentIndex = 0;
        }
        this.updateListeners();
        for (int i = 0; i < this._listeners.size(); ++i) {
            IUndoRedoListener listener = (IUndoRedoListener)this._listeners.get(i);
            listener.commandUndone(command);
        }
        return true;
    }

    public boolean redo() {
        if (!this.canRedo()) {
            return false;
        }
        IUndoRedoCommand command = (IUndoRedoCommand)this._undoRedoEvents.get(this._currentIndex);
        command.redo();
        this._comp.heavyRedraw();
        ++this._currentIndex;
        if (this._currentIndex > this._undoRedoEvents.size()) {
            this._currentIndex = this._undoRedoEvents.size();
        }
        this.updateListeners();
        for (int i = 0; i < this._listeners.size(); ++i) {
            IUndoRedoListener listener = (IUndoRedoListener)this._listeners.get(i);
            listener.commandRedone(command);
        }
        return true;
    }

    public boolean canRedo() {
        if (this._undoRedoEvents.isEmpty()) {
            return false;
        }
        return this._currentIndex != this._undoRedoEvents.size();
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    private void fixStack() {
        int i;
        ArrayList toRemove = new ArrayList();
        for (i = this._currentIndex; i < this._undoRedoEvents.size(); ++i) {
            toRemove.add(this._undoRedoEvents.get(i));
        }
        this._undoRedoEvents.removeAll(toRemove);
        for (i = 0; i < toRemove.size(); ++i) {
            ((IUndoRedoCommand)toRemove.get(i)).dispose();
        }
        toRemove.clear();
        if (this._undoRedoEvents.size() > this._maxStackSize) {
            for (i = 0; i < this._maxStackSize - this._undoRedoEvents.size(); ++i) {
                toRemove.add(this._undoRedoEvents.get(i));
            }
        }
        for (i = 0; i < toRemove.size(); ++i) {
            ((IUndoRedoCommand)toRemove.get(i)).dispose();
        }
        this._undoRedoEvents.removeAll(toRemove);
    }

    public void setMaxStackSize(int stackSize) {
        if (stackSize <= 0) {
            return;
        }
        this._maxStackSize = stackSize;
    }
}

