/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.Calendar;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;

class ViewPortHandler {
    private GanttComposite _ganttComposite;

    public ViewPortHandler(GanttComposite parent) {
        this._ganttComposite = parent;
    }

    public void scrollingLeft(int diffCount) {
        int diff = diffCount;
        int mCurrentView = this._ganttComposite.getCurrentView();
        this._ganttComposite.showScrollDate();
        if (diff == 1) {
            if (mCurrentView == 4) {
                this.prevMonth();
                return;
            }
            if (mCurrentView == 1) {
                this.prevHour();
                return;
            }
            this.prevDay();
            return;
        }
        if (diff == 0) {
            if (mCurrentView == 4) {
                this.prevWeek();
                return;
            }
            if (mCurrentView == 1) {
                this.prevHour();
                return;
            }
            this.prevDay();
            return;
        }
        if (mCurrentView == 4 && diff > 7) {
            diff = 7;
        }
        for (int i = 0; i < diff; ++i) {
            if (mCurrentView == 4) {
                this.prevMonth();
                continue;
            }
            if (mCurrentView == 1) {
                this.prevHour();
                continue;
            }
            this.prevDay();
        }
    }

    public void scrollingRight(int diffCount) {
        int diff = diffCount;
        int mCurrentView = this._ganttComposite.getCurrentView();
        this._ganttComposite.showScrollDate();
        if (diff == 1) {
            if (mCurrentView == 4) {
                this.nextMonth();
                return;
            }
            if (mCurrentView == 1) {
                this.nextHour();
                return;
            }
            this.nextDay();
            return;
        }
        if (diff == 0) {
            if (mCurrentView == 4) {
                this.nextWeek();
                return;
            }
            if (mCurrentView == 1) {
                this.nextHour();
                return;
            }
            this.nextDay();
            return;
        }
        if (mCurrentView == 4 && diff > 7) {
            diff = 7;
        }
        for (int i = 0; i < diff; ++i) {
            if (mCurrentView == 4) {
                this.nextMonth();
                continue;
            }
            if (mCurrentView == 1) {
                this.nextHour();
                continue;
            }
            this.nextDay();
        }
    }

    public void nextMonth() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.set(5, 1);
        mCalendar.add(2, 1);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(false);
        this._ganttComposite.redraw();
    }

    public void prevMonth() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.set(5, 1);
        mCalendar.add(2, -1);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(true);
        this._ganttComposite.redraw();
    }

    public void nextWeek() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(5, 7);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(false);
        this._ganttComposite.redraw();
    }

    public void prevWeek() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(5, -7);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(true);
        this._ganttComposite.redraw();
    }

    public void nextHour() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(11, 1);
        if (mCalendar.get(11) >= 24) {
            mCalendar.add(5, 1);
            mCalendar.set(11, 0);
        }
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(false);
        this._ganttComposite.redraw();
    }

    public void prevHour() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(11, -1);
        if (mCalendar.get(11) < 0) {
            mCalendar.add(5, -1);
            mCalendar.set(11, 23);
        }
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.moveXBounds(true);
        this._ganttComposite.redraw();
    }

    public void nextDay() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(5, 1);
        mCalendar.set(11, 0);
        this._ganttComposite.moveXBounds(false);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.redraw();
    }

    public void prevDay() {
        Calendar mCalendar = this._ganttComposite.getRootCalendar();
        mCalendar.add(5, -1);
        mCalendar.set(11, 0);
        this._ganttComposite.moveXBounds(true);
        this._ganttComposite.setNoRecalc();
        this._ganttComposite.redraw();
    }
}

