/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.ViewPortHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

class HorizontalScrollbarHandler
implements Listener {
    private static final int _minScrollRange = 0;
    private static final int _maxScrollRange = 500;
    private static final int _center = 230;
    private GanttComposite _gc;
    private ScrollBar _scrollBar;
    private boolean _scrolling;
    private int _lastScrollbarPosition;
    private ViewPortHandler _vpHandler;
    private boolean _infinite;
    private boolean _none;
    private boolean _fixed;
    private int _lastDetailEvent;

    public HorizontalScrollbarHandler(GanttComposite parent, ScrollBar scrollBar, int style) {
        this._gc = parent;
        this._vpHandler = this._gc.getViewPortHandler();
        this._scrollBar = scrollBar;
        if ((style & 0x10) != 0) {
            this._fixed = true;
        } else if ((style & 8) != 0) {
            this._infinite = true;
        } else if ((style & 0x20) != 0) {
            this._none = true;
        }
        this._scrollBar.addListener(13, (Listener)this);
        if (this._infinite) {
            this._scrollBar.setVisible(true);
            this._scrollBar.setMinimum(0);
            this._scrollBar.setMaximum(500);
            this._scrollBar.setSelection(230);
            this._scrollBar.setThumb(20);
            return;
        }
        if (this._fixed) {
            this._scrollBar.setPageIncrement(7);
        }
        this._scrollBar.setMinimum(0);
        this._scrollBar.setIncrement(1);
        if (this._none || this._fixed) {
            this._scrollBar.setVisible(false);
        }
    }

    public void resetScrollPosition() {
        this._lastScrollbarPosition = this.getScrollBarPosition();
    }

    public void handleEvent(Event e) {
        this._scrolling = true;
        int cur = this.getScrollBarPosition();
        if (this._lastScrollbarPosition == cur) {
            if (e.detail == 0 && this._lastDetailEvent != 0 && this._fixed) {
                this.recalculate();
            }
            if (this._infinite && e.detail == 0) {
                this._scrollBar.setSelection(230);
                this._lastScrollbarPosition = 230;
            }
            this._gc.killDialogs();
            return;
        }
        this._lastDetailEvent = e.detail;
        boolean left = false;
        int diff = cur - this._lastScrollbarPosition;
        if (diff < 0) {
            left = true;
            diff = this._lastScrollbarPosition - cur;
        }
        boolean moveToCenter = false;
        if (e.detail == 0x1000005 || e.detail == 0x1000006) {
            this.scrollViewportByPage(this.scrollDirectionForEventDetail(e.detail), diff);
            moveToCenter = true;
        } else if (e.detail == 0x1000001 || e.detail == 0x1000002) {
            this.scrollViewportByOffset(this.scrollDirectionForEventDetail(e.detail), diff);
        } else if (e.detail == 1) {
            this.scrollViewportTo(left ? 16384 : 131072, this._scrollBar.getSelection(), diff);
        }
        if (this._infinite && e.detail == 0 || moveToCenter) {
            this._scrollBar.setSelection(230);
            this._lastScrollbarPosition = 230;
            this._gc.killDialogs();
            return;
        }
        this._lastScrollbarPosition = this.getScrollBarPosition();
        this._scrolling = false;
    }

    public int getScrollBarPosition() {
        return this._scrollBar.getSelection();
    }

    private void scrollViewportByPage(int direction, int diff) {
        this.scrollViewportByOffset(direction, diff);
    }

    private void scrollViewportByOffset(int direction, int diff) {
        if (direction == 16384) {
            this._vpHandler.scrollingLeft(diff);
        } else {
            this._vpHandler.scrollingRight(diff);
        }
    }

    private void scrollViewportTo(int direction, int position, int diff) {
        this.scrollViewportByOffset(direction, diff);
    }

    private int scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? 16384 : 131072;
    }

    public boolean isScrolling() {
        return this._scrolling;
    }

    public void recalculate() {
        if (this._gc.isDisposed() || !this._gc.isChartReady()) {
            return;
        }
        if (this._none) {
            return;
        }
        if (this._infinite) {
            this._scrollBar.setSelection(230);
            this._lastScrollbarPosition = 230;
            return;
        }
        if (this._fixed) {
            float dayWidth = this._gc.getDayWidth();
            int xLeftMostPixel = this._gc.getLeftMostPixel();
            int xRightMostPixel = this._gc.getRightMostPixel();
            int xStart = 0;
            int xEnd = this._gc.getVisibleBounds().width;
            int rangeBonus = 0;
            int gSectionWidth = this._gc.getSettings().getSectionBarWidth();
            if (this._gc.isShowingGanttSections()) {
                if (this._gc.getSettings().getSectionSide() == 16384) {
                    xStart = gSectionWidth;
                } else {
                    xEnd -= gSectionWidth;
                }
                rangeBonus += gSectionWidth;
            }
            int vScrollSize = 0;
            if (this._gc.getVerticalBar().isVisible()) {
                vScrollSize = this._gc.getVerticalBar().getSize().x;
                xEnd -= vScrollSize;
            }
            int extraLeft = xLeftMostPixel - xStart;
            int extraRight = xEnd - xRightMostPixel;
            if (extraLeft > 0) {
                rangeBonus += extraLeft;
            }
            if (extraRight > 0) {
                rangeBonus += extraRight;
            }
            if (extraLeft >= 0 && extraRight >= 0 || extraLeft == Integer.MAX_VALUE || extraRight == Integer.MIN_VALUE) {
                this._scrollBar.setMaximum(0);
                this._scrollBar.setSelection(0);
                this._scrollBar.setThumb(1000000);
                if (this._scrollBar.isVisible()) {
                    this._gc.redraw();
                }
                this._scrollBar.setVisible(false);
                return;
            }
            rangeBonus = (int)((float)rangeBonus + dayWidth);
            float pixelRange = xRightMostPixel - xLeftMostPixel + rangeBonus;
            pixelRange -= (float)this._gc.getVisibleBounds().width;
            if (this._gc.getCurrentView() != 4) {
                pixelRange /= dayWidth;
            } else {
                pixelRange /= dayWidth;
                pixelRange /= 30.0f;
                pixelRange += 1.0f;
            }
            this._scrollBar.setVisible(true);
            this._scrollBar.setMaximum((int)Math.ceil(pixelRange));
            this._scrollBar.setThumb(1);
            boolean setMax = false;
            boolean setMin = false;
            int scrollLocation = 0;
            if (extraRight > 0 && extraLeft < 0) {
                setMax = true;
            }
            if (extraLeft > 0 && extraRight < 0) {
                setMin = true;
            }
            if (!setMax && !setMin) {
                scrollLocation = extraLeft > 0 ? (scrollLocation -= extraLeft) : (scrollLocation += Math.abs(extraLeft));
                if (extraRight > 0) {
                    scrollLocation -= extraRight;
                }
            }
            if (setMax) {
                this._scrollBar.setSelection(this._scrollBar.getMaximum());
            } else if (setMin) {
                this._scrollBar.setSelection(0);
            } else {
                this._scrollBar.setSelection(scrollLocation / (int)dayWidth);
            }
            this._lastScrollbarPosition = this._scrollBar.getSelection();
        }
    }
}

