/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.AbstractGanttEvent;
import org.eclipse.nebula.widgets.ganttchart.AdvancedTooltip;
import org.eclipse.nebula.widgets.ganttchart.DateHelper;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttGroup;
import org.eclipse.nebula.widgets.ganttchart.GanttSection;
import org.eclipse.nebula.widgets.ganttchart.IGanttChartItem;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.EventMoveCommand;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.EventResizeCommand;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.IUndoRedoCommand;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class GanttEvent
extends AbstractGanttEvent
implements IGanttChartItem,
Cloneable {
    public static final int FIXED_ROW_HEIGHT_AUTOMATIC = -1;
    private Object _data;
    private String _name;
    private Calendar _revisedStart;
    private Calendar _revisedEnd;
    private Calendar _startDate;
    private Calendar _endDate;
    private int _percentComplete;
    private boolean _checkpoint;
    private boolean _scope;
    private boolean _locked;
    private boolean _image;
    private boolean _resizable = true;
    private boolean _moveable = true;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private int _earliestStartX;
    private int _latestEndX;
    private int _actualWidth;
    private Color _statusColor;
    private Color _gradientStatusColor;
    private boolean _showBoldText;
    private String _textDisplayFormat;
    private List _scopeEvents;
    private Image _picture;
    private Menu _menu;
    private GanttChart _parentChart;
    private GanttComposite _parentComposite;
    private GanttGroup _ganttGroup;
    private GanttSection _ganttSection;
    private boolean _hidden;
    private int _widthWithtText;
    private AdvancedTooltip _advancedTooltip;
    private int _visibility;
    private boolean _boundsHaveBeenSet;
    private int _fixedRowHeight = -1;
    private int _verticalEventAlignment = 128;
    private int _horizontalLineTopY;
    private int _horizontalLineBottomY;
    private Calendar _noMoveBeforeDate;
    private Calendar _noMoveAfterDate;
    private boolean _nameChanged = true;
    private Point _nameExtent;
    private String _parsedString;
    private int _horizontalTextLocation = 131072;
    private int _verticalTextLocation = 0x1000000;
    private Font _textFont;
    private int _daysBetweenStartAndEnd;
    private Calendar _preMoveDateEstiStart;
    private Calendar _preMoveDateEstiEnd;
    private Calendar _preMoveDateRevisedStart;
    private Calendar _preMoveDateRevisedEnd;
    private Rectangle _preMoveBounds;
    private boolean _moving;
    private int _moveType;
    private int _preMoveGanttSectionIndex;
    private int _preMoveGanttSectionEventLocationIndex;
    private GanttEvent _scopeParent;
    private int _dDayStart;
    private int _dDayEnd;
    private int _savedVerticalDragY;
    private Rectangle _preVerticalDragBounds;

    public GanttEvent(GanttChart parent, String name, Calendar startDate, Calendar endDate, int percentComplete) {
        this(parent, null, name, startDate, endDate, percentComplete);
    }

    public GanttEvent(GanttChart parent, Object data, String name, Calendar startDate, Calendar endDate, int percentComplete) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._data = data;
        this._name = name;
        this._startDate = startDate;
        this._endDate = endDate;
        this._percentComplete = percentComplete;
        this.init();
    }

    public GanttEvent(GanttChart parent, String name, Calendar startDate, Calendar endDate, Calendar revisedStart, Calendar revisedEnd, int percentComplete) {
        this(parent, null, name, startDate, endDate, revisedStart, revisedEnd, percentComplete);
    }

    public GanttEvent(GanttChart parent, Object data, String name, Calendar startDate, Calendar endDate, Calendar revisedStart, Calendar revisedEnd, int percentComplete) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._data = data;
        this._name = name;
        this._startDate = startDate;
        this._endDate = endDate;
        this._revisedStart = revisedStart;
        this._revisedEnd = revisedEnd;
        this._percentComplete = percentComplete;
        this.init();
    }

    public GanttEvent(GanttChart parent, int dDayStart, int dDayEnd) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._dDayStart = dDayStart;
        this._dDayEnd = dDayEnd;
        this._startDate = this._parentChart.getGanttComposite().getDDayCalendar();
        this._endDate = this._parentChart.getGanttComposite().getDDayCalendar();
        this._startDate.add(5, this._dDayStart);
        this._endDate.add(5, this._dDayEnd);
        this.init();
    }

    public GanttEvent(GanttChart parent, String name) {
        this(parent, null, name);
    }

    public GanttEvent(GanttChart parent, Object data, String name) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._data = data;
        this._name = name;
        this._scope = true;
        try {
            this.init();
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
        }
    }

    public GanttEvent(GanttChart parent, String name, Calendar date) {
        this(parent, null, name, date);
    }

    public GanttEvent(GanttChart parent, Object data, String name, Calendar date) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._data = data;
        this._name = name;
        this._startDate = date;
        this._endDate = date;
        this._checkpoint = true;
        try {
            this.init();
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
        }
    }

    public GanttEvent(GanttChart parent, String name, Calendar date, Image picture) {
        this(parent, null, name, date, picture);
    }

    public GanttEvent(GanttChart parent, Object data, String name, Calendar date, Image picture) {
        this._parentChart = parent;
        this._parentComposite = this._parentChart.getGanttComposite();
        this._data = data;
        this._name = name;
        this._startDate = date;
        this._endDate = date;
        this._picture = picture;
        this._image = true;
        try {
            this.init();
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
        }
    }

    private final void init() {
        this._scopeEvents = new ArrayList();
        this._parentComposite.addEvent(this, true);
        this.updateDaysBetweenStartAndEnd();
    }

    public Object getData() {
        return this._data;
    }

    public void setData(Object data) {
        this._data = data;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this._nameChanged = true;
    }

    public Calendar getStartDate() {
        if (this._startDate == null) {
            return null;
        }
        return DateHelper.getNewCalendar(this._startDate);
    }

    public Calendar getActualStartDate() {
        Calendar ret = this._revisedStart == null ? this._startDate : this._revisedStart;
        return ret == null ? null : DateHelper.getNewCalendar(ret);
    }

    public Calendar getActualEndDate() {
        Calendar ret = this._revisedEnd == null ? this._endDate : this._revisedEnd;
        return ret == null ? null : DateHelper.getNewCalendar(ret);
    }

    public Calendar getEarliestStartDate() {
        if (this._revisedStart == null && this._startDate == null) {
            return null;
        }
        if (this._revisedStart == null) {
            return this._startDate;
        }
        if (this._startDate == null) {
            return this._revisedStart;
        }
        return this._startDate.before(this._revisedStart) ? this._startDate : this._revisedStart;
    }

    public Calendar getLatestEndDate() {
        if (this._revisedEnd == null && this._endDate == null) {
            return null;
        }
        if (this._revisedEnd == null) {
            return this._endDate;
        }
        if (this._endDate == null) {
            return this._revisedEnd;
        }
        return this._endDate.after(this._revisedEnd) ? this._endDate : this._revisedEnd;
    }

    public void setStartDate(Calendar startDate) {
        if (startDate == null) {
            this._startDate = startDate;
            this.updateDaysBetweenStartAndEnd();
            return;
        }
        Calendar sDate = DateHelper.getNewCalendar(startDate);
        if (this._noMoveBeforeDate != null && startDate.before(this._noMoveBeforeDate)) {
            return;
        }
        Calendar aEnd = this.getActualEndDate();
        if (aEnd != null && startDate.after(aEnd)) {
            sDate = aEnd;
        }
        this._startDate = sDate;
        this.updateDaysBetweenStartAndEnd();
    }

    public void update(boolean redraw) {
        this._parentComposite.eventDatesChanged(this, redraw);
    }

    public Calendar getEndDate() {
        if (this._endDate == null) {
            return null;
        }
        return DateHelper.getNewCalendar(this._endDate);
    }

    public void setEndDate(Calendar endDate) {
        if (endDate == null) {
            this._endDate = endDate;
            this.updateDaysBetweenStartAndEnd();
            return;
        }
        Calendar eDate = DateHelper.getNewCalendar(endDate);
        if (this._noMoveAfterDate != null && endDate.after(this._noMoveAfterDate)) {
            return;
        }
        Calendar aDate = this.getActualStartDate();
        if (aDate != null && endDate.before(aDate)) {
            eDate = aDate;
        }
        this._endDate = eDate;
        this.updateDaysBetweenStartAndEnd();
    }

    public int getPercentComplete() {
        return this._percentComplete;
    }

    public void setPercentComplete(int percentComplete) {
        this._percentComplete = percentComplete;
    }

    public Menu getMenu() {
        if (this._menu == null) {
            this._menu = new Menu((Control)this._parentComposite);
        }
        return this._menu;
    }

    void setBounds(int x, int y, int width, int height) {
        this._boundsHaveBeenSet = true;
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
    }

    void setBounds(Rectangle bounds) {
        this._boundsHaveBeenSet = true;
        this._x = bounds.x;
        this._y = bounds.y;
        this._width = bounds.width;
        this._height = bounds.height;
        if (this.getEarliestStartDate() != null) {
            this.setEarliestStartX(this._parentComposite.getStartingXFor(this.getEarliestStartDate()));
        }
        if (this.getLatestEndDate() != null) {
            this.setLatestEndX(this._parentComposite.getXForDate(this.getLatestEndDate()) + this._parentComposite.getDayWidth());
        }
    }

    void updateX(int x) {
        this._x = x;
        this.updateOtherXs();
    }

    private void updateOtherXs() {
        if (this.getEarliestStartDate() != null) {
            this.setEarliestStartX(this._parentComposite.getStartingXFor(this.getEarliestStartDate()));
        }
        if (this.getLatestEndDate() != null) {
            this.setLatestEndX(this._parentComposite.getXForDate(this.getLatestEndDate()) + this._parentComposite.getDayWidth());
        }
    }

    void updateY(int y) {
        this._y = y;
    }

    void updateHeight(int height) {
        this._height = height;
    }

    void updateWidth(int width) {
        this._width = width;
    }

    public boolean isCheckpoint() {
        return this._checkpoint;
    }

    public void setCheckpoint(boolean checkpoint) {
        this._scope = false;
        this._image = false;
        this._checkpoint = checkpoint;
    }

    public int getX() {
        return this._x;
    }

    public int getXEnd() {
        return this._x + this._width;
    }

    public int getY() {
        return this._y;
    }

    public int getBottomY() {
        return this._y + this._height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public Calendar getRevisedStart() {
        if (this._revisedStart == null) {
            return null;
        }
        return DateHelper.getNewCalendar(this._revisedStart);
    }

    public void setRevisedStart(Calendar revisedStart) {
        this.setRevisedDates(revisedStart, null);
    }

    public Calendar getRevisedEnd() {
        if (this._revisedEnd == null) {
            return null;
        }
        return DateHelper.getNewCalendar(this._revisedEnd);
    }

    public void setRevisedEnd(Calendar revisedEnd) {
        this.setRevisedDates(null, revisedEnd);
    }

    public void setRevisedStart(int dDayStart) {
        this._revisedStart = this._parentComposite.getDDayCalendar();
        this._revisedStart.add(5, dDayStart);
    }

    public void setRevisedEnd(int dDayEnd) {
        this._revisedEnd = this._parentComposite.getDDayCalendar();
        this._revisedEnd.add(5, dDayEnd);
    }

    private void setRevisedDates(Calendar revisedStart, Calendar revisedEnd) {
        if (revisedStart == null && revisedEnd == null) {
            return;
        }
        if (revisedStart != null && this.getActualEndDate() != null && revisedStart.after(this.getActualEndDate())) {
            return;
        }
        if (revisedEnd != null && this.getActualStartDate() != null && revisedEnd.before(this.getActualStartDate())) {
            return;
        }
        if (revisedStart != null) {
            this._revisedStart = DateHelper.getNewCalendar(revisedStart);
        }
        if (revisedEnd != null) {
            this._revisedEnd = DateHelper.getNewCalendar(revisedEnd);
        }
        if (this._noMoveBeforeDate != null && revisedStart != null && revisedStart.before(this._noMoveBeforeDate)) {
            this._revisedStart = DateHelper.getNewCalendar(this._noMoveBeforeDate);
        }
        if (this._noMoveAfterDate != null && revisedEnd != null && revisedEnd.after(this._noMoveAfterDate)) {
            this._revisedEnd = DateHelper.getNewCalendar(this._noMoveAfterDate);
        }
        this.updateDaysBetweenStartAndEnd();
    }

    public void setRevisedStart(Calendar revisedStart, boolean validate) {
        if (validate) {
            this.setRevisedStart(revisedStart);
        } else {
            this._revisedStart = DateHelper.getNewCalendar(revisedStart);
            this.updateDaysBetweenStartAndEnd();
        }
    }

    public void setRevisedEnd(Calendar revisedEnd, boolean validate) {
        if (validate) {
            this.setRevisedEnd(revisedEnd);
        } else {
            this._revisedEnd = DateHelper.getNewCalendar(revisedEnd);
            this.updateDaysBetweenStartAndEnd();
        }
    }

    public void setRevisedDates(Calendar revisedStart, Calendar revisedEnd, int order) {
        if (order == 0x2000000) {
            this.setRevisedStart(revisedStart);
            this.setRevisedEnd(revisedEnd);
        } else {
            this.setRevisedEnd(revisedEnd);
            this.setRevisedStart(revisedStart);
        }
        this.updateDaysBetweenStartAndEnd();
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    public Color getGradientStatusColor() {
        return this._gradientStatusColor;
    }

    public void setGradientStatusColor(Color gradientStatusColor) {
        this._gradientStatusColor = gradientStatusColor;
    }

    public Color getStatusColor() {
        return this._statusColor;
    }

    public void setStatusColor(Color statusColor) {
        this._statusColor = statusColor;
    }

    public boolean showBoldText() {
        return this._showBoldText;
    }

    public void setShowBoldText(boolean showBoldText) {
        this._showBoldText = showBoldText;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public String getTextDisplayFormat() {
        return this._textDisplayFormat;
    }

    public void setTextDisplayFormat(String format) {
        this._textDisplayFormat = format;
    }

    public void setScope(boolean scope) {
        this._checkpoint = false;
        this._image = false;
        this._scope = scope;
        if (!scope) {
            for (int i = 0; i < this._scopeEvents.size(); ++i) {
                ((GanttEvent)this._scopeEvents.get(i)).setScopeParent(null);
            }
            this._scopeEvents.clear();
        }
    }

    public boolean isScope() {
        return this._scope;
    }

    public void addScopeEvent(GanttEvent event) {
        if (event == this) {
            return;
        }
        if (this._scopeEvents.contains(event)) {
            return;
        }
        this._scopeEvents.add(event);
        event.setScopeParent(this);
    }

    public void removeScopeEvent(GanttEvent event) {
        this._scopeEvents.remove(event);
    }

    public List getScopeEvents() {
        return this._scopeEvents;
    }

    private GanttEvent getEarliestOrLatestScopeEvent(boolean earliest) {
        Calendar ret = null;
        GanttEvent retEvent = null;
        for (int i = 0; i < this._scopeEvents.size(); ++i) {
            GanttEvent ge = (GanttEvent)this._scopeEvents.get(i);
            if (earliest) {
                if (ret == null) {
                    ret = ge.getActualStartDate();
                    retEvent = ge;
                    continue;
                }
                if (!ge.getActualStartDate().before(ret)) continue;
                ret = ge.getActualStartDate();
                retEvent = ge;
                continue;
            }
            if (ret == null) {
                ret = ge.getActualEndDate();
                retEvent = ge;
                continue;
            }
            if (!ge.getActualEndDate().after(ret)) continue;
            ret = ge.getActualEndDate();
            retEvent = ge;
        }
        return retEvent;
    }

    public GanttEvent getEarliestScopeEvent() {
        if (!this.isScope() || this._scopeEvents.isEmpty()) {
            return null;
        }
        return this.getEarliestOrLatestScopeEvent(true);
    }

    public GanttEvent getLatestScopeEvent() {
        if (!this.isScope() || this._scopeEvents.isEmpty()) {
            return null;
        }
        return this.getEarliestOrLatestScopeEvent(false);
    }

    public Image getPicture() {
        return this._picture;
    }

    public void setPicture(Image picture) {
        this._picture = picture;
    }

    public void setImage(boolean image) {
        this._checkpoint = false;
        this._scope = false;
        this._image = image;
    }

    public boolean isImage() {
        return this._image;
    }

    public GanttGroup getGanttGroup() {
        return this._ganttGroup;
    }

    public void setGanttGroup(GanttGroup group) {
        this._ganttGroup = group;
    }

    public GanttSection getGanttSection() {
        return this._ganttSection;
    }

    void setGanttSection(GanttSection ganttSection) {
        this._ganttSection = ganttSection;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    private void internalSetAllChildrenHidden(boolean hidden) {
        if (this._scopeEvents == null) {
            return;
        }
        for (int i = 0; i < this._scopeEvents.size(); ++i) {
            ((GanttEvent)this._scopeEvents.get(i)).setHidden(hidden);
        }
    }

    public void hideAllChildren() {
        this.internalSetAllChildrenHidden(true);
        this._parentComposite.updateHorizontalScrollbar();
        this._parentComposite.updateVerticalScrollBar(false);
        this._parentComposite.heavyRedraw();
    }

    public void showAllChildren() {
        this.internalSetAllChildrenHidden(false);
        this._parentComposite.updateHorizontalScrollbar();
        this._parentComposite.updateVerticalScrollBar(false);
        this._parentComposite.heavyRedraw();
    }

    public boolean isChildrenHidden() {
        if (this._scopeEvents == null) {
            return false;
        }
        for (int i = 0; i < this._scopeEvents.size(); ++i) {
            if (((GanttEvent)this._scopeEvents.get(i)).isHidden()) continue;
            return false;
        }
        return true;
    }

    public int getWidthWithText() {
        return this._widthWithtText;
    }

    public void setWidthWithText(int width) {
        this._widthWithtText = width;
    }

    public AdvancedTooltip getAdvancedTooltip() {
        return this._advancedTooltip;
    }

    public void setAdvancedTooltip(AdvancedTooltip advancedTooltip) {
        this._advancedTooltip = advancedTooltip;
    }

    public int getFixedRowHeight() {
        return this._fixedRowHeight;
    }

    public void setFixedRowHeight(int fixedRowHeight) {
        this._fixedRowHeight = fixedRowHeight;
    }

    public boolean isAutomaticRowHeight() {
        return this.getFixedRowHeight() == -1;
    }

    public void setAutomaticRowHeight() {
        this.setFixedRowHeight(-1);
    }

    public int getVerticalEventAlignment() {
        return this._verticalEventAlignment;
    }

    public void setVerticalEventAlignment(int verticalEventAlignment) {
        this._verticalEventAlignment = verticalEventAlignment;
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }

    public boolean isMoveable() {
        return this._moveable;
    }

    public void setMoveable(boolean moveable) {
        this._moveable = moveable;
    }

    public Calendar getNoMoveBeforeDate() {
        return this._noMoveBeforeDate;
    }

    public void setNoMoveBeforeDate(Calendar noMoveBeforeDate) {
        this._noMoveBeforeDate = noMoveBeforeDate;
    }

    public Calendar getNoMoveAfterDate() {
        return this._noMoveAfterDate;
    }

    public void setNoMoveAfterDate(Calendar noMoveAfterDate) {
        this._noMoveAfterDate = noMoveAfterDate;
    }

    public int getHorizontalTextLocation() {
        return this._horizontalTextLocation;
    }

    public void setHorizontalTextLocation(int textLocation) {
        this._horizontalTextLocation = textLocation;
    }

    public int getVerticalTextLocation() {
        return this._verticalTextLocation;
    }

    public void setVerticalTextLocation(int verticalTextLocation) {
        this._verticalTextLocation = verticalTextLocation;
    }

    public Font getTextFont() {
        return this._textFont;
    }

    public void setTextFont(Font textFont) {
        this._textFont = textFont;
    }

    public void dispose() {
        this._parentComposite.removeEvent(this);
    }

    public int getActualDDayStart() {
        return this._revisedStart == null ? this.getDDayStart() : this.getDDayRevisedStart();
    }

    public int getActualDDayEnd() {
        return this._revisedEnd == null ? this.getDDayEnd() : this.getDDayRevisedEnd();
    }

    public int getDDayStart() {
        return this._dDayStart;
    }

    public int getDDayRevisedStart() {
        if (this._revisedStart == null) {
            return Integer.MAX_VALUE;
        }
        return (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this._revisedStart);
    }

    public int getDDayRevisedEnd() {
        if (this._revisedEnd == null) {
            return Integer.MAX_VALUE;
        }
        return (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this._revisedEnd);
    }

    public void setDDayStart(int day) {
        this._dDayStart = day;
        this._startDate = this._parentComposite.getDDayCalendar();
        this._startDate.add(5, day);
        this.updateDaysBetweenStartAndEnd();
    }

    public int getDDayEnd() {
        return this._dDayEnd;
    }

    public void setDDayEnd(int day) {
        this._dDayEnd = day;
        this._endDate = this._parentComposite.getDDayCalendar();
        this._endDate.add(5, day);
        this.updateDaysBetweenStartAndEnd();
    }

    public int getDDateRange() {
        return (int)DateHelper.daysBetween(this.getStartDate(), this.getEndDate());
    }

    public int getRevisedDDateRange() {
        return (int)DateHelper.daysBetween(this.getActualStartDate(), this.getActualEndDate()) + 1;
    }

    public Rectangle getActualBounds() {
        Rectangle ret = this.getBounds();
        int plannedExtraRight = 0;
        int plannedExtraLeft = 0;
        boolean usePlannedLeft = false;
        boolean usePlannedRight = false;
        if (this._parentComposite.isShowingPlannedDates()) {
            if (this.getStartDate() != null && this.getRevisedStart() != null) {
                plannedExtraLeft = this.getX() - this._earliestStartX;
            }
            if (this.getEndDate() != null && this.getRevisedEnd() != null) {
                plannedExtraRight = this._latestEndX - this.getXEnd() + this._parentComposite.getDayWidth();
            }
        }
        int xExtra = 0;
        int yExtra = 0;
        int wExtra = 0;
        int hExtra = 0;
        int textSpacer = this._parentChart.getSettings().getTextSpacerConnected();
        if (this.getNameExtent() != null) {
            switch (this._horizontalTextLocation) {
                case 16384: {
                    int extra = this.getNameExtent().x + textSpacer;
                    if (plannedExtraLeft > extra) {
                        usePlannedLeft = true;
                    }
                    xExtra -= extra;
                    wExtra += extra;
                    usePlannedRight = plannedExtraRight > 0;
                    break;
                }
                case 0x1000000: {
                    int start = this._width / 2;
                    if ((start += this.getNameExtent().x + textSpacer) > this._x + this._width) {
                        wExtra += start - (this._x + this._width);
                    }
                    if (plannedExtraRight > wExtra) {
                        usePlannedRight = true;
                    }
                    usePlannedLeft = plannedExtraLeft > 0;
                    break;
                }
                case 131072: {
                    if (plannedExtraRight > (wExtra += this.getNameExtent().x + textSpacer)) {
                        usePlannedRight = true;
                    }
                    usePlannedLeft = plannedExtraLeft > 0;
                    break;
                }
            }
            switch (this._verticalTextLocation) {
                case 128: {
                    yExtra -= this.getNameExtent().y;
                    hExtra += this.getNameExtent().y;
                    break;
                }
                case 0x1000000: {
                    if (this.getNameExtent().y <= this._height) break;
                    int diff = this._height - this.getNameExtent().y;
                    yExtra -= diff / 2;
                    hExtra += diff / 2;
                    break;
                }
                case 1024: {
                    hExtra += this.getNameExtent().y;
                    yExtra -= this.getNameExtent().y;
                    break;
                }
            }
        }
        if (this._parentComposite.isShowingPlannedDates()) {
            if (usePlannedRight && usePlannedLeft) {
                xExtra -= plannedExtraLeft;
                wExtra = plannedExtraLeft;
                wExtra += plannedExtraRight;
            } else if (usePlannedRight) {
                wExtra = plannedExtraRight + this._parentComposite.getDayWidth();
            } else if (usePlannedLeft) {
                xExtra = -(plannedExtraLeft + this._parentComposite.getDayWidth());
                wExtra += Math.abs(plannedExtraLeft) + this._parentComposite.getDayWidth();
            }
        }
        ret.x += xExtra;
        ret.width += wExtra;
        ret.y += yExtra;
        ret.height += hExtra;
        return ret;
    }

    void calculateScope() {
        Calendar earliest = null;
        Calendar latest = null;
        float percentage = 0.0f;
        for (int i = 0; i < this._scopeEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._scopeEvents.get(i);
            if (earliest == null) {
                earliest = event.getActualStartDate();
            } else if (event.getActualStartDate().before(earliest)) {
                earliest = event.getActualStartDate();
            }
            if (latest == null) {
                latest = event.getActualEndDate();
            } else if (event.getActualEndDate().after(latest)) {
                latest = event.getActualEndDate();
            }
            percentage += (float)event.getPercentComplete();
        }
        percentage /= (float)(this._scopeEvents.isEmpty() ? 1 : this._scopeEvents.size());
        if (earliest == null && this._startDate != null) {
            earliest = this._startDate;
        }
        if (latest == null && this._endDate != null) {
            latest = this._endDate;
        }
        this.setStartDate(earliest);
        this.setEndDate(latest);
        this.setPercentComplete((int)percentage);
        this.updateDaysBetweenStartAndEnd();
    }

    boolean hasMovementConstraints() {
        return this._noMoveAfterDate != null || this._noMoveBeforeDate != null;
    }

    int getVisibility() {
        return this._visibility;
    }

    void setVisibility(int visibility) {
        this._visibility = visibility;
    }

    boolean isBoundsSet() {
        return this._boundsHaveBeenSet;
    }

    void setBoundsSet(boolean set) {
        this._boundsHaveBeenSet = set;
    }

    void setHorizontalLineTopY(int y) {
        this._horizontalLineTopY = y;
    }

    int getHorizontalLineTopY() {
        return this._horizontalLineTopY;
    }

    int getHorizontalLineBottomY() {
        return this._horizontalLineBottomY;
    }

    void setHorizontalLineBottomY(int y) {
        this._horizontalLineBottomY = y;
    }

    void setNameChanged(boolean changed) {
        this._nameChanged = changed;
    }

    boolean isNameChanged() {
        return this._nameChanged;
    }

    Point getNameExtent() {
        return this._nameExtent;
    }

    void setNameExtent(Point extent) {
        this._nameExtent = extent;
    }

    String getParsedString() {
        return this._parsedString;
    }

    void setParsedString(String parsed) {
        this._parsedString = parsed;
    }

    int getDaysBetweenStartAndEnd() {
        return this._daysBetweenStartAndEnd;
    }

    private final void updateDaysBetweenStartAndEnd() {
        if (this.getActualStartDate() == null || this.getActualEndDate() == null) {
            this._daysBetweenStartAndEnd = -1;
            return;
        }
        this._daysBetweenStartAndEnd = (int)DateHelper.daysBetween(this.getActualStartDate(), this.getActualEndDate());
        if (this._parentComposite.getCurrentView() == 5) {
            this._dDayStart = (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this.getStartDate());
            this._dDayEnd = (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this.getEndDate());
            --this._dDayStart;
        }
    }

    void moveStarted(int moveType) {
        Calendar cal;
        if (this._moving) {
            return;
        }
        this._moveType = moveType;
        if (this._startDate != null) {
            cal = Calendar.getInstance();
            cal.setTime(this._startDate.getTime());
            this._preMoveDateEstiStart = cal;
        }
        if (this._endDate != null) {
            cal = Calendar.getInstance();
            cal.setTime(this._endDate.getTime());
            this._preMoveDateEstiEnd = cal;
        }
        if (this._revisedStart != null) {
            cal = Calendar.getInstance();
            cal.setTime(this._revisedStart.getTime());
            this._preMoveDateRevisedStart = cal;
        }
        if (this._revisedEnd != null) {
            cal = Calendar.getInstance();
            cal.setTime(this._revisedEnd.getTime());
            this._preMoveDateRevisedEnd = cal;
        }
        this._preMoveBounds = new Rectangle(this._x, this._y, this._width, this._height);
        this._preMoveGanttSectionIndex = this._parentComposite.getGanttSections().indexOf(this._ganttSection);
        this._preMoveGanttSectionEventLocationIndex = this._ganttSection != null ? this._ganttSection.getEvents().indexOf(this) : this._parentComposite.getEvents().indexOf(this);
        this._moving = true;
    }

    IUndoRedoCommand getPostMoveOrResizeUndoCommand() {
        switch (this._moveType) {
            case 3: {
                int indexNow = 0;
                indexNow = this._ganttSection != null ? this._ganttSection.getEvents().indexOf(this) : this._parentComposite.getEvents().indexOf(this);
                GanttSection gs = null;
                if (this._preMoveGanttSectionIndex > -1) {
                    gs = (GanttSection)this._parentComposite.getGanttSections().get(this._preMoveGanttSectionIndex);
                }
                return new EventMoveCommand(this, this._preMoveDateEstiStart, this._startDate, this._preMoveDateEstiEnd, this._endDate, this._preMoveDateRevisedStart, this._revisedStart, this._preMoveDateRevisedEnd, this._revisedEnd, gs, this._ganttSection, this._preMoveGanttSectionEventLocationIndex, indexNow);
            }
            case 1: 
            case 2: {
                return new EventResizeCommand(this, this._preMoveDateEstiStart, this._startDate, this._preMoveDateEstiEnd, this._endDate, this._preMoveDateRevisedStart, this._revisedStart, this._preMoveDateRevisedEnd, this._revisedEnd);
            }
        }
        return null;
    }

    void moveCancelled() {
        this._moving = false;
        this._startDate = this._preMoveDateEstiStart;
        this._endDate = this._preMoveDateEstiEnd;
        this._revisedStart = this._preMoveDateRevisedStart;
        this._revisedEnd = this._preMoveDateRevisedEnd;
        if (this._preMoveBounds != null) {
            this._x = this._preMoveBounds.x;
            this._y = this._preMoveBounds.y;
            this._width = this._preMoveBounds.width;
            this._height = this._preMoveBounds.height;
        }
    }

    void moveFinished() {
        this._moving = false;
    }

    public GanttEvent getScopeParent() {
        return this._scopeParent;
    }

    void setScopeParent(GanttEvent parent) {
        this._scopeParent = parent;
    }

    void setEarliestStartX(int x) {
        this._earliestStartX = x;
    }

    void setLatestEndX(int x) {
        this._latestEndX = x;
    }

    int getEarliestStartX() {
        return this._earliestStartX;
    }

    int getLatestEndX() {
        return this._latestEndX;
    }

    int getActualWidth() {
        return this._actualWidth;
    }

    void updateActualWidth() {
        this._actualWidth = Math.abs(Math.abs(this._latestEndX) - Math.abs(this._earliestStartX));
    }

    void flagDragging() {
        this._savedVerticalDragY = this._y;
        this._preVerticalDragBounds = new Rectangle(this._x, this._y, this._width, this._height);
    }

    Rectangle getPreVerticalDragBounds() {
        return this._preVerticalDragBounds;
    }

    void undoVerticalDragging() {
        this._y = this._savedVerticalDragY;
    }

    boolean wasVerticallyMovedUp() {
        if (this._preVerticalDragBounds == null) {
            return false;
        }
        return this._y < this._preVerticalDragBounds.y;
    }

    boolean hasMovedVertically() {
        return this._y != this._savedVerticalDragY;
    }

    public void reparentToNewGanttSection(int index, GanttSection newSection) {
        if (this._ganttSection != null) {
            this._ganttSection.removeGanttEvent(this);
            newSection.addGanttEvent(index, this);
        }
    }

    public String toString() {
        return this._name;
    }

    public GanttChart getParentChart() {
        return this._parentChart;
    }

    public GanttComposite getParentComposite() {
        return this._parentComposite;
    }

    public void setNoUpdatePlannedDates(Calendar start, Calendar end) {
        this._startDate = start == null ? null : (Calendar)start.clone();
        this._endDate = end == null ? null : (Calendar)end.clone();
        this.updateDaysBetweenStartAndEnd();
    }

    public void setNoUpdateRevisedDates(Calendar start, Calendar end) {
        this._revisedStart = start == null ? null : (Calendar)start.clone();
        this._revisedEnd = end == null ? null : (Calendar)end.clone();
        this.updateDaysBetweenStartAndEnd();
    }

    public Object clone() throws CloneNotSupportedException {
        GanttEvent clone = new GanttEvent(this._parentChart, this.getName());
        if (this._endDate != null) {
            clone._endDate = (Calendar)this._endDate.clone();
        }
        if (this._noMoveAfterDate != null) {
            clone._noMoveAfterDate = (Calendar)this._noMoveAfterDate.clone();
        }
        if (this._noMoveBeforeDate != null) {
            clone._noMoveBeforeDate = (Calendar)this._noMoveBeforeDate.clone();
        }
        if (this._preMoveDateEstiStart != null) {
            clone._preMoveDateEstiEnd = (Calendar)this._preMoveDateEstiEnd.clone();
        }
        if (this._preMoveDateEstiStart != null) {
            clone._preMoveDateEstiStart = (Calendar)this._preMoveDateEstiStart.clone();
        }
        if (this._preMoveDateRevisedEnd != null) {
            clone._preMoveDateRevisedEnd = (Calendar)this._preMoveDateRevisedEnd.clone();
        }
        if (this._preMoveDateRevisedStart != null) {
            clone._preMoveDateRevisedStart = (Calendar)this._preMoveDateRevisedStart.clone();
        }
        if (this._revisedEnd != null) {
            clone._revisedEnd = (Calendar)this._revisedEnd.clone();
        }
        if (this._revisedStart != null) {
            clone._revisedStart = (Calendar)this._revisedStart.clone();
        }
        clone._scopeParent = this._scopeParent;
        clone._scopeEvents = new ArrayList(this._scopeEvents);
        if (this._startDate != null) {
            clone._startDate = (Calendar)this._startDate.clone();
        }
        clone._advancedTooltip = this._advancedTooltip;
        clone._boundsHaveBeenSet = this._boundsHaveBeenSet;
        clone._checkpoint = this._checkpoint;
        clone._data = this._data;
        clone._daysBetweenStartAndEnd = this._daysBetweenStartAndEnd;
        clone._dDayEnd = this._dDayEnd;
        clone._dDayStart = this._dDayStart;
        clone._fixedRowHeight = this._fixedRowHeight;
        clone._ganttGroup = this._ganttGroup;
        clone._gradientStatusColor = this._gradientStatusColor;
        clone._hidden = this._hidden;
        clone._horizontalLineBottomY = this._horizontalLineBottomY;
        clone._horizontalLineTopY = this._horizontalLineTopY;
        clone._horizontalTextLocation = this._horizontalTextLocation;
        clone._image = this._image;
        clone._locked = this._locked;
        clone._menu = this._menu;
        clone._moveable = this._moveable;
        clone._moving = false;
        clone._nameChanged = this._nameChanged;
        clone._nameExtent = this._nameExtent;
        clone._parsedString = this._parsedString;
        clone._percentComplete = this._percentComplete;
        clone._picture = this._picture;
        clone._preMoveBounds = this._preMoveBounds;
        clone._resizable = this._resizable;
        clone._scope = this._scope;
        clone._scopeEvents = new ArrayList(this._scopeEvents);
        clone._scopeParent = this._scopeParent;
        clone._showBoldText = this._showBoldText;
        clone._statusColor = this._statusColor;
        clone._textDisplayFormat = this._textDisplayFormat;
        clone._textFont = this._textFont;
        clone._verticalEventAlignment = this._verticalEventAlignment;
        clone._verticalTextLocation = this._verticalTextLocation;
        clone._visibility = this._visibility;
        clone._widthWithtText = this._widthWithtText;
        clone._latestEndX = this._latestEndX;
        clone._earliestStartX = this._earliestStartX;
        clone._actualWidth = this._actualWidth;
        clone._savedVerticalDragY = this._savedVerticalDragY;
        return clone;
    }
}

