/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.Calendar;
import java.util.Random;
import org.eclipse.nebula.widgets.ganttchart.DefaultColorManager;
import org.eclipse.nebula.widgets.ganttchart.DefaultLanguageManager;
import org.eclipse.nebula.widgets.ganttchart.DefaultPaintManager;
import org.eclipse.nebula.widgets.ganttchart.DefaultSettings;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.GanttGroup;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.nebula.widgets.ganttchart.IGanttEventListener;
import org.eclipse.nebula.widgets.ganttchart.ILanguageManager;
import org.eclipse.nebula.widgets.ganttchart.IPaintManager;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.nebula.widgets.ganttchart.undoredo.GanttUndoRedoManager;
import org.eclipse.nebula.widgets.ganttchart.undoredo.IUndoRedoListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class GanttChart
extends Composite {
    private GanttComposite _ganttComposite;
    private int _style;
    private ISettings _settings;
    private IColorManager _colorManager;
    private IPaintManager _paintManager;
    private ILanguageManager _languageManager;

    public GanttChart(Composite parent, int style) {
        this(parent, style, null, null, null, null);
    }

    public GanttChart(Composite parent, int style, ISettings settings) {
        this(parent, style, settings, null, null, null);
    }

    public GanttChart(Composite parent, int style, ISettings settings, IColorManager colorManager) {
        this(parent, style, settings, colorManager, null, null);
    }

    public GanttChart(Composite parent, int style, ISettings settings, IColorManager colorManager, IPaintManager paintManager, ILanguageManager languageManager) {
        super(parent, 0);
        int styleToUse = style;
        if ((style & 0x10) == 0 && (style & 0x20) == 0 && (style & 8) == 0) {
            styleToUse |= 8;
        }
        this._style = styleToUse;
        this._settings = settings;
        this._colorManager = colorManager;
        this._paintManager = paintManager;
        this._languageManager = languageManager;
        this.init();
    }

    public void addGroup(GanttGroup group) {
        this._ganttComposite.addGroup(group);
    }

    public void removeGroup(GanttGroup group) {
        this._ganttComposite.removeGroup(group);
    }

    private void init() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        if (this._settings == null) {
            this._settings = new DefaultSettings();
        }
        if (this._colorManager == null) {
            this._colorManager = new DefaultColorManager();
        }
        if (this._paintManager == null) {
            this._paintManager = new DefaultPaintManager();
        }
        if (this._languageManager == null) {
            this._languageManager = new DefaultLanguageManager();
        }
        this._ganttComposite = new GanttComposite(this, this._style, this._settings, this._colorManager, this._paintManager, this._languageManager);
        this._ganttComposite.setLayoutData(new GridData(1808));
    }

    public void addConnection(GanttEvent source, GanttEvent target) {
        this.checkWidget();
        this._ganttComposite.addDependency(source, target);
    }

    public void addDependency(GanttEvent source, GanttEvent target) {
        this.checkWidget();
        this.addConnection(source, target);
    }

    public void addGanttEventListener(IGanttEventListener listener) {
        this.checkWidget();
        this._ganttComposite.addGanttEventListener(listener);
    }

    public void removeGanttEventListener(IGanttEventListener listener) {
        this.checkWidget();
        this._ganttComposite.removeGanttEventListener(listener);
    }

    public GanttComposite getGanttComposite() {
        this.checkWidget();
        return this._ganttComposite;
    }

    public void redrawGanttChart() {
        this._ganttComposite.redraw();
    }

    public void reindex(GanttEvent event, int newIndex) {
        this._ganttComposite.reindex(event, newIndex);
    }

    public ISettings getSettings() {
        return this._settings;
    }

    public IColorManager getColorManager() {
        return this._colorManager;
    }

    public IPaintManager getPaintManager() {
        return this._paintManager;
    }

    public ILanguageManager getLanguageManger() {
        return this._languageManager;
    }

    public ScrollBar getVerticalBar() {
        return this._ganttComposite.getVerticalBar();
    }

    public ScrollBar getHorizontalBar() {
        return this._ganttComposite.getHorizontalBar();
    }

    public void addUndoRedoListener(IUndoRedoListener listener) {
        this._ganttComposite.getUndoRedoManager().addUndoRedoListener(listener);
    }

    public void removeUndoRedoListener(IUndoRedoListener listener) {
        this._ganttComposite.getUndoRedoManager().removeUndoRedoListener(listener);
    }

    public GanttUndoRedoManager getUndoRedoManager() {
        return this._ganttComposite.getUndoRedoManager();
    }

    public GanttEvent getRandomEvent() {
        Calendar cal = Calendar.getInstance(this._settings.getDefaultLocale());
        Calendar cal2 = Calendar.getInstance(this._settings.getDefaultLocale());
        Random random = new Random();
        cal.add(5, -random.nextInt(10));
        cal2.add(5, random.nextInt(10) + 1);
        return new GanttEvent(this, "Random Event", cal, cal2, random.nextInt(100));
    }
}

