/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.springframework.data.mongodb.core.mapping.DBRef;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.Terminal;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
@Table(name="assetGroupTransaction")
public class AssetGroupTransaction
implements Serializable {
    private static final long serialVersionUID = -2531243869129856727L;
    private Long id;
    private int weight;
    private Date date;
    private Date dateOfOperation;
    @DBRef(db="terminal")
    private Terminal terminal;
    private AssetGroup assetGroup;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ManyToOne
    @JoinColumn(name="terminalNumber", referencedColumnName="terminalId")
    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Date getDateOfOperation() {
        return this.dateOfOperation;
    }

    public void setDateOfOperation(Date dateOfOperation) {
        this.dateOfOperation = dateOfOperation;
    }

    @ManyToOne
    @JoinColumn(name="group_id", insertable=false, updatable=false)
    public AssetGroup getAssetGroup() {
        return this.assetGroup;
    }

    public void setAssetGroup(AssetGroup assetGroup) {
        this.assetGroup = assetGroup;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssetGroupTransaction [weight=");
        builder.append(this.weight);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", dateOfOperation=");
        builder.append(this.dateOfOperation);
        builder.append(", terminal=");
        builder.append(this.terminal);
        builder.append(", assetGroup=");
        builder.append(this.assetGroup);
        builder.append("]");
        return builder.toString();
    }
}

