/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.slider;

import com.richclientgui.toolbox.button.CoolButton;
import com.richclientgui.toolbox.slider.CoolSliderPositionChangeListener;
import com.richclientgui.toolbox.slider.CoolSliderToolTipInterpreter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CoolSlider
extends Composite {
    public static final int SMOOTH_STYLE = 0;
    public static final int SNAP_STYLE = 1;
    private final CoolSliderPanel rightmostRegion;
    private final CoolSliderPanel rightRegion;
    private final CoolButton thumb;
    private final CoolSliderPanel leftRegion;
    private final CoolSliderPanel leftmostRegion;
    private boolean mouseDown = false;
    private final boolean horizontal;
    private double jumpSize = 0.0;
    private final Object tooltipIntLock = new Object();
    private CoolSliderToolTipInterpreter toolTipInterperter;
    private final int minWidth;
    private final int minHeight;
    private final List<CoolSliderPositionChangeListener> positionChangedListeners = new ArrayList<CoolSliderPositionChangeListener>();
    private double previousPosition = -1.0;
    private int maximum = 100;
    private int minimum = 0;
    private int incrementValue = 1;
    private final boolean snapStyle;
    private final List<Integer> snapPoints = new ArrayList<Integer>();
    private int jumpIncrement = 1;
    private static final double EPSILON = 1.0E-5;

    public CoolSlider(Composite parent, int style, Image leftmost, Image left, Image thumbImageNormal, Image thumbImageHover, Image thumbImagePressed, Image right, Image rightmost) {
        this(parent, style, leftmost, left, thumbImageNormal, thumbImageHover, thumbImagePressed, thumbImageNormal, thumbImageHover, thumbImagePressed, right, rightmost);
    }

    public CoolSlider(Composite parent, int style, Image leftmost, Image left, Image thumbImageNormal, Image thumbImageHover, Image thumbImagePressed, Image thumbImageFocusedNormal, Image thumbImageFocusedHover, Image thumbImageFocusedPressed, Image right, Image rightmost) {
        super(parent, 0x20000000);
        this.horizontal = 512 != (style & 0x200);
        this.snapStyle = 1 == (style & 1);
        GridLayout gl = new GridLayout(this.horizontal ? 5 : 1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.minWidth = leftmost.getBounds().width + rightmost.getBounds().width + thumbImageNormal.getBounds().width;
        this.minHeight = leftmost.getBounds().height + rightmost.getBounds().height + thumbImageNormal.getBounds().height;
        this.leftmostRegion = new CoolSliderPanel(this, leftmost, this.horizontal, false, true);
        this.leftmostRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoolSlider.this.mouseDown = true;
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.moveThumbHorizontally(e.x);
                } else {
                    CoolSlider.this.moveThumbVertically(e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                CoolSlider.this.mouseDown = false;
            }
        });
        this.leftmostRegion.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolSlider.this.mouseDown) {
                    if (CoolSlider.this.horizontal) {
                        CoolSlider.this.moveThumbHorizontally(e.x);
                    } else {
                        CoolSlider.this.moveThumbVertically(e.y);
                    }
                }
            }
        });
        this.leftRegion = new CoolSliderPanel(this, left, this.horizontal);
        this.leftRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoolSlider.this.mouseDown = true;
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + e.x);
                } else {
                    CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                CoolSlider.this.mouseDown = false;
            }
        });
        this.leftRegion.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolSlider.this.mouseDown) {
                    if (CoolSlider.this.horizontal) {
                        CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + e.x);
                    } else {
                        CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + e.y);
                    }
                }
            }
        });
        this.thumb = new CoolButton(this, thumbImageNormal, thumbImageHover, thumbImagePressed, thumbImageNormal, thumbImageFocusedNormal, thumbImageFocusedHover, thumbImageFocusedPressed);
        this.thumb.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoolSlider.this.mouseDown = true;
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + e.x);
                } else {
                    CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                CoolSlider.this.mouseDown = false;
            }
        });
        this.thumb.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolSlider.this.mouseDown) {
                    if (CoolSlider.this.horizontal) {
                        CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + e.x);
                    } else {
                        CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + e.y);
                    }
                }
            }
        });
        this.thumb.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseHover(MouseEvent e) {
                double perc = -1.0;
                perc = CoolSlider.this.horizontal ? ((double)((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width * 1.0 + (double)((CoolSlider)CoolSlider.this).leftRegion.getBounds().width) / (double)(CoolSlider.this.getClientArea().width - ((CoolSlider)CoolSlider.this).thumb.getBounds().width) : ((double)((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + (double)((CoolSlider)CoolSlider.this).leftRegion.getBounds().height * 1.0) / (double)(CoolSlider.this.getClientArea().height - ((CoolSlider)CoolSlider.this).thumb.getBounds().height);
                Object object = CoolSlider.this.tooltipIntLock;
                synchronized (object) {
                    String tooltip;
                    if (CoolSlider.this.toolTipInterperter != null && (tooltip = CoolSlider.this.toolTipInterperter.getToolTipForPositionOnMouseHover(perc)) != null) {
                        CoolSlider.this.thumb.setToolTipText(tooltip);
                    }
                }
            }
        });
        this.rightRegion = new CoolSliderPanel(this, right, this.horizontal, true, false);
        this.rightRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoolSlider.this.mouseDown = true;
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + ((CoolSlider)CoolSlider.this).thumb.getBounds().width + e.x);
                } else {
                    CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + ((CoolSlider)CoolSlider.this).thumb.getBounds().height + e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                CoolSlider.this.mouseDown = false;
            }
        });
        this.rightRegion.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolSlider.this.mouseDown) {
                    if (CoolSlider.this.horizontal) {
                        CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + ((CoolSlider)CoolSlider.this).thumb.getBounds().width + e.x);
                    } else {
                        CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + ((CoolSlider)CoolSlider.this).thumb.getBounds().height + e.y);
                    }
                }
            }
        });
        this.rightmostRegion = new CoolSliderPanel(this, rightmost, this.horizontal, false, true);
        this.rightmostRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoolSlider.this.mouseDown = true;
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + ((CoolSlider)CoolSlider.this).thumb.getBounds().width + ((CoolSlider)CoolSlider.this).rightRegion.getBounds().width + e.x);
                } else {
                    CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + ((CoolSlider)CoolSlider.this).thumb.getBounds().height + ((CoolSlider)CoolSlider.this).rightRegion.getBounds().height + e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                CoolSlider.this.mouseDown = false;
            }
        });
        this.rightmostRegion.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (CoolSlider.this.mouseDown) {
                    if (CoolSlider.this.horizontal) {
                        CoolSlider.this.moveThumbHorizontally(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + ((CoolSlider)CoolSlider.this).thumb.getBounds().width + ((CoolSlider)CoolSlider.this).rightRegion.getBounds().width + e.x);
                    } else {
                        CoolSlider.this.moveThumbVertically(((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + ((CoolSlider)CoolSlider.this).thumb.getBounds().height + ((CoolSlider)CoolSlider.this).rightRegion.getBounds().height + e.y);
                    }
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (CoolSlider.this.snapStyle) {
                    CoolSlider.this.updateSnapPoints();
                }
                if (CoolSlider.this.horizontal) {
                    CoolSlider.this.doMoveThumbHorizontally((double)CoolSlider.this.getClientArea().width * CoolSlider.this.previousPosition, false);
                } else {
                    CoolSlider.this.doMoveThumbVertically((double)CoolSlider.this.getClientArea().height * CoolSlider.this.previousPosition, false);
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CoolSlider.this.thumb.setFocus();
            }
        });
        this.thumb.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (CoolSlider.this.horizontal) {
                    int currentThumbPos = ((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().width + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().width + ((CoolSlider)CoolSlider.this).thumb.getBounds().width / 2;
                    if (e.keyCode == 0x1000003) {
                        int newPos = 0;
                        newPos = CoolSlider.this.snapStyle ? currentThumbPos - (int)((double)CoolSlider.this.getClientArea().width / ((double)(CoolSlider.this.maximum - CoolSlider.this.minimum) * 1.0 / (double)CoolSlider.this.jumpIncrement)) : currentThumbPos - (int)((double)CoolSlider.this.getClientArea().width * CoolSlider.this.jumpSize);
                        if (newPos < 0) {
                            newPos = 0;
                        }
                        CoolSlider.this.moveThumbHorizontally(newPos);
                    } else if (e.keyCode == 0x1000004) {
                        int newPos = 0;
                        newPos = CoolSlider.this.snapStyle ? currentThumbPos + (int)((double)CoolSlider.this.getClientArea().width / ((double)(CoolSlider.this.maximum - CoolSlider.this.minimum) * 1.0 / (double)CoolSlider.this.jumpIncrement)) : currentThumbPos + (int)((double)CoolSlider.this.getClientArea().width * CoolSlider.this.jumpSize);
                        if (newPos > CoolSlider.this.getClientArea().width) {
                            newPos = CoolSlider.this.getClientArea().width;
                        }
                        CoolSlider.this.moveThumbHorizontally(newPos);
                    }
                } else {
                    int currentThumbPos = ((CoolSlider)CoolSlider.this).leftmostRegion.getBounds().height + ((CoolSlider)CoolSlider.this).leftRegion.getBounds().height + ((CoolSlider)CoolSlider.this).thumb.getBounds().height / 2;
                    if (e.keyCode == 0x1000001) {
                        int newPos = 0;
                        newPos = CoolSlider.this.snapStyle ? currentThumbPos - (int)((double)CoolSlider.this.getClientArea().height / ((double)(CoolSlider.this.maximum - CoolSlider.this.minimum) * 1.0 / (double)CoolSlider.this.jumpIncrement)) : currentThumbPos - (int)((double)CoolSlider.this.getClientArea().height * CoolSlider.this.jumpSize);
                        if (newPos < 0) {
                            newPos = 0;
                        }
                        CoolSlider.this.moveThumbVertically(newPos);
                    } else if (e.keyCode == 0x1000002) {
                        int newPos = 0;
                        newPos = CoolSlider.this.snapStyle ? currentThumbPos + (int)((double)CoolSlider.this.getClientArea().height / ((double)(CoolSlider.this.maximum - CoolSlider.this.minimum) * 1.0 / (double)CoolSlider.this.jumpIncrement)) : currentThumbPos + (int)((double)CoolSlider.this.getClientArea().height * CoolSlider.this.jumpSize);
                        if (newPos > CoolSlider.this.getClientArea().height) {
                            newPos = CoolSlider.this.getClientArea().height;
                        }
                        CoolSlider.this.moveThumbVertically(newPos);
                    }
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePositionChangeListener(CoolSliderPositionChangeListener listener) {
        List<CoolSliderPositionChangeListener> list = this.positionChangedListeners;
        synchronized (list) {
            this.positionChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPositionChangeListener(CoolSliderPositionChangeListener listener) {
        List<CoolSliderPositionChangeListener> list = this.positionChangedListeners;
        synchronized (list) {
            if (!this.positionChangedListeners.contains(listener)) {
                this.positionChangedListeners.add(listener);
            }
        }
    }

    public double getCurrentPosition() {
        if (this.horizontal) {
            return ((double)this.leftmostRegion.getBounds().width + (double)this.leftRegion.getBounds().width * 1.0) / (double)(this.getClientArea().width - this.thumb.getBounds().width);
        }
        return ((double)this.leftmostRegion.getBounds().height + (double)this.leftRegion.getBounds().height * 1.0) / (double)(this.getClientArea().height - this.thumb.getBounds().height);
    }

    private static boolean areDoubdlesEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePostionListeners(double perc) {
        if (!CoolSlider.areDoubdlesEqual(this.previousPosition, -1.0) && !CoolSlider.areDoubdlesEqual(perc, this.previousPosition)) {
            List<CoolSliderPositionChangeListener> list = this.positionChangedListeners;
            synchronized (list) {
                Iterator<CoolSliderPositionChangeListener> iter = this.positionChangedListeners.iterator();
                while (iter.hasNext()) {
                    iter.next().positionChanged(perc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTooltipMoving(double perc) {
        Object object = this.tooltipIntLock;
        synchronized (object) {
            String tooltip;
            if (this.toolTipInterperter != null && (tooltip = this.toolTipInterperter.getToolTipForPositionOnMouseMoveOver(perc)) != null) {
                this.thumb.setToolTipText(tooltip);
            }
        }
    }

    private void moveThumbHorizontally(double x) {
        this.moveThumbHorizontally(x, true);
    }

    private void moveThumbHorizontally(double x, boolean update) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (this.snapStyle && this.getClientArea().width > 0) {
            x = this.getClosestSnapPosition(x);
        }
        this.doMoveThumbHorizontally(x, update);
    }

    private void doMoveThumbHorizontally(double x, boolean update) {
        int width = (int)x - this.thumb.getBounds().width / 2 - this.leftmostRegion.getBounds().width;
        if (width > this.getClientArea().width - this.thumb.getBounds().width - this.rightmostRegion.getBounds().width) {
            width = this.getClientArea().width - this.thumb.getBounds().width - this.rightmostRegion.getBounds().width;
        }
        if (width == 0) {
            return;
        }
        if (width < 0) {
            int mW = this.leftmostRegion.getBounds().width + width;
            if (mW < 0) {
                mW = 0;
            }
            this.leftmostRegion.updatePosition(mW);
            width = 0;
        } else {
            this.leftmostRegion.resetToDefault();
        }
        this.leftRegion.updatePosition(width);
        this.layout();
        if (update) {
            double percentage = x / (double)this.getClientArea().width;
            percentage = this.snapStyle ? (double)(Math.round((double)(this.maximum - this.minimum) * percentage) + (long)this.minimum) : ((double)this.leftmostRegion.getBounds().width + (double)this.leftRegion.getBounds().width * 1.0) / (double)(this.getClientArea().width - this.thumb.getBounds().width);
            this.updateTooltipMoving(percentage);
            this.updatePostionListeners(percentage);
            this.previousPosition = percentage;
        }
    }

    private int getClosestSnapPosition(double distance) {
        int len = this.snapPoints.size();
        int cnt = 0;
        int val = this.snapPoints.get(cnt);
        int prevVal = this.snapPoints.get(cnt);
        while (cnt < len) {
            if ((double)val == distance || distance < (double)val && distance > (double)prevVal) {
                int mid = (val - prevVal) / 2 + prevVal;
                if (distance >= (double)mid) {
                    return val;
                }
                return prevVal;
            }
            prevVal = val;
            if (++cnt >= len) continue;
            val = this.snapPoints.get(cnt);
        }
        return this.snapPoints.get(len - 1);
    }

    private void moveThumbVertically(double y) {
        this.moveThumbVertically(y, true);
    }

    private void moveThumbVertically(double y, boolean update) {
        if (y < 0.0) {
            y = 0.0;
        }
        if (this.snapStyle && this.getClientArea().height > 0) {
            y = this.getClosestSnapPosition(y);
        }
        this.doMoveThumbVertically(y, update);
    }

    private void doMoveThumbVertically(double y, boolean update) {
        int height = (int)y - this.thumb.getBounds().height / 2 - this.leftmostRegion.getBounds().height;
        if (height > this.getClientArea().height - this.thumb.getBounds().height - this.rightmostRegion.getBounds().height) {
            height = this.getClientArea().height - this.thumb.getBounds().height - this.rightmostRegion.getBounds().height;
        }
        if (height == 0) {
            return;
        }
        if (height < 0) {
            int mH = this.leftmostRegion.getBounds().height + height;
            if (mH < 0) {
                mH = 0;
            }
            this.leftmostRegion.updatePosition(mH);
            height = 0;
        } else {
            this.leftmostRegion.resetToDefault();
        }
        this.leftRegion.updatePosition(height);
        this.layout();
        if (update) {
            double percentage = 0.0;
            if (this.snapStyle) {
                percentage = y / (double)this.getClientArea().height;
                percentage = Math.round((double)(this.maximum - this.minimum) * percentage) + (long)this.minimum;
            } else {
                percentage = ((double)this.leftmostRegion.getBounds().height + (double)this.leftRegion.getBounds().height * 1.0) / (double)(this.getClientArea().height - this.thumb.getBounds().height);
            }
            this.updateTooltipMoving(percentage);
            this.updatePostionListeners(percentage);
            this.previousPosition = percentage;
        }
    }

    public void setSnapValues(int max, int min, int incrementValue) {
        this.checkWidget();
        if (!this.snapStyle) {
            return;
        }
        if (min > max) {
            throw new IllegalArgumentException("The maximum must be greater than the minimum");
        }
        if (max < incrementValue) {
            throw new IllegalArgumentException("The maximum must be greater than the increment value");
        }
        if (max - min < incrementValue) {
            throw new IllegalArgumentException("The difference of the maximum and minimum must be greater than the increment value");
        }
        if (max < 0) {
            throw new IllegalArgumentException("The maximum must be a positive integer");
        }
        if (min < 0) {
            throw new IllegalArgumentException("The minimum must be a positive integer");
        }
        if (incrementValue < 0) {
            throw new IllegalArgumentException("The increment value must be a positive integer");
        }
        this.maximum = max;
        this.minimum = min;
        this.incrementValue = incrementValue;
        if (this.getClientArea().height > 0 && !this.horizontal || this.getClientArea().width > 0 && this.horizontal) {
            this.updateSnapPoints();
        }
    }

    private void updateSnapPoints() {
        this.snapPoints.clear();
        int increments = (int)((double)(this.maximum - this.minimum) * 1.0 / (double)this.incrementValue);
        int total = this.horizontal ? this.getClientArea().width : this.getClientArea().height;
        double ratio = (double)total * 1.0 / (double)increments;
        int i = 0;
        while (i < increments) {
            this.snapPoints.add(new Integer((int)(ratio * (double)i)));
            ++i;
        }
        this.snapPoints.add(new Integer(total));
    }

    public void setKeyMoveIncrement(double percentageJumpSize) {
        this.checkWidget();
        if (percentageJumpSize > 1.0 || percentageJumpSize < 0.0) {
            throw new IllegalArgumentException("The jump size specified must be a number between 0 and 1 (inclusive)");
        }
        this.jumpSize = percentageJumpSize;
    }

    public void setKeyMoveIncrement(int increment) {
        this.checkWidget();
        if (increment < 0) {
            throw new IllegalArgumentException("The increment must be a positive integer");
        }
        this.jumpIncrement = increment;
    }

    public void updateSlider(double percentage) {
        this.updateSlider(percentage, true);
    }

    public void updateSlider(double percentage, boolean updateListeners) {
        this.checkWidget();
        if (percentage < 0.0) {
            percentage = 0.0;
        } else if (percentage > 1.0) {
            percentage = 1.0;
        }
        if (this.horizontal) {
            this.moveThumbHorizontally((double)this.getClientArea().width * percentage, updateListeners);
        } else {
            this.moveThumbVertically((double)this.getClientArea().height * percentage, updateListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTooltipInterperter(CoolSliderToolTipInterpreter toolTipInterperter) {
        this.checkWidget();
        Object object = this.tooltipIntLock;
        synchronized (object) {
            this.toolTipInterperter = toolTipInterperter;
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.thumb.setBackground(color);
        this.rightRegion.setBackground(color);
        this.leftRegion.setBackground(color);
        this.leftmostRegion.setBackground(color);
        this.rightmostRegion.setBackground(color);
        super.setBackground(color);
    }

    public Point computeSize(int wHint, int hHint) {
        this.checkWidget();
        int width = this.minWidth;
        int height = this.minHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    private class CoolSliderPanel
    extends Composite {
        private final GridData gd;
        private final GridData gdDefault;
        private boolean layoutDatachanged;

        CoolSliderPanel(Composite parent, Image image, boolean horizontal) {
            this(parent, image, horizontal, false, false);
        }

        CoolSliderPanel(Composite parent, Image image, boolean horizontal, boolean lastFillerRegion, boolean lastmostRegion) {
            super(parent, 0);
            this.layoutDatachanged = false;
            this.gd = new GridData(lastFillerRegion && horizontal && !lastmostRegion ? 4 : 1, lastFillerRegion && !horizontal && !lastmostRegion ? 4 : 1, lastFillerRegion && horizontal && !lastmostRegion, lastFillerRegion && !horizontal && !lastmostRegion);
            this.gdDefault = new GridData(lastFillerRegion && horizontal && !lastmostRegion ? 4 : 1, lastFillerRegion && !horizontal && !lastmostRegion ? 4 : 1, lastFillerRegion && horizontal && !lastmostRegion, lastFillerRegion && !horizontal && !lastmostRegion);
            if (horizontal) {
                this.gd.minimumHeight = image.getBounds().height;
                this.gd.heightHint = image.getBounds().height;
                this.gdDefault.minimumHeight = image.getBounds().height;
                this.gdDefault.heightHint = image.getBounds().height;
            } else {
                this.gd.minimumWidth = image.getBounds().width;
                this.gd.widthHint = image.getBounds().width;
                this.gdDefault.minimumWidth = image.getBounds().width;
                this.gdDefault.widthHint = image.getBounds().width;
            }
            if (lastmostRegion) {
                this.gd.minimumHeight = image.getBounds().height;
                this.gd.heightHint = image.getBounds().height;
                this.gd.minimumWidth = image.getBounds().width;
                this.gd.widthHint = image.getBounds().width;
                this.gdDefault.minimumHeight = image.getBounds().height;
                this.gdDefault.heightHint = image.getBounds().height;
                this.gdDefault.minimumWidth = image.getBounds().width;
                this.gdDefault.widthHint = image.getBounds().width;
            }
            this.setLayoutData(this.gd);
            this.setBackgroundImage(image);
        }

        void updatePosition(int value) {
            this.layoutDatachanged = true;
            if (CoolSlider.this.horizontal) {
                this.gd.minimumWidth = value;
                this.gd.widthHint = value;
            } else {
                this.gd.minimumHeight = value;
                this.gd.heightHint = value;
            }
            this.setLayoutData(this.gd);
        }

        void resetToDefault() {
            if (this.layoutDatachanged) {
                this.setLayoutData(this.gdDefault);
                this.layoutDatachanged = false;
            }
        }
    }
}

