/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.propagate;

import com.richclientgui.toolbox.propagate.PropagateComposite;
import com.richclientgui.toolbox.propagate.PropagateWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class PropagateGroup
extends Group
implements PropagateWidget {
    private static final Logger logger = Logger.getLogger(PropagateComposite.class.getPackage().getName());
    private ArrayList<Control> disabledControls = new ArrayList();
    private boolean propagateBackgroundColor = false;
    private final List<Control> excludePropagateBackground = new ArrayList<Control>();
    private boolean propagateForegroundColor = false;
    private final List<Control> excludePropagateForeground = new ArrayList<Control>();
    private boolean propagateFont = true;
    private final List<Control> excludePropagateFont = new ArrayList<Control>();

    public PropagateGroup(Composite parent, int style) {
        super(parent, style);
    }

    public void setEnabled(boolean enable) {
        if (enable == this.getEnabled()) {
            return;
        }
        Control[] childControls = this.getChildren();
        int i = 0;
        while (i < childControls.length) {
            Control control = childControls[i];
            if (!enable && control.isEnabled()) {
                control.setEnabled(false);
            } else if (!enable && !control.isEnabled()) {
                this.disabledControls.add(control);
            } else if (enable && !this.disabledControls.contains(control)) {
                control.setEnabled(true);
            }
            ++i;
        }
        if (enable) {
            this.disabledControls.clear();
        }
        super.setEnabled(enable);
    }

    protected void checkSubclass() {
    }

    @Override
    public void setEnabledOfChild(Control control, boolean enable) {
        logger.log(Level.FINEST, "Set enabled state of " + control + " to " + enable);
        if (!Arrays.asList(this.getChildren()).contains(control)) {
            throw new IllegalArgumentException("Control is not a child of this group.");
        }
        boolean isCompositeEnabled = this.getEnabled();
        if (isCompositeEnabled) {
            control.setEnabled(enable);
        } else if (enable) {
            this.disabledControls.remove(control);
        } else if (!enable) {
            this.disabledControls.add(control);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!this.propagateBackgroundColor) {
            return;
        }
        Control[] childControls = this.getChildren();
        int i = 0;
        while (i < childControls.length) {
            Control currControl = childControls[i];
            if (!this.excludePropagateBackground.contains(currControl)) {
                currControl.setBackground(color);
            }
            ++i;
        }
    }

    public void setPropagateBackground(boolean value) {
        this.propagateBackgroundColor = value;
    }

    public boolean isPropogateBackground() {
        return this.propagateBackgroundColor;
    }

    public void excludeFromPropagateBackground(Control control) {
        this.excludePropagateBackground.add(control);
    }

    public void excludeFromPropagateBackground(List<Control> controls) {
        this.excludePropagateBackground.addAll(controls);
    }

    public void includePropagateBackground(Control control) {
        this.excludePropagateBackground.remove(control);
    }

    public void includePropagateBackground(List<Control> controls) {
        this.excludePropagateBackground.removeAll(controls);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (!this.propagateForegroundColor) {
            return;
        }
        Control[] childControls = this.getChildren();
        int i = 0;
        while (i < childControls.length) {
            Control currControl = childControls[i];
            if (!this.excludePropagateForeground.contains(currControl)) {
                currControl.setForeground(color);
            }
            ++i;
        }
    }

    public void setPropagateForeground(boolean value) {
        this.propagateForegroundColor = value;
    }

    public boolean isPropogateForeground() {
        return this.propagateForegroundColor;
    }

    public void excludeFromPropagateForeground(Control control) {
        this.excludePropagateForeground.add(control);
    }

    public void excludeFromPropagateForeground(List<Control> controls) {
        this.excludePropagateForeground.addAll(controls);
    }

    public void includePropagateForeground(Control control) {
        this.excludePropagateForeground.remove(control);
    }

    public void includePropagateForeground(List<Control> controls) {
        this.excludePropagateForeground.removeAll(controls);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (!this.propagateFont) {
            return;
        }
        Control[] childControls = this.getChildren();
        int i = 0;
        while (i < childControls.length) {
            Control currControl = childControls[i];
            if (!this.excludePropagateFont.contains(currControl)) {
                currControl.setFont(font);
            }
            ++i;
        }
    }

    public void setPropagateFont(boolean value) {
        this.propagateFont = value;
    }

    public boolean isPropogateFont() {
        return this.propagateFont;
    }

    public void excludeFromPropagateFont(Control control) {
        this.excludePropagateFont.add(control);
    }

    public void excludeFromPropagateFont(List<Control> controls) {
        this.excludePropagateFont.addAll(controls);
    }

    public void includePropagateFont(Control control) {
        this.excludePropagateFont.remove(control);
    }

    public void includePropagateFont(List<Control> controls) {
        this.excludePropagateFont.removeAll(controls);
    }
}

