/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.celleditors;

import com.richclientgui.toolbox.celleditors.ComboBoxCellEditorContentProvider;
import com.richclientgui.toolbox.celleditors.ComboBoxCellEditorLabelProvider;
import java.util.Arrays;
import java.util.Comparator;

public class SortedComboBoxCellEditorContentProvider<T>
implements ComboBoxCellEditorContentProvider<T> {
    private final ComboBoxCellEditorContentProvider<T> contentProvider;
    private Comparator<T> comparator = null;

    public SortedComboBoxCellEditorContentProvider(ComboBoxCellEditorContentProvider<T> contentProvider) {
        if (contentProvider == null) {
            throw new IllegalArgumentException("Content provider cannot be null.");
        }
        this.contentProvider = contentProvider;
    }

    public SortedComboBoxCellEditorContentProvider<T> setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public T[] getValues() {
        T[] values = this.contentProvider.getValues();
        Arrays.sort(values, this.getComparator());
        return values;
    }

    private Comparator<T> getComparator() {
        if (this.comparator == null) {
            this.comparator = new Comparator<T>(){

                @Override
                public int compare(T arg0, T arg1) {
                    if (arg0 == null && arg1 == null) {
                        return 0;
                    }
                    if (arg0 == null) {
                        return -1;
                    }
                    if (arg1 == null) {
                        return 1;
                    }
                    return arg0.toString().compareToIgnoreCase(arg1.toString());
                }
            };
        }
        return this.comparator;
    }

    public static <T> Comparator<T> constructLabelProviderComparator(final ComboBoxCellEditorLabelProvider<T> labelProvider) {
        return new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                if (arg0 == null && arg1 == null) {
                    return 0;
                }
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                String str0 = labelProvider.getLabel(arg0);
                return str0.compareToIgnoreCase(labelProvider.getLabel(arg1));
            }
        };
    }
}

