/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.dialogs.tags;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import su.artix.cashserver.cashtree.Activator;
import su.artix.cashserver.cashtree.domain.Tag;

public class TagDialog
extends TitleAreaDialog {
    private DataBindingContext m_bindingContext;
    private final Tag oldTag;
    private final String oldName;
    private final Tag tag;
    private Text text;

    public TagDialog(Tag tag) {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(3312);
        this.setHelpAvailable(false);
        this.tag = tag;
        this.oldTag = tag;
        this.oldName = tag.getName();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.oldTag.getName() == null) {
            this.getShell().setText("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438");
        } else {
            this.getShell().setText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438");
        }
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.marginWidth = 10;
        new Label(container, 0);
        Label label = new Label(container, 0);
        label.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.text = new Text(container, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_bindingContext = this.initDataBindings();
    }

    public Tag getTag() {
        return this.tag;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue textObserveTextObserveWidget = SWTObservables.observeText((Control)this.text, (int)24);
        IObservableValue tagNameObserveValue = PojoObservables.observeValue((Object)this.tag, (String)"name");
        bindingContext.bindValue((IObservableValue)textObserveTextObserveWidget, tagNameObserveValue, null, null);
        return bindingContext;
    }

    protected void okPressed() {
        if (this.oldName == null) {
            if (!Activator.getDefault().getTagModel().isExistTag(this.tag)) {
                super.okPressed();
            } else {
                this.messageErrorTagName();
            }
        } else if (this.oldName.equals(this.tag.getName()) || !Activator.getDefault().getTagModel().isExistTag(this.tag)) {
            super.okPressed();
        } else {
            this.messageErrorTagName();
        }
    }

    private void messageErrorTagName() {
        Display display = PlatformUI.createDisplay();
        MessageDialog.openError((Shell)display.getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u041c\u0435\u0442\u043a\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
    }

    protected boolean isResizable() {
        return true;
    }
}

