/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.core.cashregistry.repository;

import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import su.artix.cashserver.core.cashregistry.domain.Shop;

public interface ShopRepository
extends PagingAndSortingRepository<Shop, String> {
    @Query(value="{'parent.$ref':null}")
    public List<Shop> findRootShops();

    public List<Shop> findAll();

    @Query(value="{ 'code' : ?0 }")
    public Shop getShopByFQC(String var1);

    @Query(value="{ 'parent.$id': ?0}")
    public List<Shop> findByParentCode(String var1);

    @Query(value="{ 'parent.$id': ?0}", count=true)
    public int getCountByParentCode(String var1);

    @Query(value="{ 'parent.$id': {$in: ?0}}")
    public List<Shop> findByParentCodes(List<String> var1);

    @Query(value="{ 'tags.$id': ?0 }")
    public List<Shop> findByTagId(ObjectId var1);

    @Query(value="{ 'shopLabels.$id': ?0 }")
    public List<Shop> findByShopLabelId(ObjectId var1);

    @Query(value="{ 'shopLabels.$id': ?0 }", count=true)
    public int getCountShopsByShopLabelId(ObjectId var1);

    @Query(value="{ 'clusterId': ?0 }")
    public List<Shop> findByClusterId(String var1);

    @Query(value="{ 'displayCode' : ?0 }")
    public List<Shop> findByCode(String var1);

    @Query(value="{ 'displayCode' : ?0, 'clusterId': ?1 }")
    public List<Shop> findByCodeAndCluster(String var1, String var2);

    @Query(value="{ $or: [ { 'organizationExcise.$id': ?0 }, { 'organizationNonExcise.$id': ?0 } ] }")
    public List<Shop> findByOrganizationId(String var1);

    @Query(value="{ 'categories.$id': ?0 }", fields="{ 'parent': null, 'tags': null, 'shopLabels': null, 'categories': null, 'exchangeTypes': null, 'organizationExcise': null, 'organizationNonExcise': null }")
    public List<Shop> findByCategoryIdWithoutRefs(String var1);

    @Query(value="{ 'categories.$id': ?0 }", count=true)
    public int getByCategoryIdCount(String var1);
}

