/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.osgi.framework.Bundle;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;
import su.artix.yuki.discount.condition.domain.xml.TreeContainerNode;
import su.artix.yuki.discount.condition.domain.xml.TreeNode;

public class AstParser {
    PythonInterpreter interpreter;

    public AstParser() {
        String locatePythonHome;
        Bundle bundle = Platform.getBundle((String)"loyaltylib-domain-python");
        try {
            locatePythonHome = FileLocator.getBundleFile((Bundle)bundle).getAbsolutePath();
        }
        catch (IOException iOException) {
            locatePythonHome = bundle.getLocation().replaceFirst("reference:file:/", "");
        }
        PySystemState systemState = Py.getSystemState();
        systemState.path.append((PyObject)new PyString(String.valueOf(locatePythonHome) + "/Ast"));
        systemState.setdefaultencoding("utf-8");
        this.interpreter = new PythonInterpreter(null, systemState);
        this.interpreter.exec("import sys");
        this.interpreter.exec("from asttree import AstParser");
        this.interpreter.exec("parser = AstParser()");
    }

    public List<TreeNode> parse(String condition) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        condition = condition.replaceAll("'", "\\\\'").trim();
        this.interpreter.exec("result = parser.main('" + condition + "')");
        PyObject mas = this.interpreter.get("result");
        for (PyObject obj : mas.asIterable()) {
            TreeContainerNode root = new TreeContainerNode("", "", "");
            PyDictionary dict = (PyDictionary)obj;
            for (PyObject o : obj.asIterable()) {
                String nodeName = dict.get(o).asString();
                if (root.getName().equals("cf") || root.getName().equals("rf")) {
                    root.setName(String.valueOf(root.getName()) + "." + nodeName);
                    continue;
                }
                TreeContainerNode node = new TreeContainerNode(nodeName, nodeName, "");
                node.setParent((TreeNode)root);
                root.addNode((TreeNode)node);
                root = node;
            }
            list.add((TreeNode)root);
        }
        return list;
    }

    public AstParserContext parseSyntaxException(PySyntaxError ex) {
        AstParserContext context = new AstParserContext();
        context.setEx((PyException)ex);
        context.setType(ValidateResultType.ERROR);
        PyTuple tuple = (PyTuple)ex.value;
        PyObject obj = ((PyTuple)tuple.getArray()[1]).getArray()[2];
        context.setColumn(obj.asInt());
        PyString mesg = (PyString)tuple.getArray()[0];
        String exMessage = mesg.toString();
        String problemElement = StringUtils.substringBetween((String)exMessage, (String)"'", (String)"'");
        String msg = "";
        if (problemElement != null && !problemElement.isEmpty()) {
            if ("\\n".equals(problemElement) || "\\n\\n".equals(problemElement)) {
                msg = String.valueOf(msg) + "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0441\u043a\u043e\u0431\u043e\u043a ( ) [ ]. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0447\u0442\u043e \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e.";
                context.setUnknownObj(" ");
            } else {
                context.setUnknownObj(problemElement);
                msg = "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442: " + problemElement;
            }
        } else {
            msg = exMessage.contains("can't assign to ") ? "\u041d\u0435\u043b\u044c\u0437\u044f \u043a \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443 \u0438\u043b\u0438 \u043a \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u0440\u0438\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435" : exMessage;
        }
        context.setMessage(msg);
        return context;
    }

    public static class AstParserContext {
        private ValidateResultType type;
        private String message;
        private Color color;
        private int column;
        private String unknownObj;
        private PyException ex;

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public PyException getEx() {
            return this.ex;
        }

        public void setEx(PyException ex) {
            this.ex = ex;
        }

        public String getUnknownObj() {
            return this.unknownObj;
        }

        public void setUnknownObj(String unknownObj) {
            this.unknownObj = unknownObj;
        }

        public ValidateResultType getType() {
            return this.type;
        }

        public void setType(ValidateResultType type) {
            this.type = type;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    public static enum ValidateResultType {
        SUCCESS,
        WARNINNG,
        ERROR;

    }
}

