/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.trees;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import su.artix.discountmanager.trees.HistoryItemPlace;

class ListForItemChange {
    List<String> history = new ArrayList<String>();
    List<Map<String, Object>> historyMeta = new ArrayList<Map<String, Object>>();
    private static final int MAX_SIZE = 50;
    private boolean alreadyInited = false;
    private String firstItem = null;
    private int currentIndex = -2;

    ListForItemChange() {
    }

    public boolean add(String e, Map<String, Object> stepMeta) {
        if (!this.alreadyInited) {
            if (this.currentIndex == -2) {
                this.currentIndex = 0;
                this.alreadyInited = true;
                if (this.firstItem == null) {
                    this.firstItem = e;
                }
                this.history.add(e);
                this.historyMeta.add(stepMeta);
                return false;
            }
            throw new RuntimeException("List can't be null!");
        }
        if (this.currentIndex >= 0 && this.currentIndex < this.history.size() && this.history.get(this.currentIndex).equals(e)) {
            return false;
        }
        if (this.currentIndex < this.history.size() - 1) {
            while (this.currentIndex < this.history.size() - 1) {
                this.history.remove(this.currentIndex + 1);
                this.historyMeta.remove(this.currentIndex + 1);
            }
        }
        if (this.history.size() > 50) {
            this.history.remove(0);
            this.historyMeta.remove(0);
            this.currentIndex = this.history.size() - 1;
        }
        boolean rez = this.history.add(e);
        this.historyMeta.add(stepMeta);
        ++this.currentIndex;
        return rez;
    }

    public boolean isHistoryInitialized() {
        return this.alreadyInited;
    }

    public String getPreviousItem() {
        if (this.history.isEmpty()) {
            throw new RuntimeException("List can't be null!");
        }
        String item = null;
        if (this.currentIndex > 0 && this.currentIndex <= this.history.size() - 1) {
            item = this.history.get(this.currentIndex - 1);
        }
        if (this.currentIndex > 0 && this.currentIndex < this.history.size()) {
            --this.currentIndex;
        }
        return item;
    }

    public String getNextItem() {
        if (this.history.isEmpty()) {
            throw new RuntimeException("List can't be null!");
        }
        String item = null;
        if (this.currentIndex >= 0 && this.currentIndex < this.history.size() - 1) {
            item = this.history.get(this.currentIndex + 1);
        }
        if (this.currentIndex >= 0 && this.currentIndex < this.history.size() - 1) {
            ++this.currentIndex;
        }
        return item;
    }

    public HistoryItemPlace getPlaceOfPointer() {
        if (!this.alreadyInited) {
            return HistoryItemPlace.EMPTY;
        }
        if (this.currentIndex == 0) {
            if (this.history.size() == 1) {
                return HistoryItemPlace.EMPTY;
            }
            return HistoryItemPlace.FIRST;
        }
        if (this.currentIndex == this.history.size() - 1) {
            return HistoryItemPlace.LAST;
        }
        return HistoryItemPlace.MIDDLE;
    }

    public String getFirstValue() {
        if (this.history.isEmpty() || this.firstItem == null) {
            throw new RuntimeException("List can't be null!");
        }
        return this.firstItem;
    }

    public boolean setInitialValue(String firstItem) {
        if (firstItem != null) {
            this.firstItem = firstItem;
        }
        return false;
    }

    public String getCurrentItem() {
        if (this.alreadyInited) {
            return this.history.get(this.currentIndex);
        }
        throw new RuntimeException("List can't be null!");
    }

    public Map<String, Object> getCurrentHistoryMeta() {
        return this.historyMeta.get(this.currentIndex);
    }
}

