/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.transfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTransfer
extends ByteArrayTransfer {
    private static final Logger log = LoggerFactory.getLogger(ObjectTransfer.class);
    private static final String TYPENAME = "object";
    private static final int TYPEID = ObjectTransfer.registerType((String)"object");
    private static ObjectTransfer instance = new ObjectTransfer();

    public static ObjectTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.validate(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] buffer = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            Object object = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            return object;
        }
        return null;
    }

    protected boolean validate(Object object) {
        return object != null;
    }
}

