/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.discountmanager.providers.discountsystem.CachedTags;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;

public class DiscountTreeTagFilter
extends ViewerFilter {
    private static final Logger log = LoggerFactory.getLogger(DiscountTreeTagFilter.class);
    private Map<ShopGroupLabel, List<ShopLabel>> selected = Collections.emptyMap();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = true;
        if (element instanceof DiscountCampaign && !this.selected.isEmpty()) {
            for (ShopGroupLabel type : this.selected.keySet()) {
                List<String> selectedId = this.getSelectedId(this.selected.get(type));
                log.trace("selected={} element={}", selectedId, (Object)((DiscountCampaign)element).getCheckedTags());
                List<String> discountCampaignTags = this.getSimleTagList(((DiscountCampaign)element).getCheckedTags());
                if (!((DiscountCampaign)element).isTagsIsAllowed()) {
                    List<String> allTags = this.getSelectedId(CachedTags.getAllTags());
                    allTags.removeAll(discountCampaignTags);
                    discountCampaignTags = allTags;
                }
                if (CollectionUtils.containsAny(selectedId, discountCampaignTags)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private List<String> getSimleTagList(List<List<String>> checkedTags) {
        ArrayList<String> tags = new ArrayList<String>();
        for (List<String> args : checkedTags) {
            tags.addAll(args);
        }
        return tags;
    }

    private List<String> getSelectedId(List<ShopLabel> selected) {
        ArrayList<String> result = new ArrayList<String>();
        for (ShopLabel tag : selected) {
            result.add(tag.getCode());
        }
        return result;
    }

    public void setSelected(List<ShopLabel> list) {
        this.selected = new HashMap<ShopGroupLabel, List<ShopLabel>>();
        for (ShopLabel tag : list) {
            if (this.selected.containsKey(tag.getShopGroupLabel())) {
                this.selected.get(tag.getShopGroupLabel()).add(tag);
                continue;
            }
            ArrayList<ShopLabel> tags = new ArrayList<ShopLabel>();
            tags.add(tag);
            this.selected.put(tag.getShopGroupLabel(), tags);
        }
    }
}

