/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.discountsystem;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionConstructorDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionTemplateEditDialog;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;

public class EditDiscountConditionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(EditDiscountConditionHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block9: {
            DiscountCondition current = (DiscountCondition)((Event)event.getTrigger()).data;
            String title = null;
            try {
                title = event.getCommand().getName();
            }
            catch (NotDefinedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            boolean advancedConditionMode = preferenceStore.getBoolean("ADVANCED_CONDITION_MODE");
            if (current.getTemplate() != null && !advancedConditionMode) {
                if (current.getTemplate().getValues() != null && !current.getTemplate().getValues().isEmpty()) {
                    try {
                        ConstructorTreeProcessor processor = Activator.getDefault().getBeanByClass(ConstructorTreeProcessor.class, "treeProcessorImpl");
                        DiscountConditionTemplateEditDialog dialog = new DiscountConditionTemplateEditDialog(Display.getCurrent().getActiveShell(), current, processor, title);
                        if (dialog.open() != 0) break block9;
                        Discount parent = current.getParent();
                        DiscountCondition newCondition = dialog.getDiscountCondition();
                        if (newCondition != null) {
                            parent.deleteDiscountCondition(current);
                            log.trace("Deleted " + current.getClass());
                            parent.addDiscountCondition(newCondition);
                            log.trace("Added " + newCondition + " to " + parent);
                        }
                    }
                    catch (Exception exception) {
                        this.invokeConstructorDialog(current, title);
                    }
                } else {
                    this.invokeConstructorDialog(current, title);
                }
            } else {
                this.invokeConstructorDialog(current, title);
            }
        }
        return null;
    }

    private void invokeConstructorDialog(DiscountCondition condition, String title) {
        DiscountCondition newCondition;
        ConstructorTreeProcessor processor;
        Discount parent = condition.getParent();
        DiscountConditionConstructorDialog dialog = new DiscountConditionConstructorDialog(parent, condition, processor = Activator.getDefault().getBeanByClass(ConstructorTreeProcessor.class, "treeProcessorImpl"), null);
        if (dialog.open() == 0 && (newCondition = dialog.getDiscountCondition()) != null) {
            parent.deleteDiscountCondition(condition);
            log.trace("Deleted " + condition.getClass());
            parent.addDiscountCondition(newCondition);
            log.trace("Added " + newCondition + " to " + parent);
        }
    }
}

